/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarFile;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.CachedJarLoader;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCacheVersionException;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.UserProfile;

public class JarCache {
    protected static File directory;
    protected static int compression;
    protected static Hashtable loadedJars;
    protected static Hashtable currentJars;
    protected static long lastCacheModifyTime;
    protected static Hashtable filesInCache;
    protected static ReferenceQueue refQueue;
    protected static final String DATA_FILE_EXT = ".zip";
    protected static final String JAR_FILE_EXT = ".jar";
    protected static final String JARJAR_FILE_EXT = ".jarjar";
    protected static final String META_FILE_DIR = "meta-inf/";
    protected static final String COMPRESSION_PROP = "javaplugin.cache.compression";

    public static void init() {
    }

    public static JarFile get(URL uRL) {
        CachedJarFile cachedJarFile = null;
        if (Cache.cachingDisabled) {
            return null;
        }
        if (JarCache.isSupported(uRL)) {
            JarReference jarReference = (JarReference)loadedJars.get(uRL);
            if (jarReference != null) {
                cachedJarFile = (CachedJarFile)jarReference.get();
            }
            if (cachedJarFile == null) {
                try {
                    CachedJarLoader cachedJarLoader = (CachedJarLoader)currentJars.remove(uRL);
                    cachedJarFile = cachedJarLoader != null ? cachedJarLoader.load() : new CachedJarLoader(uRL, false).load();
                    loadedJars.put(uRL, new JarReference(cachedJarFile, refQueue, uRL));
                    while ((jarReference = (JarReference)refQueue.poll()) != null) {
                        loadedJars.remove(jarReference.getURL());
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Cache.message(ResourceHandler.getMessage("cache.cache_warning"), new Object[]{uRL});
                    cachedJarFile = null;
                }
            }
        }
        return cachedJarFile;
    }

    protected static final boolean isSupported(URL uRL) {
        return Cache.isSupportedProtocol(uRL);
    }

    protected static long getJarSize(URL uRL) throws IOException {
        long l = -1L;
        if (JarCache.isSupported(uRL)) {
            if (Cache.cachingDisabled) {
                l = Cache.getFileSizeFromServer(uRL);
            } else {
                CachedJarLoader cachedJarLoader = new CachedJarLoader(uRL, true);
                l = cachedJarLoader.getJarSize();
                currentJars.put(uRL, cachedJarLoader);
            }
        }
        return l;
    }

    protected static boolean checkJarVersion(URL uRL, FileVersion fileVersion) throws IOException {
        CachedJarLoader cachedJarLoader;
        boolean bl = true;
        if (JarCache.isSupported(uRL) && !Cache.cachingDisabled && !(cachedJarLoader = new CachedJarLoader(uRL, false)).isVersionUpToDate(fileVersion)) {
            cachedJarLoader.setVersion(fileVersion);
            JarReference jarReference = (JarReference)loadedJars.get(uRL);
            if (jarReference != null) {
                loadedJars.remove(uRL);
            }
            currentJars.put(uRL, cachedJarLoader);
            bl = false;
        }
        return bl;
    }

    protected static final File getDataFile(File file) {
        String string = file.getName();
        string = string.substring(0, string.length() - ".idx".length());
        string = string + DATA_FILE_EXT;
        return new File(file.getParentFile(), string);
    }

    protected static String generateCacheFileName(URL uRL) throws IOException {
        return Cache.generateCacheFileName(directory, uRL);
    }

    public static void clearLoadedJars() {
        loadedJars.clear();
        currentJars.clear();
        while (refQueue.poll() != null) {
        }
    }

    protected static Enumeration getMatchingFiles(URL uRL) {
        return Cache.getMatchingFiles(directory, uRL);
    }

    protected static boolean getMatchingFile(CachedJarLoader cachedJarLoader) throws IOException {
        boolean bl = false;
        String string = Cache.getKey(cachedJarLoader.getURL());
        bl = JarCache.match(cachedJarLoader, string);
        if (!bl && Cache.updateTable(directory, filesInCache, string)) {
            bl = JarCache.match(cachedJarLoader, string);
        }
        return bl;
    }

    protected static boolean match(CachedJarLoader cachedJarLoader, String string) throws IOException {
        boolean bl = false;
        ArrayList arrayList = (ArrayList)filesInCache.get(string);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File file2 = FileCache.getDataFile(file, cachedJarLoader.getURL());
                if (file.exists() && file2.exists()) {
                    bl = JarCache.verifyFile(file, cachedJarLoader);
                } else {
                    iterator.remove();
                    if (arrayList.size() == 0) {
                        filesInCache.remove(string);
                    }
                }
                if (!bl) continue;
                cachedJarLoader.setDataFile(file2);
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static boolean verifyFile(File file, CachedJarLoader cachedJarLoader) throws IOException {
        boolean bl;
        block11: {
            RandomAccessFile randomAccessFile;
            block10: {
                String string;
                bl = false;
                randomAccessFile = new RandomAccessFile(file, "r");
                if (randomAccessFile.readByte() != 16 || !(string = randomAccessFile.readUTF()).equals(cachedJarLoader.getURL().toString())) break block10;
                bl = true;
                cachedJarLoader.setIndexFile(file);
                cachedJarLoader.setLastModify(randomAccessFile.readLong());
                cachedJarLoader.setExpiration(randomAccessFile.readLong());
                randomAccessFile.readInt();
                String string2 = randomAccessFile.readUTF();
                cachedJarLoader.setVersion(new FileVersion(string2));
            }
            Object var7_8 = null;
            try {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    Object var7_9 = null;
                    try {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    catch (IOException iOException2) {}
                    break block11;
                }
                catch (JarCacheVersionException jarCacheVersionException) {
                    Object var7_10 = null;
                    try {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    static {
        loadedJars = new Hashtable();
        currentJars = new Hashtable();
        lastCacheModifyTime = 0L;
        filesInCache = new Hashtable();
        refQueue = new ReferenceQueue();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache.init();
                if (!Cache.cachingDisabled) {
                    directory = null;
                    String string = UserProfile.getNewJarCacheDir();
                    if (string != null) {
                        directory = new File(string.trim());
                    }
                    boolean bl = false;
                    if (directory != null) {
                        bl = directory.exists();
                        if (!bl) {
                            bl = directory.mkdirs();
                            if (!bl) {
                                Cache.message(ResourceHandler.getMessage("cache.create_warning"), new Object[]{directory.toString()});
                            }
                        } else if (!directory.canRead()) {
                            bl = false;
                            Cache.message(ResourceHandler.getMessage("cache.read_warning"), new Object[]{directory.toString()});
                        } else if (!directory.canWrite()) {
                            bl = false;
                            Cache.message(ResourceHandler.getMessage("cache.write_warning"), new Object[]{directory.toString()});
                        } else if (!directory.isDirectory()) {
                            bl = false;
                            Cache.message(ResourceHandler.getMessage("cache.directory_warning"), new Object[]{directory.toString()});
                        }
                    }
                    if (bl) {
                        Cache.createTable(directory, filesInCache);
                        string = System.getProperty(JarCache.COMPRESSION_PROP, "0");
                        string.trim();
                        try {
                            compression = Integer.valueOf(string);
                            if (compression < 0 || compression > 9) {
                                compression = 0;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            compression = 0;
                        }
                        Cache.message(ResourceHandler.getMessage("cache.compression"), new Object[]{String.valueOf(compression)});
                    }
                }
                return null;
            }
        });
    }

    protected static class JarReference
    extends WeakReference {
        URL url;

        public JarReference(Object object, ReferenceQueue referenceQueue, URL uRL) {
            super(object, referenceQueue);
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

