/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.Properties;
import javax.swing.SwingUtilities;
import sun.plugin.AppletViewer;
import sun.plugin.ConsoleWindow;
import sun.plugin.DebugOutputStream;
import sun.plugin.MainConsoleWriter;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;
import sun.security.action.GetPropertyAction;

public class JavaRunTime {
    private static boolean onWindows = false;
    private static Object syncObject = new Object();
    private static OutputStream traceStream = null;
    private static ConsoleWindow console = null;
    private static int hStatusIconWnd = 0;
    private static boolean noConsole = false;

    protected static void initEnvironment(String string, String string2, String string3) {
        Properties properties = System.getProperties();
        properties.put("java.home", string);
        if (string3 == null) {
            properties.put("user.home", string);
        } else {
            properties.put("user.home", string3);
        }
        properties.put("bridge.home", string2);
        AppletViewer.loadPropertiesFiles();
        try {
            String string4 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string4.indexOf("Windows") != -1) {
                onWindows = true;
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public static synchronized ConsoleWindow getJavaConsole() {
        if (console != null) {
            return console;
        }
        if (noConsole) {
            return null;
        }
        console = new ConsoleWindow();
        OutputStream outputStream = JavaRunTime.getTraceOutputStream();
        MainConsoleWriter mainConsoleWriter = new MainConsoleWriter(console, outputStream);
        DebugOutputStream debugOutputStream = new DebugOutputStream(mainConsoleWriter);
        PrintStream printStream = new PrintStream(debugOutputStream, true);
        System.setErr(printStream);
        DebugOutputStream debugOutputStream2 = new DebugOutputStream(mainConsoleWriter);
        PrintStream printStream2 = new PrintStream(debugOutputStream2, true);
        System.setOut(printStream2);
        String string = console.displayVersion();
        System.out.print(string);
        return console;
    }

    public static boolean isJavaConsoleVisible() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            if (onWindows) {
                return consoleWindow.isVisible();
            }
            return consoleWindow.getState() == 0;
        }
        return false;
    }

    public static void showJavaConsole(final boolean bl) {
        if (noConsole && !bl) {
            return;
        }
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (onWindows) {
                            if (consoleWindow.isVisible() != bl) {
                                consoleWindow.setVisible(bl);
                            }
                            if (bl) {
                                consoleWindow.toFront();
                            }
                        } else {
                            if (bl) {
                                consoleWindow.setState(0);
                            } else {
                                consoleWindow.setState(1);
                            }
                            consoleWindow.setVisible(true);
                        }
                        JavaRunTime.ConsoleStatus(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleLater(final boolean bl) {
        if (noConsole) {
            return;
        }
        final ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (onWindows) {
                            if (consoleWindow.isVisible() != bl) {
                                consoleWindow.setVisible(bl);
                            }
                            if (bl) {
                                consoleWindow.toFront();
                            }
                        } else {
                            if (bl) {
                                consoleWindow.setState(0);
                            } else {
                                consoleWindow.setState(1);
                            }
                            consoleWindow.setVisible(true);
                        }
                        JavaRunTime.ConsoleStatus(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void showJavaConsoleHelp() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            String string = consoleWindow.displayHelp();
            System.out.print(string);
        }
    }

    public static void showSystemProperties() {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.displaySystemProperties();
        }
    }

    public static void printToJavaConsole(String string) {
        ConsoleWindow consoleWindow = JavaRunTime.getJavaConsole();
        if (consoleWindow != null) {
            consoleWindow.append(string);
        }
    }

    public static void setStatusIconWindowHandle(int n) {
        hStatusIconWnd = n;
    }

    public static int getStatusIconWindowHandle() {
        return hStatusIconWnd;
    }

    public static OutputStream getTraceOutputStream() {
        if (traceStream != null) {
            return traceStream;
        }
        try {
            File file = new File(UserProfile.getTraceFile());
            if (file.exists()) {
                file.delete();
            }
            traceStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return traceStream;
    }

    public static native void ConsoleStatus(boolean var0);

    public static void setNoConsole(boolean bl) {
        noConsole = bl;
    }
}

