/*
 * Decompiled with CFR 0.152.
 */
package com.denova.runtime;

import com.denova.io.Log;
import com.denova.runtime.Exec;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import java.io.File;

public class JRE {
    static final String Quote = "\"";
    static final String Dot = ".";
    static final String Space = " ";
    static final String ClasspathSwitch = "-cp";
    public static final String SwingJarFilename = "swingall.jar";
    static final boolean debugging = false;
    static Log jreLog = null;
    static String swingPath = null;
    static String javaHome = null;
    static String javaVersion = null;

    public static String getActiveJavaHome() {
        String string = System.getProperty("java.home");
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static String getJavaHome() {
        if (javaHome == null || javaHome.length() <= 0) {
            javaHome = JRE.getActiveJavaHome();
            javaVersion = System.getProperty("java.version");
        }
        return javaHome;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static void setJavaHome(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            javaHome = string;
            if (!javaHome.endsWith(File.separator)) {
                javaHome = javaHome + File.separator;
            }
            javaVersion = "";
        }
    }

    public static void setJavaHome(String string, String string2) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            javaHome = string;
            javaVersion = string2;
            if (!javaHome.endsWith(File.separator)) {
                javaHome = javaHome + File.separator;
            }
        }
    }

    public static String getNativeExecutable(String string) {
        boolean bl = false;
        return JRE.getNativeExecutable(string, false);
    }

    public static String getNativeExecutable(String string, boolean bl) {
        String string2;
        if (string == null || string.length() <= 0) {
            string = "jre";
        }
        if (!((string2 = JRE.getNativeExecBaseName(string)) != null && string2.length() > 0 || !string.equalsIgnoreCase("jre") || (string2 = JRE.getNativeExecBaseName("java")) != null && string2.length() > 0)) {
            string2 = string;
        }
        if (OS.isWindows()) {
            String string3;
            File file;
            if (!bl && (file = new File(string3 = string2 + "w.exe")).exists()) {
                string2 = string2 + "w";
            }
            if (!string2.endsWith(".exe")) {
                string2 = string2 + ".exe";
            }
        }
        return string2;
    }

    public static String getNativeExecBaseName(String string) {
        String string2;
        String string3;
        File file;
        if (string == null || string.length() <= 0) {
            string = "jre";
        }
        if (!((file = new File(string3 = JRE.getJavaHome() + "bin" + File.separator + string)).exists() || (file = new File(string2 = string3 + ".exe")).exists() || (file = new File(string2 = string3 + ".bin")).exists())) {
            string3 = "";
        }
        return string3;
    }

    public static String getCommandPrefix(String string) {
        return JRE.getCommandPrefix(string, null);
    }

    public static String getCommandPrefix(String string, String string2) {
        boolean bl = false;
        return JRE.getCommandPrefix(string, string2, false);
    }

    public static String getCommandPrefix(String string, String string2, boolean bl) {
        Object var3_3 = null;
        boolean bl2 = false;
        return JRE.getCommandPrefix(string, string2, null, bl, false);
    }

    public static String getCommandPrefix(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4 = JRE.getSwingPath();
        boolean bl3 = false;
        String string5 = Quote + JRE.getNativeExecutable(string, bl) + Quote;
        if (string3 != null && string3.length() > 0) {
            string3 = string3.trim();
            string5 = string5 + string3;
        }
        string5 = string5 + " -cp ";
        if (bl2) {
            string5 = string5 + string4;
            string5 = string5 + File.pathSeparator;
        }
        if (string2 != null && string2.length() > 0) {
            if (string2.startsWith(Quote) && string2.endsWith(Quote)) {
                int n = string2.lastIndexOf(Quote);
                string2 = string2.substring(1, n);
            }
            String string6 = "";
            int n = string2.indexOf(File.pathSeparator);
            while (n != -1) {
                String string7 = string2.substring(0, n);
                if (string7.indexOf(Space) != -1) {
                    string7 = Quote + string7 + Quote;
                }
                if (string6.length() > 0) {
                    string6 = string6 + File.pathSeparator;
                }
                string6 = string6 + string7;
                if (n + 1 < string2.length()) {
                    string2 = string2.substring(n + 1);
                    n = string2.indexOf(File.pathSeparator);
                    continue;
                }
                n = -1;
            }
            if (string2.indexOf(Space) != -1) {
                string2 = Quote + string2 + Quote;
            }
            if (string6.length() > 0) {
                string6 = string6 + File.pathSeparator;
            }
            string6 = string6 + string2;
            string5 = string5 + string6;
        }
        string5 = string5 + Space;
        JRE.log("command prefix: " + string5);
        return string5;
    }

    public static void runCommand(String string) throws Exception {
        JRE.runCommand(string, null);
    }

    public static void runCommand(String string, String string2) throws Exception {
        JRE.runCommand(string, null, string2);
    }

    public static void runCommand(String string, File file) throws Exception {
        JRE.runCommand(string, null, file);
    }

    public static void runCommand(String string, String string2, String string3) throws Exception {
        if (string3 != null && string3.length() > 0) {
            JRE.runCommand(string, string2, new File(string3));
        } else {
            File file = null;
            JRE.runCommand(string, string2, file);
        }
    }

    public static void runCommand(String string, String string2, File file) throws Exception {
        JRE.log("Command: " + string);
        if (string2 != null) {
            JRE.log("Local classpath: " + string2);
        }
        String string3 = JRE.getCommandPrefix("jre", string2) + string;
        if (file == null) {
            Exec.runCommand(string3);
        } else {
            JRE.log("Directory: " + file.getPath());
            Exec.runCommand(string3, file);
        }
    }

    public static void launchCommand(String string, String string2, File file) throws Exception {
        boolean bl = false;
        JRE.launchCommand(string, string2, file, false);
    }

    public static void launchCommand(String string, String string2, File file, boolean bl) throws Exception {
        Object var4_4 = null;
        boolean bl2 = false;
        JRE.launchCommand(string, string2, null, file, bl, false);
    }

    public static void launchCommand(String string, String string2, String string3, File file, boolean bl, boolean bl2) throws Exception {
        JRE.log("Classname: " + string);
        if (string2 != null) {
            JRE.log("Local classpath: " + string2);
        }
        String string4 = JRE.getCommandPrefix("jre", string2, string3, bl, bl2) + string;
        JRE.log("Command: " + string4);
        if (file == null) {
            Exec.launchCommand(string4);
        } else {
            JRE.log("Directory: " + file.getPath());
            Exec.launchCommand(string4, file.getPath());
        }
    }

    public static void startAppWithoutWaiting(String string, String string2, String string3, File file, boolean bl, boolean bl2) throws Exception {
        JRE.log("Classname: " + string);
        if (string2 != null) {
            JRE.log("Local classpath: " + string2);
        }
        String string4 = JRE.getCommandPrefix("jre", string2, string3, bl, bl2) + string;
        JRE.log("Command: " + string4);
        if (file == null) {
            Exec.startAppWithoutWaiting(string4);
        } else {
            JRE.log("Directory: " + file.getPath());
            String string5 = JRE.adjustJreClasspath(string4, file.getPath(), true, bl2);
            JRE.log("Command after classpath adjustment: " + string5);
            Exec.startAppWithoutWaiting(string5);
        }
    }

    public static String getClasspath(String string) {
        String string2 = "";
        try {
            String[] stringArray = Exec.getCommandArray(string);
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                boolean bl = false;
                while (n < stringArray.length && !bl) {
                    if (stringArray[n].equals(ClasspathSwitch)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl && n < stringArray.length) {
                    string2 = stringArray[n];
                }
            }
        }
        catch (Exception exception) {
            JRE.log(exception);
        }
        JRE.log("getClasspath() = " + string2);
        return string2;
    }

    public static String adjustJreClasspath(String string, String string2, boolean bl) {
        return JRE.adjustJreClasspath(string, string2, bl, true);
    }

    public static String adjustJreClasspath(String string, String string2, boolean bl, boolean bl2) {
        JRE.log("command before adjustment: \"" + string + Quote);
        String string3 = "jre";
        String string4 = "java";
        String string5 = "";
        String[] stringArray = null;
        try {
            stringArray = Exec.getCommandArray(string);
            if (stringArray != null && stringArray.length > 0) {
                int n = 0;
                string5 = stringArray[n];
                File file = new File(string5);
                if (file != null) {
                    string5 = file.getName().toLowerCase();
                    if (string5.startsWith("jre") || string5.startsWith("java")) {
                        string = JRE.adjustJreClasspath(stringArray, string5, string2, bl, bl2);
                    }
                } else {
                    string5 = "";
                }
            }
        }
        catch (Exception exception) {
            JRE.log(exception);
        }
        JRE.log("command after adjustment: \"" + string + Quote);
        return string;
    }

    public static String adjustJreClasspath(String[] stringArray, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        String string4 = "jre";
        String string5 = "java";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl3 = string.startsWith("java");
        boolean bl4 = false;
        int n = 0;
        while (n < stringArray.length && !bl4) {
            if (stringArray[n].equals(ClasspathSwitch)) {
                bl4 = true;
            }
            string7 = string7 + stringArray[n];
            string7 = string7 + Space;
            ++n;
        }
        if (n < stringArray.length) {
            if (bl4) {
                string9 = stringArray[n];
                ++n;
            }
            while (n < stringArray.length) {
                string8 = string8 + Space;
                string8 = string8 + stringArray[n];
                ++n;
            }
        }
        string7 = string7.trim();
        string8 = string8.trim();
        if (bl) {
            string9 = JRE.changeDotsToCurrentDirectory(string9, string2);
        }
        if (bl2) {
            string3 = JRE.getSwingPath();
            if (string3.length() > 0) {
                if (string9.indexOf(string3) == -1) {
                    JRE.log("classpath before swing: \"" + string9 + Quote);
                    string9 = string9.trim() + File.pathSeparator + string3;
                    JRE.log("classpath after swing: \"" + string9 + Quote);
                } else {
                    JRE.log("classpath already contains swing");
                }
            } else if (!bl3) {
                JRE.log("no swing path found");
            }
        }
        if (OS.isWindows()) {
            String string10;
            string3 = "";
            int n2 = 0;
            int n3 = string9.indexOf(File.pathSeparatorChar);
            while (n3 != -1 && n2 >= 0 && n2 < string9.length() && n3 < string9.length()) {
                string10 = JRE.getWinShortName(string9.substring(n2, n3));
                string3 = string3.length() > 0 ? string3 + File.pathSeparator + string10 : string10;
                n2 = n3 + 1;
                n3 = n2 < string9.length() ? string9.indexOf(File.pathSeparatorChar, n2) : -1;
            }
            if (n2 > 0 && n2 < string9.length()) {
                string10 = JRE.getWinShortName(string9.substring(n2));
                string3 = string3.length() > 0 ? string3 + File.pathSeparator + string10 : string10;
            }
            if (string3.length() > 0) {
                string9 = string3;
            }
        } else if (string9.indexOf(32) != -1) {
            string9 = Quote + string9 + Quote;
        }
        string6 = JRE.convertFileSeparator(string7 + Space + string9 + Space + string8);
        return string6;
    }

    public static String convertFileSeparator(String string) {
        JRE.log("command before convertFileSeparator: \"" + string + Quote);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                if (n + 1 < string.length() && string.charAt(n + 1) == '/') {
                    stringBuffer.append(string.charAt(++n));
                } else {
                    stringBuffer.append(File.separatorChar);
                }
            } else if (string.charAt(n) == '/') {
                stringBuffer.append(File.separatorChar);
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            string = stringBuffer.toString();
        }
        JRE.log("command after conversion: \"" + string + Quote);
        return string;
    }

    static String changeDotsToCurrentDirectory(String string, String string2) {
        WindowsOS windowsOS;
        String string3;
        String string4 = string2;
        if (OS.isWindows() && (string3 = (windowsOS = new WindowsOS()).getAncientShortPath(string4)) != null && string3.length() > 0) {
            string4 = string3;
        }
        if (string.startsWith(Dot)) {
            if (string4.indexOf(Space) != -1) {
                string4 = Quote + string4 + Quote;
            }
            string = string4 + string.substring(1);
        }
        int n = string.indexOf(File.pathSeparator);
        while (n >= 0) {
            string3 = string.substring(n + File.pathSeparator.length());
            if (string3.startsWith(Dot)) {
                string = string.substring(0, n) + File.pathSeparator + string4 + string3.substring(Dot.length());
                n += string4.length();
            }
            n += File.pathSeparator.length();
            n = string.indexOf(File.pathSeparator, n);
        }
        return string;
    }

    public static void setSwingPath(String string) {
        swingPath = string;
    }

    public static String getSwingPath() {
        if (swingPath == null) {
            swingPath = JRE.getJavaHome() + "lib" + File.separator + SwingJarFilename;
            File file = new File(swingPath);
            if (file.exists()) {
                WindowsOS windowsOS;
                String string;
                if (OS.isWindows() && (string = (windowsOS = new WindowsOS()).getAncientShortPath(swingPath)) != null && string.length() > 0) {
                    swingPath = string;
                }
            } else {
                swingPath = "";
            }
            if (swingPath.length() > 0 && swingPath.indexOf(Space) != -1) {
                swingPath = Quote + swingPath + Quote;
            }
        }
        return swingPath;
    }

    private static String getWinShortName(String string) {
        if (string.length() > 0 && !string.startsWith(Dot)) {
            WindowsOS windowsOS;
            String string2;
            int n;
            if (string.startsWith(Quote) && string.endsWith(Quote) && (n = string.length() - 1) < string.length() && n >= 0) {
                string = string.substring(1, n);
            }
            if (string.length() > 0 && !string.startsWith(Quote) && (string2 = (windowsOS = new WindowsOS()).getAncientShortPath(string)) != null && string2.length() > 0) {
                string = string2;
            }
        }
        if (string.indexOf(Space) != -1) {
            string = Quote + string + Quote;
        }
        return string;
    }

    static String getSwingpathname() {
        String string = "";
        File file = new File(string);
        if (!file.exists()) {
            string = file.getPath();
        }
        return string;
    }

    static void log(String string) {
        String string2 = "JRE: " + string;
        JRE.startLogging();
        jreLog.write(string2);
        JRE.debug(string2);
    }

    static void log(Throwable throwable) {
        JRE.startLogging();
        jreLog.write(throwable);
    }

    static void startLogging() {
        if (jreLog == null) {
            jreLog = new Log("jre");
        }
    }

    static void debug(String string) {
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("\"C:\\Archivos de programa\\JavaSoft\\JRE1.3\\1.3\\bin\\install\"");
            JRE.launchCommand("com.denova.JExpress.Installer.JExpressInstaller -a http://10.0.0.2:10637/Hello/platforms/PureJava/Web/jex.control", "\".;C:\\Archivos de programa\\JavaSoft\\JRE1.3\\1.3\\bin\\install\\JExpressInstaller.jar\"", "", file, false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

