/*
 * Decompiled with CFR 0.152.
 */
package com.denova.runtime;

import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.runtime.OS;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;

public class Exec {
    static final boolean debugging = false;
    static Log execLog = null;
    public static final String WindowsCommandFilename = "_tempcmd.bat";
    public static final String UnixCommandFilename = ".tmpjcmd";
    static final String EndOfStreamToken = "qzEOSqz";
    static boolean launchBatchCommand = false;

    public static void runCommand(String string, String string2) throws Exception {
        Exec.runCommand(string, new File(string2));
    }

    public static void runCommand(String string, File file) throws Exception {
        Exec.log("runCommand: " + string);
        Exec.log("      from: " + file.getPath());
        if (OS.isWindows()) {
            string = Exec.getWindowsCommand(string, file.getPath());
        } else if (OS.isUnix()) {
            string = Exec.getUnixCommand(string, file.getPath());
        }
        Exec.log("batchCommand: " + string);
        Exec.runCommand(string);
        Exec.removeCommandFile();
    }

    public static void runCommand(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        if (stringArray != null && stringArray.length > 0) {
            Exec.runCommand(stringArray);
        }
    }

    public static void runCommand(String[] stringArray) throws Exception {
        Process process = Exec.execCommand(stringArray);
        Exec.log("about to waitFor process");
        process.waitFor();
        Exec.log("finished waiting for process");
        Exec.log("Custom command process result: " + process.exitValue());
    }

    public static String getCommandOutput(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = Exec.getCommandOutput(stringArray);
        }
        return string2;
    }

    public static String getCommandOutput(String[] stringArray) throws Exception {
        Process process = Exec.execCommand(stringArray);
        Exec.log("about to waitFor process");
        process.waitFor();
        Exec.log("finished waiting for process");
        int n = 50000;
        char[] cArray = new char[50000];
        StringBuffer stringBuffer = new StringBuffer(50000);
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
        int n2 = inputStreamReader.read(cArray);
        while (n2 >= 0) {
            stringBuffer.append(cArray, 0, n2);
        }
        Exec.log("Custom command process result: " + process.exitValue());
        return stringBuffer.toString();
    }

    public static void launchCommand(String string, String string2) throws Exception {
        File file = new File(string2);
        Exec.log("launchCommand: " + string);
        Exec.log("         from: " + file.getPath());
        launchBatchCommand = true;
        if (OS.isWindows()) {
            string = Exec.getWindowsCommand(string, file.getPath());
        } else if (OS.isUnix()) {
            string = Exec.getUnixCommand(string, file.getPath());
        }
        Exec.launchCommand(string);
        launchBatchCommand = false;
        Exec.removeCommandFile();
    }

    public static void launchCommand(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        if (stringArray != null && stringArray.length > 0) {
            Process process = Exec.execCommand(stringArray);
            if (launchBatchCommand && OS.isWindows()) {
                Exec.log("finished getRuntime. exec; waiting for process output");
                int n = 1000;
                while (process.getErrorStream().available() <= 0 && process.getInputStream().available() <= 0) {
                    Thread.sleep(1000L);
                    Thread.yield();
                }
                Thread.sleep(1000L);
                Thread.yield();
                Exec.log("about to get process output");
                Exec.logProcessOutput(process, stringArray[0]);
            } else {
                Exec.log("about to waitFor process");
                process.waitFor();
                Exec.log("Custom command process result: " + process.exitValue());
            }
        }
    }

    public static void startAppWithoutWaiting(String string) throws Exception {
        String[] stringArray = Exec.getCommandArray(string);
        if (stringArray != null && stringArray.length > 0) {
            Process process = Exec.execCommand(stringArray);
        }
    }

    public static String[] getCommandArray(String string) throws Exception {
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            object = new StringBuffer();
            char c = ' ';
            boolean bl = false;
            boolean bl2 = false;
            while (n < string.length() && !bl2) {
                if (bl) {
                    if (string.charAt(n) == c) {
                        bl = false;
                    }
                } else if (string.charAt(n) == ' ') {
                    bl2 = true;
                } else if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                    bl = true;
                    c = string.charAt(n);
                }
                if (!bl2) {
                    ((StringBuffer)object).append(string.charAt(n));
                }
                ++n;
            }
            if (object == null || ((StringBuffer)object).toString().length() <= 0) continue;
            vector.addElement(((StringBuffer)object).toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0 && OS.isUnix() && ((String)(object = objectArray[0])).indexOf(File.separator) < 0) {
            File file = new File((String)object);
            if (file.exists()) {
                object = "." + File.separator + (String)object;
            } else {
                String string2 = File.separator + "bin";
                file = new File(string2, (String)object);
                if (!(file.exists() || (file = new File(string2 = File.separator + "usr" + File.separator + "bin", (String)object)).exists() || (file = new File(string2 = File.separator + "sbin", (String)object)).exists())) {
                    string2 = File.separator + "usr" + File.separator + "sbin";
                    file = new File(string2, (String)object);
                }
                if (file.exists()) {
                    object = file.getPath();
                }
            }
            objectArray[0] = object;
        }
        return objectArray;
    }

    private static Process execCommand(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(" ") != -1 && !stringArray[n].startsWith("\"") && !stringArray[n].endsWith("\"")) {
                stringArray[n] = "\"" + stringArray[n] + "\"";
            }
            Exec.log("Command arg [" + n + "]: " + stringArray[n]);
            ++n;
        }
        Exec.log("about to getRuntime.exec ");
        Process process = Runtime.getRuntime().exec(stringArray);
        Exec.log("returned from getRuntime.exec ");
        return process;
    }

    static String getWindowsCommand(String string, String string2) {
        File file = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
        try {
            Exec.log("begin batch file");
            FileWriter fileWriter = new FileWriter(file.getPath());
            PrintWriter printWriter = new PrintWriter(fileWriter);
            if (string2.indexOf(":") == 1) {
                printWriter.println(string2.substring(0, 2));
                string2 = string2.substring(2);
            }
            printWriter.println("cd \"" + string2 + "\"");
            Exec.log("cd \"" + string2 + "\"");
            printWriter.println(string);
            Exec.log(string);
            if (launchBatchCommand) {
                printWriter.println("echo qzEOSqz");
                Exec.log("echo qzEOSqz");
            }
            printWriter.flush();
            fileWriter.flush();
            printWriter.close();
            fileWriter.close();
            Exec.log("end batch file");
            TempFiles.add(file.getPath());
            String string3 = OS.isWindows95() || OS.isWindows98() ? "command.com" : "CMD.exe";
            string = string3 + " /c " + "\"" + file.getPath() + "\"";
        }
        catch (Exception exception) {
            Exec.log(exception);
            file.delete();
        }
        return string;
    }

    static String getUnixCommand(String string, String string2) {
        block6: {
            String string3 = Exec.getProgramName(string);
            File file = new File(string2, string3);
            if (string3.length() > 0 && file.exists()) {
                string = "./" + string;
            }
            File file2 = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
            try {
                Exec.log("begin shell script");
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("cd " + string2);
                Exec.log("cd " + string2);
                printWriter.println(string);
                Exec.log(string);
                printWriter.flush();
                fileOutputStream.flush();
                printWriter.close();
                fileOutputStream.close();
                Exec.log("end shell script");
                TempFiles.add(file2.getPath());
                boolean bl = launchBatchCommand;
                launchBatchCommand = false;
                Exec.runCommand("chmod 0755 " + file2.getPath());
                Exec.log("chmod 0755 " + file2.getPath());
                if (file.exists()) {
                    Exec.runCommand("chmod 0755 " + file.getPath());
                    Exec.log("chmod 0755 " + file.getPath());
                }
                launchBatchCommand = bl;
                Thread.sleep(1000L);
                Thread.yield();
                string = "sh " + file2.getPath();
            }
            catch (Exception exception) {
                Exec.log(exception);
                file2.delete();
                if (string3.length() <= 0 || !file.exists()) break block6;
                try {
                    Exec.runCommand("chmod 0755 " + file.getPath());
                    Exec.log("chmod 0755 " + file.getPath());
                }
                catch (Exception exception2) {
                    Exec.log(exception2);
                }
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    static String getProgramName(String var0) {
        block3: {
            block4: {
                var1_1 = "";
                var2_2 = 0;
                if (var2_2 >= var0.length()) break block3;
                var3_3 = new StringBuffer();
                var4_4 = var0.charAt(var2_2);
                if (var4_4 != '\"' && var4_4 != '\'') ** GOTO lbl18
                ++var2_2;
                while (var2_2 < var0.length() && var0.charAt(var2_2) != var4_4) {
                    var3_3.append(var0.charAt(var2_2));
                    ++var2_2;
                }
                ++var2_2;
                break block4;
lbl-1000:
                // 1 sources

                {
                    var3_3.append(var0.charAt(var2_2));
                    ++var2_2;
lbl18:
                    // 2 sources

                    ** while (var2_2 < var0.length() && var0.charAt((int)var2_2) != ' ' && var0.charAt((int)var2_2) != '\t')
                }
lbl19:
                // 1 sources

                ++var2_2;
            }
            if (var3_3 != null && var3_3.toString().length() > 0) {
                var1_1 = var3_3.toString();
            }
        }
        return var1_1;
    }

    static boolean removeCommandFile() {
        boolean bl;
        try {
            File file = new File(TempFiles.getDefaultDirectory(), Exec.getCommandFilename());
            file.delete();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static String getCommandFilename() {
        String string = OS.isWindows() ? WindowsCommandFilename : UnixCommandFilename;
        return string;
    }

    static void logProcessOutput(Process process, String string) throws Exception {
        int n;
        int n2 = 50000;
        byte[] byArray = new byte[50000];
        boolean bl = false;
        Exec.log("entered logProcessOutput");
        while (process.getErrorStream().available() > 0) {
            Exec.log("Error executing " + string + ": ");
            bl = true;
            n = process.getInputStream().read(byArray);
            Exec.logStream(new ByteArrayInputStream(byArray, 0, n));
        }
        if (process.getInputStream().available() > 0 || !bl) {
            Exec.log("Output from " + string + ": ");
            try {
                n = 0;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (n == 0) {
                    String string2 = bufferedReader.readLine();
                    if (string2.endsWith(EndOfStreamToken)) {
                        n = 1;
                    } else if (string2 != null) {
                        Exec.log(string2);
                    }
                    Thread.yield();
                }
            }
            catch (Throwable throwable) {
                Exec.log(throwable);
            }
        }
        Exec.log("exiting logProcessOutput");
    }

    static void log(String string) {
        Exec.startLogging();
        execLog.write(string);
    }

    static void log(Throwable throwable) {
        Exec.startLogging();
        execLog.write(throwable);
    }

    static void logStream(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                Exec.log(string);
                Thread.yield();
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            Exec.log(throwable);
        }
    }

    static void startLogging() {
        if (execLog == null) {
            execLog = new Log("exec");
        }
    }

    public static void main(String[] stringArray) {
        try {
            Exec.runCommand("dir >test.zos");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

