/*
 * Decompiled with CFR 0.152.
 */
package com.denova.lang;

import com.denova.io.FileSystem;
import com.denova.util.DataFinder;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class LangUtilities {
    static Exception lastException;
    static String lastError;

    public static boolean getResourceAsFile(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            InputStream inputStream = LangUtilities.getResourceAsStream(file.getName());
            if (inputStream != null) {
                FileSystem.copyStreamToFile(inputStream, string);
                bl = true;
            } else {
                LangUtilities.rememberError("Unable to get resource " + file.getName() + " as file " + string);
            }
        }
        catch (Exception exception) {
            LangUtilities.rememberError(exception);
        }
        return bl;
    }

    public static URL getResource(String string) {
        return new LangUtilities().getClass().getResource(string);
    }

    public static InputStream getResourceAsStream(String string) {
        InputStream inputStream = DataFinder.getStream(string);
        if (inputStream == null) {
            try {
                inputStream = new LangUtilities().getClass().getResourceAsStream(string);
            }
            catch (Exception exception) {
                inputStream = null;
            }
        }
        if (inputStream == null) {
            try {
                URL uRL = LangUtilities.getResource(string);
                if (uRL != null) {
                    inputStream = uRL.openStream();
                }
            }
            catch (Exception exception) {
                inputStream = null;
                LangUtilities.rememberError(exception);
            }
        }
        return inputStream;
    }

    public static boolean isError() {
        return lastException != null || lastError != null;
    }

    public static Exception getLastException() {
        return lastException;
    }

    public static String getLastError() {
        return lastError;
    }

    public static void clearError() {
        lastException = null;
        lastError = null;
    }

    public static void rememberError(Exception exception) {
        lastException = exception;
        lastError = exception.toString();
    }

    public static void rememberError(String string) {
        lastException = null;
        lastError = string;
    }

    public static void rememberError(String string, Exception exception) {
        lastException = exception;
        lastError = string;
    }
}

