/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.FileSystem;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.ui.TextDisplayable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    static Hashtable zipFileCache = new Hashtable();
    static Vector badZipFileCache = new Vector();
    static Log zipLog;
    static Vector files;
    static TextDisplayable textDisplay;

    public static void unzipFiles(String string) throws Exception {
        Zipper.unzipFilesToDirectory(string, System.getProperty("user.dir"));
    }

    public static void unzipFilesToDirectory(String string, File file) throws Exception {
        Zipper.unzipFilesToDirectory(string, file.getPath());
    }

    public static void unzipFilesToDirectory(String string, String string2) throws Exception {
        Zipper.unzipFilesToDirectory(new FileInputStream(string), string2);
    }

    public static void unzipFilesToDirectory(InputStream inputStream, String string) throws Exception {
        Zipper.unzipFilesToDirectory(new ZipInputStream(inputStream), string);
        inputStream.close();
    }

    public static void unzipFilesToDirectory(ZipInputStream zipInputStream, String string) throws Exception {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            int n = 50000;
            String string2 = zipEntry.getName().replace('/', File.separatorChar);
            Zipper.log("Unzipping " + string2);
            File file = new File(string, string2);
            if (file.getParent() != null) {
                Zipper.makeDirs(file.getParent());
            }
            if (!file.isDirectory()) {
                Zipper.addToCleanupFiles(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[50000];
                int n2 = zipInputStream.read(byArray, 0, 50000);
                while (n2 >= 0) {
                    fileOutputStream.write(byArray, 0, n2);
                    n2 = zipInputStream.available() > 0 ? zipInputStream.read(byArray, 0, 50000) : 0;
                }
                fileOutputStream.close();
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
            Thread.yield();
        }
        zipInputStream.close();
    }

    public static void zipFilesFromDirectory(String string, File file) throws Exception {
        Zipper.zipFilesFromDirectory(string, file.getPath());
    }

    public static void zipFilesFromDirectory(String string, String string2) throws Exception {
        Zipper.zipFilesFromDirectory(new FileOutputStream(string), string2);
    }

    public static void zipFilesFromDirectory(OutputStream outputStream, String string) throws Exception {
        Zipper.zipFilesFromDirectory(new ZipOutputStream(outputStream), string);
        outputStream.close();
    }

    public static void zipFilesFromDirectory(ZipOutputStream zipOutputStream, String string) throws Exception {
        Zipper.zipFilesFromDirectory(zipOutputStream, string, true);
    }

    public static void zipFilesFromDirectory(ZipOutputStream zipOutputStream, String string, boolean bl) throws Exception {
        File file = new File(string);
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 50000;
            String string2 = stringArray[n];
            File file2 = new File(file, string2);
            FileSystem.copyFileToZipStream(file2, string2, file, zipOutputStream);
            ++n;
        }
        if (bl) {
            zipOutputStream.close();
        }
    }

    public static void setTextDisplay(TextDisplayable textDisplayable) {
        textDisplay = textDisplayable;
    }

    public static TextDisplayable getTextDisplay() {
        return textDisplay;
    }

    static void makeDirs(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Zipper.addToCleanupFiles(file);
            String string2 = file.getParent();
            if (string2 != null) {
                Zipper.makeDirs(string2);
            }
            file.mkdir();
        }
    }

    public static ZipFile getZipFile(String string) {
        ZipFile zipFile = null;
        try {
            File file;
            zipFile = (ZipFile)zipFileCache.get(string);
            if (zipFile == null && (file = new File(string)).exists()) {
                zipFile = new ZipFile(string);
            }
            if (zipFile != null) {
                zipFileCache.put(string, zipFile);
            } else {
                Zipper.logBadZipFile(string);
            }
        }
        catch (Exception exception) {
            Zipper.logBadZipFile(string);
            Zipper.log(exception);
        }
        return zipFile;
    }

    public static ZipEntry getZipEntry(ZipFile zipFile, String string) {
        ZipEntry zipEntry = null;
        try {
            if (zipFile != null) {
                zipEntry = zipFile.getEntry(string);
                if (zipEntry == null) {
                    String string2 = string.replace(File.separatorChar, '/');
                    zipEntry = zipFile.getEntry(string2);
                }
                if (zipEntry == null) {
                    Zipper.log("Unable to get entry from archive: " + string + " from " + zipFile.getName());
                }
            }
        }
        catch (Exception exception) {
            String string3 = "Error getting entry from archive: " + string + " from " + zipFile.getName();
            Zipper.log(string3);
            Zipper.log(exception);
        }
        return zipEntry;
    }

    static void logBadZipFile(String string) {
        if (!badZipFileCache.contains(string)) {
            badZipFileCache.addElement(string);
            Zipper.log("Unable to open zip file: " + string);
        }
    }

    public static void addToCleanupFiles(String string) {
        File file = new File(string);
        Zipper.addToCleanupFiles(file);
    }

    public static void addToCleanupFiles(File file) {
        if (files == null) {
            files = new Vector();
        }
        files.addElement(file);
    }

    public static void cleanupFiles() {
        if (files != null) {
            Enumeration enumeration = files.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                file.delete();
                Thread.yield();
            }
            files = null;
        }
    }

    private static void log(String string) {
        Zipper.startLog();
        zipLog.write(string);
        if (textDisplay != null) {
            textDisplay.displayText(string);
        }
    }

    private static void log(Exception exception) {
        Zipper.startLog();
        zipLog.write(exception);
    }

    private static void startLog() {
        if (zipLog == null) {
            File file = TempFiles.getDefaultDirectory();
            zipLog = file != null ? new Log(file.toString(), "zipper") : new Log("zipper");
        }
    }

    static {
        files = new Vector();
    }
}

