/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.Log;
import com.denova.runtime.OS;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class TempFiles {
    static Log log;
    static Vector files;
    static boolean cleanupEnabled;
    static File defaultDirectory;

    public static void makeDirs(String string) {
        TempFiles.makeDirs(new File(string));
    }

    public static void makeDirs(File file) {
        if (!file.exists()) {
            TempFiles.add(file);
            String string = file.getParent();
            if (string != null) {
                TempFiles.makeDirs(string);
            }
            file.mkdir();
        }
    }

    public static void add(String string) {
        TempFiles.add(new File(string));
    }

    public static void add(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            files.addElement(file);
        }
    }

    public static void add(File file) {
        if (cleanupEnabled) {
            TempFiles.debug("Added " + file.getPath());
            files.addElement(file);
        }
    }

    public static void delete() {
        File file;
        Vector<File> vector = new Vector<File>();
        Enumeration enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            file = (File)enumeration.nextElement();
            if (file.isDirectory()) continue;
            if (file.delete()) {
                TempFiles.debug("Deleted " + file.getPath());
                continue;
            }
            TempFiles.debug("Unable to delete " + file.getPath());
            vector.addElement(file);
        }
        enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            file = (File)enumeration.nextElement();
            if (!file.isDirectory()) continue;
            TempFiles.deleteEmptySubdirs(file, vector);
            if (file.delete()) {
                TempFiles.debug("Deleted directory " + file.getPath());
                continue;
            }
            TempFiles.debug("Unable to delete directory " + file.getPath());
            vector.addElement(file);
        }
        files = vector;
    }

    public static void setDefaultDirectory(String string) {
        TempFiles.setDefaultDirectory(new File(string));
    }

    public static void setDefaultDirectory(File file) {
        defaultDirectory = file;
    }

    public static File getDefaultDirectory() {
        if (defaultDirectory == null) {
            defaultDirectory = new File(System.getProperty("user.dir", "."));
        }
        return defaultDirectory;
    }

    public static File getFile(File file) {
        return TempFiles.getFile(file.getPath());
    }

    public static File getFile(String string) {
        File file = string.startsWith(File.separator) || OS.isWindows() && string.indexOf(":") == 1 ? new File(string) : new File(TempFiles.getDefaultDirectory(), string);
        TempFiles.add(file);
        return file;
    }

    static void deleteEmptySubdirs(File file, Vector vector) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                TempFiles.deleteEmptySubdirs(file2, vector);
                if (file2.delete()) {
                    TempFiles.debug("Deleted directory " + file2.getPath());
                } else {
                    TempFiles.debug("Unable to delete directory " + file2.getPath());
                    vector.addElement(file2);
                }
            }
            ++n;
        }
    }

    public static void setCleanupEnabled(boolean bl) {
        cleanupEnabled = bl;
    }

    public static boolean getCleanupEnabled() {
        return cleanupEnabled;
    }

    static void debug(String string) {
        if (log == null) {
            log = new Log("tempFiles");
        }
        if (log != null) {
            log.write("TempFiles: " + string);
        }
    }

    static {
        files = new Vector();
        cleanupEnabled = true;
        defaultDirectory = null;
    }
}

