/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.TempFiles;
import com.denova.ui.TextDisplayable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Date;
import java.util.StringTokenizer;

public class Log {
    static final boolean debugging = false;
    static final String logSuffix = ".log";
    static boolean alwaysFlush = false;
    static boolean useTempDir = false;
    String logFilename;
    boolean logging;
    boolean enabled;
    RandomAccessFile out;
    TextDisplayable statusDisplay;
    Log log2;

    private File getDir() {
        File file = null;
        if (useTempDir) {
            file = TempFiles.getDefaultDirectory();
            this.debug("using temp dir " + file);
        }
        if (file == null || file.getPath().length() <= 0) {
            file = new File(System.getProperty("user.dir", "."));
            this.debug("using user.dir " + file);
        }
        return file;
    }

    private void initLog(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(logSuffix)) {
            stringBuffer.append(logSuffix);
        }
        File file2 = new File(file, stringBuffer.toString());
        try {
            this.logFilename = file2.getAbsolutePath();
            this.debug("initing absolute path for log " + this.logFilename);
        }
        catch (Exception exception) {
            this.logFilename = file2.getPath();
            this.debug("initing log " + this.logFilename);
        }
        file2 = new File(this.logFilename);
        this.setLogging(file2.exists());
        this.debug("log exists " + String.valueOf(file2.exists()));
    }

    public void end() {
        this.stopLogging();
    }

    public synchronized void write(String string) {
        if (this.enabled) {
            if (!this.logging) {
                this.startLogging();
            }
            if (this.logging || this.log2 != null) {
                Date date = new Date();
                StringBuffer stringBuffer = new StringBuffer(date.toLocaleString());
                stringBuffer.append(": ");
                stringBuffer.append(string);
                stringBuffer.append(System.getProperty("line.separator"));
                if (this.logging) {
                    this.output(stringBuffer.toString());
                }
                if (this.log2 != null) {
                    this.log2.write(stringBuffer.toString());
                }
            }
            if (alwaysFlush) {
                this.flush();
            }
            if (this.statusDisplay != null) {
                this.statusDisplay.displayText(string);
            }
        }
    }

    public void write(Throwable throwable) {
        this.logException(throwable);
    }

    public void write(Throwable throwable, String string) {
        this.write(string);
        this.logException(throwable);
    }

    public boolean getLogging() {
        return this.logging;
    }

    public void setLogging(boolean bl) {
        if (bl) {
            this.enabled = true;
        } else {
            this.stopLogging();
        }
    }

    public TextDisplayable getStatusDisplay() {
        return this.statusDisplay;
    }

    public void setStatusDisplay(TextDisplayable textDisplayable) {
        this.statusDisplay = textDisplayable;
    }

    public Log getAlsoLogTo() {
        return this.log2;
    }

    public void setAlsoLogTo(Log log) {
        this.log2 = log;
    }

    public void startLogging() {
        if (!this.logging) {
            try {
                File file = new File(this.logFilename);
                this.out = new RandomAccessFile(file, "rw");
                this.out.seek(this.out.length());
                this.logging = true;
                this.output(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {
                System.err.println("Exception: " + iOException);
                iOException.printStackTrace();
            }
        }
    }

    public void stopLogging() {
        if (this.logging) {
            this.write("Ended logging");
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                System.err.println("Exception: " + iOException);
                iOException.printStackTrace();
            }
            this.logging = false;
        }
        this.enabled = false;
    }

    public void flush() {
        if (this.enabled && this.logging) {
            try {
                this.out.close();
                this.out = new RandomAccessFile(new File(this.logFilename), "rw");
                this.out.seek(this.out.length());
            }
            catch (Exception exception) {
                System.err.println("Exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    public static void setAlwaysFlush(boolean bl) {
        alwaysFlush = bl;
    }

    public static boolean getAlwaysFlush() {
        return alwaysFlush;
    }

    public static void setUseTempDirectory(boolean bl) {
        useTempDir = bl;
    }

    public static boolean getUseTempDirectory() {
        return useTempDir;
    }

    void output(String string) {
        try {
            this.out.writeBytes(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception: " + iOException);
            iOException.printStackTrace();
        }
    }

    void logException(Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                this.write(string);
                if (this.logging) continue;
                System.err.println(string);
            }
        }
    }

    String exceptionMessage(Throwable throwable) {
        return "Exception: " + throwable.getMessage();
    }

    private void debug(String string) {
    }

    public Log(String string, String string2) {
        this.initLog(new File(string), string2);
    }

    public Log(File file, String string) {
        if (file == null || file.getPath().length() <= 0) {
            file = this.getDir();
        }
        this.initLog(file, string);
    }

    public Log(String string) {
        this.initLog(this.getDir(), string);
    }
}

