/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.FixZipBugInputFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class LineEndingInputFilter
extends InputStream {
    static String textExtensions;
    final int LF;
    final int CR;
    InputStream source;
    boolean isText;
    byte[] eol;
    boolean eolPending;
    int eolIndex;

    public int available() throws IOException {
        int n = this.source.available();
        if (this.isText && this.eolPending) {
            n += this.eol.length - this.eolIndex;
        }
        return n;
    }

    public int read() throws IOException {
        int n = this.isText && this.eolPending ? this.nextEolByte() : this.nextByte();
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.isText) {
            n3 = 0;
            while (this.available() > 0 && n3 < n2) {
                byArray[n] = (byte)this.read();
                ++n3;
                ++n;
            }
            if (n3 <= 0 && this.available() <= 0) {
                n3 = -1;
            }
        } else {
            n3 = this.source.read(byArray, n, n2);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while (l > 0L) {
            this.read();
            ++n;
            --l;
        }
        return n;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public synchronized void mark(int n) {
        this.source.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.source.reset();
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    int nextByte() throws IOException {
        int n = this.source.read();
        if (this.isText && n != -1) {
            if ((n &= 0xFF) == 13) {
                n = this.source.read();
            }
            if (n == 10) {
                n = this.startEol();
            }
        }
        return n;
    }

    int startEol() {
        this.eolPending = true;
        this.eolIndex = 0;
        return this.nextEolByte();
    }

    int nextEolByte() {
        byte by = this.eol[this.eolIndex];
        ++this.eolIndex;
        if (this.eolIndex >= this.eol.length) {
            this.eolPending = false;
        }
        return by;
    }

    public static void setTextExtensions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n.*");
        while (stringTokenizer.hasMoreTokens()) {
            textExtensions = textExtensions == null || textExtensions == "" ? stringTokenizer.nextToken() : textExtensions + " " + stringTokenizer.nextToken();
        }
    }

    public static String getTextExtensions() {
        return textExtensions;
    }

    public void setIsText(boolean bl) {
        this.isText = bl;
    }

    public boolean getIsText() {
        return this.isText;
    }

    public LineEndingInputFilter(InputStream inputStream) {
        this(inputStream, true);
    }

    public LineEndingInputFilter(String string, InputStream inputStream) {
        this(string, inputStream, true);
    }

    public LineEndingInputFilter(String string, InputStream inputStream, boolean bl) {
        this(inputStream, bl);
        if (textExtensions != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(textExtensions);
            while (stringTokenizer.hasMoreTokens() && !this.isText) {
                this.isText = string.endsWith("." + stringTokenizer.nextToken());
            }
        }
    }

    public LineEndingInputFilter(InputStream inputStream, boolean bl) {
        this.LF = 10;
        this.CR = 13;
        this.source = bl ? new FixZipBugInputFilter(inputStream) : inputStream;
        this.eol = System.getProperty("line.separator").getBytes();
        this.isText = false;
    }
}

