/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.image.PixelConverter;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.Win32Renderer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.security.action.GetPropertyAction;

public class Win32SurfaceData
extends SurfaceData {
    WComponentPeer peer;
    private Win32GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    public static final String DESC_INT_RGB_DD = "Integer RGB DirectDraw";
    public static final String DESC_INT_RGBx_DD = "Integer RGBx DirectDraw";
    public static final String DESC_USHORT_565_RGB_DD = "Short 565 RGB DirectDraw";
    public static final String DESC_USHORT_555_RGBx_DD = "Short 555 RGBx DirectDraw";
    public static final String DESC_USHORT_555_RGB_DD = "Short 555 RGB DirectDraw";
    public static final String DESC_BYTE_INDEXED_OPAQUE_DD = "8-bit Indexed (Opaque) DirectDraw";
    public static final String DESC_BYTE_GRAY_DD = "Byte Gray DirectDraw";
    public static final String DESC_INDEX8_GRAY_DD = "Index8 Gray DirectDraw";
    public static final String DESC_3BYTE_BGR_DD = "3 Byte BGR DirectDraw";
    public static final String DESC_INT_RGB_DD_BM = "Integer RGB DirectDraw with 1 bit transp";
    public static final String DESC_INT_RGBx_DD_BM = "Integer RGBx DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_565_RGB_DD_BM = "Short 565 RGB DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_555_RGBx_DD_BM = "Short 555 RGBx DirectDraw with 1 bit transp";
    public static final String DESC_USHORT_555_RGB_DD_BM = "Short 555 RGB DirectDraw with 1 bit transp";
    public static final String DESC_3BYTE_BGR_DD_BM = "3 Byte BGR DirectDraw with 1 bit transp";
    public static final String DESC_BYTE_INDEXED_DD_BM = "8-bit Indexed DirectDraw with 1 bit transp";
    public static final String DESC_BYTE_GRAY_DD_BM = "Byte Gray DirectDraw with 1 bit transp";
    public static final String DESC_INDEX8_GRAY_DD_BM = "Index8 Gray DirectDraw with 1 bit transp";
    public static final SurfaceType IntRgbDD;
    public static final SurfaceType IntRgbxDD;
    public static final SurfaceType Ushort565RgbDD;
    public static final SurfaceType Ushort555RgbxDD;
    public static final SurfaceType Ushort555RgbDD;
    public static final SurfaceType ByteIndexedOpaqueDD;
    public static final SurfaceType ByteGrayDD;
    public static final SurfaceType Index8GrayDD;
    public static final SurfaceType ThreeByteBgrDD;
    public static final SurfaceType IntRgbDD_BM;
    public static final SurfaceType IntRgbxDD_BM;
    public static final SurfaceType Ushort565RgbDD_BM;
    public static final SurfaceType Ushort555RgbxDD_BM;
    public static final SurfaceType Ushort555RgbDD_BM;
    public static final SurfaceType ByteIndexedDD_BM;
    public static final SurfaceType ByteGrayDD_BM;
    public static final SurfaceType Index8GrayDD_BM;
    public static final SurfaceType ThreeByteBgrDD_BM;
    protected static Win32Renderer win32pipe;
    protected static PixelToShapeConverter win32txpipe;
    private boolean disposed = false;

    private static native void initDDraw();

    private static native void initIDs();

    public static SurfaceType getSurfaceType(ColorModel colorModel, boolean bl2) {
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl2 ? IntRgbDD_BM : IntRgbDD;
                    }
                    return bl2 ? IntRgbxDD_BM : IntRgbxDD;
                }
                return bl2 ? ThreeByteBgrDD_BM : ThreeByteBgrDD;
            }
            case 15: {
                return bl2 ? Ushort555RgbDD_BM : Ushort555RgbDD;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl2 ? Ushort555RgbxDD_BM : Ushort555RgbxDD;
                }
                return bl2 ? Ushort565RgbDD_BM : Ushort565RgbDD;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return bl2 ? ByteGrayDD_BM : ByteGrayDD;
                }
                if (colorModel instanceof IndexColorModel && SurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return bl2 ? Index8GrayDD_BM : Index8GrayDD;
                }
                return bl2 ? ByteIndexedDD_BM : ByteIndexedOpaqueDD;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public static Win32SurfaceData createData(WComponentPeer wComponentPeer, int n2) {
        SurfaceType surfaceType = Win32SurfaceData.getSurfaceType(wComponentPeer.getDeviceColorModel(), false);
        return new Win32SurfaceData(wComponentPeer, surfaceType, n2);
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        throw new InternalError("not implemented yet");
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.antialiasHint != 2 && sunGraphics2D.paintState == 0 && sunGraphics2D.compositeState == 0 && sunGraphics2D.clipState != 2) {
            sunGraphics2D.imagepipe = SurfaceData.imagepipe;
            if (sunGraphics2D.transformState > 1) {
                sunGraphics2D.drawpipe = win32txpipe;
                sunGraphics2D.fillpipe = win32txpipe;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = win32txpipe;
                sunGraphics2D.fillpipe = win32pipe;
            } else {
                sunGraphics2D.drawpipe = win32pipe;
                sunGraphics2D.fillpipe = win32pipe;
            }
            sunGraphics2D.shapepipe = win32pipe;
            sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint != 2 ? SurfaceData.solidTextRenderer : SurfaceData.aaTextRenderer;
        } else {
            super.validatePipe(sunGraphics2D);
        }
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0 && sunGraphics2D.compositeState == 0) {
            return this.solidloops;
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(WComponentPeer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Win32SurfaceData(WComponentPeer wComponentPeer, SurfaceType surfaceType, int n2) {
        super(surfaceType, wComponentPeer.getDeviceColorModel());
        Object object;
        int n3;
        ColorModel colorModel = wComponentPeer.getDeviceColorModel();
        this.peer = wComponentPeer;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    n3 = 32;
                    break;
                }
                n3 = 24;
                break;
            }
            default: {
                n3 = colorModel.getPixelSize();
            }
        }
        if (colorModel instanceof DirectColorModel) {
            object = (DirectColorModel)colorModel;
            n4 = ((DirectColorModel)object).getRedMask();
            n5 = ((DirectColorModel)object).getGreenMask();
            n6 = ((DirectColorModel)object).getBlueMask();
        }
        this.graphicsConfig = (Win32GraphicsConfig)wComponentPeer.getGraphicsConfiguration();
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        if (wComponentPeer instanceof WFileDialogPeer || wComponentPeer instanceof WPrintDialogPeer) {
            return;
        }
        object = (Win32GraphicsDevice)this.graphicsConfig.getDevice();
        this.initOps(wComponentPeer, n3, n4, n5, n6, n2, ((Win32GraphicsDevice)object).getScreen());
    }

    public SurfaceData getReplacement() {
        return this.peer.getSurfaceData();
    }

    public Rectangle getBounds() {
        return this.peer.getBounds();
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 2 && sunGraphics2D.clipState != 2 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
            int n8 = (n2 += sunGraphics2D.transX) + n6;
            int n9 = (n3 += sunGraphics2D.transY) + n7;
            int n10 = n8 + n4;
            int n11 = n9 + n5;
            if (n8 < sunGraphics2D.clipX1) {
                n8 = sunGraphics2D.clipX1;
            }
            if (n9 < sunGraphics2D.clipY1) {
                n9 = sunGraphics2D.clipY1;
            }
            if (n10 > sunGraphics2D.clipX2) {
                n10 = sunGraphics2D.clipX2;
            }
            if (n11 > sunGraphics2D.clipY2) {
                n11 = sunGraphics2D.clipY2;
            }
            if (n8 < n10 && n9 < n11) {
                win32pipe.devCopyArea(this, n8 - n6, n9 - n7, n6, n7, n10 - n8, n11 - n9);
            }
            return true;
        }
        return false;
    }

    private native void _dispose();

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public final void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.invalidate();
            this._dispose();
        }
    }

    private native void invalidateSD();

    public void invalidate() {
        if (this.isValid()) {
            this.invalidateSD();
            super.invalidate();
        }
    }

    public native void restoreSurface();

    public native void flip(SurfaceData var1);

    static {
        String string;
        IntRgbDD = SurfaceType.IntRgb.deriveSubType(DESC_INT_RGB_DD);
        IntRgbxDD = SurfaceType.IntRgbx.deriveSubType(DESC_INT_RGBx_DD);
        Ushort565RgbDD = SurfaceType.Ushort565Rgb.deriveSubType(DESC_USHORT_565_RGB_DD);
        Ushort555RgbxDD = SurfaceType.Ushort555Rgbx.deriveSubType(DESC_USHORT_555_RGBx_DD);
        Ushort555RgbDD = SurfaceType.Ushort555Rgb.deriveSubType(DESC_USHORT_555_RGB_DD);
        ByteIndexedOpaqueDD = SurfaceType.ByteIndexedOpaque.deriveSubType(DESC_BYTE_INDEXED_OPAQUE_DD);
        ByteGrayDD = SurfaceType.ByteGray.deriveSubType(DESC_BYTE_GRAY_DD);
        Index8GrayDD = SurfaceType.Index8Gray.deriveSubType(DESC_INDEX8_GRAY_DD);
        ThreeByteBgrDD = SurfaceType.ThreeByteBgr.deriveSubType(DESC_3BYTE_BGR_DD);
        IntRgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_INT_RGB_DD_BM, PixelConverter.Xrgb.instance);
        IntRgbxDD_BM = SurfaceType.Custom.deriveSubType(DESC_INT_RGBx_DD_BM, PixelConverter.Rgbx.instance);
        Ushort565RgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_565_RGB_DD_BM, PixelConverter.Ushort565Rgb.instance);
        Ushort555RgbxDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_555_RGBx_DD_BM, PixelConverter.Ushort555Rgbx.instance);
        Ushort555RgbDD_BM = SurfaceType.Custom.deriveSubType(DESC_USHORT_555_RGB_DD_BM, PixelConverter.Ushort555Rgb.instance);
        ByteIndexedDD_BM = SurfaceType.Custom.deriveSubType(DESC_BYTE_INDEXED_DD_BM);
        ByteGrayDD_BM = SurfaceType.Custom.deriveSubType(DESC_BYTE_GRAY_DD_BM);
        Index8GrayDD_BM = SurfaceType.Custom.deriveSubType(DESC_INDEX8_GRAY_DD_BM);
        ThreeByteBgrDD_BM = SurfaceType.Custom.deriveSubType(DESC_3BYTE_BGR_DD_BM, PixelConverter.Xrgb.instance);
        Win32SurfaceData.initIDs();
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        if (!(string2 != null || (string = (String)AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            Win32SurfaceData.initDDraw();
        }
        win32pipe = new Win32Renderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            win32pipe = win32pipe.traceWrap();
        }
        win32txpipe = new PixelToShapeConverter(win32pipe);
    }
}

