/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectShortBufferRU;
import java.nio.ShortBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferU
extends ShortBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$nio$DirectShortBufferU;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectShortBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 1, directByteBuffer.remaining() >> 1);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectShortBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public ShortBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 1;
        return new DirectShortBufferU(this, -1, 0, n4, n4, n5);
    }

    public ShortBuffer duplicate() {
        return new DirectShortBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 1);
    }

    public short get() {
        return unsafe.getShort(this.ix(this.nextGetIndex()));
    }

    public short get(int n2) {
        return unsafe.getShort(this.ix(this.checkIndex(n2)));
    }

    public ShortBuffer put(short s2) {
        unsafe.putShort(this.ix(this.nextPutIndex()), s2);
        return this;
    }

    public ShortBuffer put(int n2, short s2) {
        unsafe.putShort(this.ix(this.checkIndex(n2)), s2);
        return this;
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof DirectShortBufferU) {
            int n2;
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectShortBufferU directShortBufferU = (DirectShortBufferU)shortBuffer;
            int n3 = directShortBufferU.position();
            int n4 = directShortBufferU.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directShortBufferU.ix(n3), this.ix(n6), n5 << 1);
            directShortBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }

    public ShortBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 1);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectShortBufferU == null ? (class$java$nio$DirectShortBufferU = DirectShortBufferU.class$("java.nio.DirectShortBufferU")) : class$java$nio$DirectShortBufferU).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }
}

