/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectIntBufferRU;
import java.nio.IntBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferU
extends IntBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$nio$DirectIntBufferU;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectIntBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 2, directByteBuffer.remaining() >> 2);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectIntBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public IntBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 2;
        return new DirectIntBufferU(this, -1, 0, n4, n4, n5);
    }

    public IntBuffer duplicate() {
        return new DirectIntBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 2);
    }

    public int get() {
        return unsafe.getInt(this.ix(this.nextGetIndex()));
    }

    public int get(int n2) {
        return unsafe.getInt(this.ix(this.checkIndex(n2)));
    }

    public IntBuffer put(int n2) {
        unsafe.putInt(this.ix(this.nextPutIndex()), n2);
        return this;
    }

    public IntBuffer put(int n2, int n3) {
        unsafe.putInt(this.ix(this.checkIndex(n2)), n3);
        return this;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferU) {
            int n2;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferU directIntBufferU = (DirectIntBufferU)intBuffer;
            int n3 = directIntBufferU.position();
            int n4 = directIntBufferU.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directIntBufferU.ix(n3), this.ix(n6), n5 << 2);
            directIntBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    public IntBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 2);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectIntBufferU == null ? (class$java$nio$DirectIntBufferU = DirectIntBufferU.class$("java.nio.DirectIntBufferU")) : class$java$nio$DirectIntBufferU).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }
}

