/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Printer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;
    private int position = 0;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray, AudioFormat audioFormat, int n2) {
        super(info, abstractMixer, controlArray);
        this.defaultFormat = audioFormat;
        this.defaultBufferSize = n2;
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (Printer.trace) {
                Printer.trace("> " + this.getClass().getName() + ".open(format, bufferSize) - AbstractDataLine");
            }
            if (!this.isOpen()) {
                this.mixer.open(this, audioFormat, n2);
                try {
                    this.implOpen(audioFormat, n2);
                    this.setOpen(true);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.mixer.close(this);
                    throw lineUnavailableException;
                }
            } else if (!audioFormat.matches(this.getFormat()) || n2 != -1 && n2 != this.getBufferSize()) {
                throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
            }
            if (Printer.trace) {
                Printer.trace("< " + this.getClass().getName() + ".open(format, bufferSize) - AbstractDataLine");
            }
        }
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, -1);
    }

    public int available() {
        return 0;
    }

    public void drain() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: drain");
        }
    }

    public void flush() {
        if (Printer.trace) {
            Printer.trace("AbstractDataLine: flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (Printer.trace) {
                Printer.trace("> " + this.getClass().getName() + ".start() - AbstractDataLine");
            }
            if (this.isOpen() && !this.isStartedRunning()) {
                if (this.mixer != this) {
                    this.mixer.start(this);
                }
                this.implStart();
                this.running = true;
            }
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< " + this.getClass().getName() + ".start() - AbstractDataLine");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (Printer.trace) {
                Printer.trace("> " + this.getClass().getName() + ".stop() - AbstractDataLine");
            }
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.notifyAll();
        }
        if (Printer.trace) {
            Printer.trace("< " + this.getClass().getName() + ".stop() - AbstractDataLine");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getMicrosecondPosition() {
        long l2 = -1L;
        int n2 = this.getFramePosition();
        if (n2 != -1) {
            l2 = (long)((double)n2 * 1000000.0 / (double)this.getFormat().getFrameRate());
        }
        return l2;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public float getLevel() {
        return -1.0f;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean bl2) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setActive(" + bl2 + ")");
        }
        boolean bl3 = false;
        int n2 = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.active != bl2) {
                this.active = bl2;
                bl3 = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean bl2) {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setStarted(" + bl2 + ")");
        }
        boolean bl3 = false;
        int n2 = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.started != bl2) {
                this.started = bl2;
                bl3 = true;
            }
        }
        if (bl3) {
            if (bl2) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, n2));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEOM() {
        if (Printer.trace) {
            Printer.trace("> AbstractDataLine: setEOM()");
        }
        int n2 = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            this.started = false;
        }
        this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n2));
    }

    public void open() throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace("> " + this.getClass().getName() + ".open() - AbstractDataLine");
        }
        this.open(this.format, this.bufferSize);
        if (Printer.trace) {
            Printer.trace("< " + this.getClass().getName() + ".open() - AbstractDataLine");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (Printer.trace) {
                Printer.trace("> " + this.getClass().getName() + ".close() - in AbstractDataLine.");
            }
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.implClose();
                this.mixer.close(this);
                this.format = this.defaultFormat;
                this.bufferSize = this.defaultBufferSize;
            }
        }
        if (Printer.trace) {
            Printer.trace("< " + this.getClass().getName() + ".close() - in AbstractDataLine");
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

