@echo off

rem ************************************************
rem * This banner line should be changed as needed *
rem ************************************************
echo.
echo This batch file executes PCSDL for:  OCR Dual Analog Boot V1.0.4
echo.
echo Procedure for SDL:  1.  Turn OFF the card to be SDL'ed
echo                     2.  Execute this bat file
echo                     3.  Turn ON the card to be SDL'ed

rem **************************************************************
rem * You may change default baud here, change error_msg as well *
rem **************************************************************
set T_BAUD=115200

:check_fifo
set T_FIFO=-b
if "%2"=="OFF" goto check_com
if "%2"=="off" goto check_com
if "%3"=="OFF" goto check_baud
if "%3"=="off" goto check_baud
set T_FIFO=
if "%2"=="ON" goto check_com
if "%2"=="on" goto check_com
if "%3"=="ON" goto check_baud
if "%3"=="on" goto check_baud
if not "%3"=="" goto error_msg

:check_baud
if "%2"=="" goto check_com
set T_BAUD=115200
if "%2"=="115200" goto check_com
set T_BAUD=57600
if "%2"=="57600" goto check_com
set T_BAUD=38400
if "%2"=="38400" goto check_com
set T_BAUD=19200
if "%2"=="19200" goto check_com
set T_BAUD=9600
if "%2"=="9600" goto check_com
set T_BAUD=2400
if not "%2"=="2400" goto error_msg

:check_com
set T_COM=1
if "%1"=="1" goto do_it
set T_COM=2
if "%1"=="2" goto do_it
set T_COM=3
if "%1"=="3" goto do_it
set T_COM=4
if not "%1"=="4" goto error_msg

:do_it
echo.
if "%T_FIFO%"=="" goto fifo_1
echo Running PCSDL on COM%T_COM% at %T_BAUD% with FIFO off.
goto fifo_2
:fifo_1
echo Running PCSDL on COM%T_COM% at %T_BAUD% with FIFO on.
:fifo_2
echo.

rem ********************************************************************
rem * This PCSDL line should have NA and SD options modified as needed *
rem ********************************************************************
PCSDL -p%T_COM% -r%T_BAUD% -vNA91.0.4 -vSD1.0.0 -nSDoc -nNAoc %T_FIFO%
goto done

:error_msg
echo.
echo usage:  dlboot [port] {baud} {fifo}
echo         port = 1, 2, 3, 4
echo         baud = 115200(default), 57600, 38400, 19200, 9600, 2400
echo         fifo = on(default), off
echo.

:done
rem Clear environment
set T_FIFO=
set T_BAUD=
set T_COM=
