REM
REM  Replaces a substring by another substring in a string.
REM   haystack - the global string
REM   needle1  - the string that has to be replaced
REM   needle2  - the string to replace with
REM

FUNCTION StrReplace(BYREF haystack AS STRING, BYREF needle1 AS STRING, BYREF needle2 AS STRING) AS STRING
  DIM AS INTEGER len1 = LEN(needle1), len2 = LEN(needle2)
  DIM AS INTEGER i
  DIM AS STRING haystack_ = haystack
  i = INSTR(haystack_, needle1)
  WHILE i
    haystack_ = LEFT(haystack_, i - 1) & needle2 & MID(haystack_, i + len1)
    i = INSTR(i + len2, haystack_, needle1)
  WEND
  RETURN haystack_
END FUNCTION
