REM
REM  This file is part of the Motsognir project
REM  Copyright (C) Mateusz Viste 2010
REM

SUB PrintCapsTxt()
  PRINT "CAPS" + CRLF; ' These four characters must be at the beginning to identify the file as successfully fetched.
  PRINT "CapsVersion=1" + CRLF; ' Spec version of this caps file. This should be the first key specified.
  PRINT "ExpireCapsAfter=3600" + CRLF; ' This tells the client the recommended caps cache expiry time, in seconds.

  #IFDEF __FB_WIN32__
      PRINT "PathDelimiter=\" + CRLF;      ' This tells the client how to cut up a selector into a breadcrumb menu.
    #ELSE
      PRINT "PathDelimiter=/" + CRLF;      ' This tells the client how to cut up a selector into a breadcrumb menu.
  #ENDIF

  PRINT "PathIdentity=." + CRLF;  ' Tells the client what the "identity" path is, i.e., it can treat this as
                          ' a no-op, turning x/./y into x/y.

  PRINT "PathParent=.." + CRLF;   ' Tells the client what the parent path is, i.e., it can treat this as a path
                          ' instruction to delete previous path, turning x/y/../z into x/z

  PRINT "PathParentDouble=FALSE" + CRLF;  ' Tells the client that consecutive path delimeters are treated as parent

  'PathEscapeCharacter=\ ' Tells the client the escape character for quoting the above metacharacters.
                         ' Most of the time this is \. If this is not specified, no escape characters are used.

  PRINT "PathKeepPreDelimeter=FALSE" + CRLF; ' Tells the client not to cut everything up to the first path
                                             ' delimeter. Normally caps makes gopher://x/11/xyz into /xyz as
                                             ' well as gopher://x/1/xyz, assuming your server is happy with
                                             ' the latter URL (almost all will be). If this is not specified,
                                             ' it is by default FALSE. This should be TRUE *only* if your server
                                             ' requires URLs like gopher://x/0xyz.

  PRINT "ServerSoftware=Motsognir" + CRLF;       ' Server's name
  PRINT "ServerSoftwareVersion=" + pVer + CRLF;  ' Server's version

  IF LEN(CapsServerArchitecture) > 0 THEN
    PRINT "ServerArchitecture=" + CapsServerArchitecture + CRLF;
  END IF

  IF LEN(CapsServerDescription) > 0 THEN
    PRINT "ServerDescription=" + CapsServerDescription + CRLF;
  END IF

  IF LEN(CapsServerGeolocationString) > 0 THEN
    PRINT "ServerGeolocationString=" + CapsServerGeolocationString + CRLF;
  END IF

END SUB
