FUNCTION CheckForAuth(BYREF PathToCheckFor AS STRING, BYREF AuthToken AS STRING, BYREF RootPath AS STRING) AS BYTE
  ' Returns 0 if no auth required, 1 if auth required and access denied, -1 if auth required and access granted
  DIM AS STRING AuthFile, LineBuff, TempString, AuthFileToLookFor = ".motsognir.auth"
  DIM AS BYTE CharBuff, AuthRequired = 0
  DIM AS INTEGER FileHook
  AuthFile = PathToCheckFor
  DO
    DO
      CharBuff = AuthFile[LEN(AuthFile) - 1]
      IF CharBuff <> ASC(DirSlash) THEN AuthFile = MID(AuthFile, 1, LEN(AuthFile) - 1)
    LOOP UNTIL CharBuff = ASC(DirSlash)
    AuthFile += AuthFileToLookFor
    IF fexist(AuthFile) <> 0 THEN
        LogLine("Look for """ + AuthFile + """ - FOUND", 3)
        LogLine("Auth: The location requires some credentials", 1)
        AuthRequired = 1
      ELSE
        LogLine("Look for """ + AuthFile + """ - not found", 3)
        AuthFile = MID(AuthFile, 1, INSTRREV(AuthFile, DirSlash) - 1)
    END IF
  LOOP UNTIL LEN(AuthFile) <= LEN(RootPath) OR AuthRequired = 1
  IF AuthRequired = 1 AND LEN(AuthToken) > 0 THEN
    FileHook = FREEFILE
    OPEN AuthFile FOR INPUT AS FileHook
    DO
      LINE INPUT #FileHook, LineBuff
      LineBuff = CheckTrimBOM(LineBuff)
      LogLine("Checking entry [" + LineBuff + "] from """ + AuthFile + """", 3)
      IF LEN(LineBuff) > 0 AND LEFT(LineBuff, 1) <> "#" AND INSTR(LineBuff, ":") > 1 THEN
        IF createHash(TRIM(LineBuff)) = AuthToken THEN
          AuthUser = MID(LineBuff, 1, INSTR(LineBuff, ":") - 1)
          LogLine("Auth: Access granted (" + AuthUser + ")", 1)
          AuthRequired = -1
        END IF
      END IF
    LOOP UNTIL AuthRequired = -1 OR EOF(FileHook)
    CLOSE #FileHook
  END IF
  IF AuthRequired = 1 THEN
      IF LEN(AuthToken) > 0 THEN
          LogLine("Auth: Access denied (" + AuthToken + ")", 1)
        ELSE
          LogLine("Auth: Access denied (no credentials provided)", 1)
      END IF
    ELSE
      LogLine("Auth not required", 3)
  END IF
  RETURN AuthRequired
END FUNCTION
