#Include "MD5Checksum.bi"

#Ifndef memcpy
	Function memcpy(destination As UByte Ptr, source As UByte Ptr, num As UInteger) As UByte Ptr
		'Ersatz fr "crt/string.bi"
		'Prft nicht nach der Gre von Destination
		For i As Integer = 0 To num - 1
			destination[i]  = source[i]
		Next
		Return destination
	End Function
#EndIf

Sub MD5Checksum.UByteToUInteger(outpt As UInteger Ptr, inpt As UByte Ptr, nLength As UInteger)
	'Initialisierung
	Dim As UInteger i = 0
	Dim As UInteger j = 0
	
	'transferiere die Daten durch shifting und kopieren
	While j < nLength
		outpt[i] = (Cast(UInteger, inpt[j])) Or (Cast(UInteger, inpt[j+1]) Shl 8) Or (Cast(UInteger, inpt[j+2]) Shl 16) Or (Cast(UInteger, inpt[j+3]) Shl 24)
		i += 1
		j += 4
	Wend
End Sub

Sub MD5Checksum.Transform(block As UByte Ptr)
	'initialisiere die lokalen Daten mit der aktuellen checksum
	Dim As UInteger a = m_lMD5(0)
	Dim As UInteger b = m_lMD5(1)
	Dim As UInteger c = m_lMD5(2)
	Dim As UInteger d = m_lMD5(3)
	
	'Kopiert Bytes aus input 'Block' in ein Array von UIntegers 'X'
	Dim As UInteger X(16)
	UByteToUInteger(@X(0), block, 64)
	
	'Runde 1 Transformation
	FF(a, b, c, d, X( 0), MD5_S11, MD5_T01)
	FF(d, a, b, c, X( 1), MD5_S12, MD5_T02)
	FF(c, d, a, b, X( 2), MD5_S13, MD5_T03)
	FF(b, c, d, a, X( 3), MD5_S14, MD5_T04)
	FF(a, b, c, d, X( 4), MD5_S11, MD5_T05)
	FF(d, a, b, c, X( 5), MD5_S12, MD5_T06)
	FF(c, d, a, b, X( 6), MD5_S13, MD5_T07)
	FF(b, c, d, a, X( 7), MD5_S14, MD5_T08)
	FF(a, b, c, d, X( 8), MD5_S11, MD5_T09)
	FF(d, a, b, c, X( 9), MD5_S12, MD5_T10)
	FF(c, d, a, b, X(10), MD5_S13, MD5_T11)
	FF(b, c, d, a, X(11), MD5_S14, MD5_T12)
	FF(a, b, c, d, X(12), MD5_S11, MD5_T13)
	FF(d, a, b, c, X(13), MD5_S12, MD5_T14)
	FF(c, d, a, b, X(14), MD5_S13, MD5_T15)
	FF(b, c, d, a, X(15), MD5_S14, MD5_T16)
	
	'Runde 2 Transformation
	GG(a, b, c, d, X( 1), MD5_S21, MD5_T17)
	GG(d, a, b, c, X( 6), MD5_S22, MD5_T18)
	GG(c, d, a, b, X(11), MD5_S23, MD5_T19)
	GG(b, c, d, a, X( 0), MD5_S24, MD5_T20)
	GG(a, b, c, d, X( 5), MD5_S21, MD5_T21)
	GG(d, a, b, c, X(10), MD5_S22, MD5_T22)
	GG(c, d, a, b, X(15), MD5_S23, MD5_T23)
	GG(b, c, d, a, X( 4), MD5_S24, MD5_T24)
	GG(a, b, c, d, X( 9), MD5_S21, MD5_T25)
	GG(d, a, b, c, X(14), MD5_S22, MD5_T26)
	GG(c, d, a, b, X( 3), MD5_S23, MD5_T27)
	GG(b, c, d, a, X( 8), MD5_S24, MD5_T28)
	GG(a, b, c, d, X(13), MD5_S21, MD5_T29)
	GG(d, a, b, c, X( 2), MD5_S22, MD5_T30)
	GG(c, d, a, b, X( 7), MD5_S23, MD5_T31)
	GG(b, c, d, a, X(12), MD5_S24, MD5_T32)
	
	'Runde 3 Transformation
	HH(a, b, c, d, X( 5), MD5_S31, MD5_T33)
	HH(d, a, b, c, X( 8), MD5_S32, MD5_T34)
	HH(c, d, a, b, X(11), MD5_S33, MD5_T35)
	HH(b, c, d, a, X(14), MD5_S34, MD5_T36)
	HH(a, b, c, d, X( 1), MD5_S31, MD5_T37)
	HH(d, a, b, c, X( 4), MD5_S32, MD5_T38)
	HH(c, d, a, b, X( 7), MD5_S33, MD5_T39)
	HH(b, c, d, a, X(10), MD5_S34, MD5_T40)
	HH(a, b, c, d, X(13), MD5_S31, MD5_T41)
	HH(d, a, b, c, X( 0), MD5_S32, MD5_T42)
	HH(c, d, a, b, X( 3), MD5_S33, MD5_T43)
	HH(b, c, d, a, X( 6), MD5_S34, MD5_T44)
	HH(a, b, c, d, X( 9), MD5_S31, MD5_T45)
	HH(d, a, b, c, X(12), MD5_S32, MD5_T46)
	HH(c, d, a, b, X(15), MD5_S33, MD5_T47)
	HH(b, c, d, a, X( 2), MD5_S34, MD5_T48)
	
	'Runde 4 Transformation
	II(a, b, c, d, X( 0), MD5_S41, MD5_T49)
	II(d, a, b, c, X( 7), MD5_S42, MD5_T50)
	II(c, d, a, b, X(14), MD5_S43, MD5_T51)
	II(b, c, d, a, X( 5), MD5_S44, MD5_T52)
	II(a, b, c, d, X(12), MD5_S41, MD5_T53)
	II(d, a, b, c, X( 3), MD5_S42, MD5_T54)
	II(c, d, a, b, X(10), MD5_S43, MD5_T55)
	II(b, c, d, a, X( 1), MD5_S44, MD5_T56)
	II(a, b, c, d, X( 8), MD5_S41, MD5_T57)
	II(d, a, b, c, X(15), MD5_S42, MD5_T58)
	II(c, d, a, b, X( 6), MD5_S43, MD5_T59)
	II(b, c, d, a, X(13), MD5_S44, MD5_T60)
	II(a, b, c, d, X( 4), MD5_S41, MD5_T61)
	II(d, a, b, c, X(11), MD5_S42, MD5_T62)
	II(c, d, a, b, X( 2), MD5_S43, MD5_T63)
	II(b, c, d, a, X( 9), MD5_S44, MD5_T64)
	
	'Fge die vernderten Werte zur aktuellen Checksum hinzu
	m_lMD5(0) += a
	m_lMD5(1) += b
	m_lMD5(2) += c
	m_lMD5(3) += d
End Sub

Constructor MD5Checksum
	'Initialisierung
	m_nCount(0) = 0
	m_nCount(1) = 0
	
	'Lade magic state Initialisierungskonstanten
	m_lMD5(0) = MD5_INIT_STATE_0
	m_lMD5(1) = MD5_INIT_STATE_1
	m_lMD5(2) = MD5_INIT_STATE_2
	m_lMD5(3) = MD5_INIT_STATE_3
End Constructor

Destructor MD5Checksum
	
End Destructor

Sub MD5Checksum.UIntegerToUByte(outpt As UByte Ptr, inpt As UInteger Ptr, nLength As UInteger)
	'Initialisierung
	Dim As UInteger i		'Index des Zeilarrays
	Dim As UInteger j		'Index des Quellarrays
	
	'transferiere die Daten durch shifting und kopieren
	While j < nLength
		outpt[ j ] = Cast(UByte, (inpt[i]       ))
		outpt[j+1] = Cast(UByte, (inpt[i] Shr  8))
		outpt[j+2] = Cast(UByte, (inpt[i] Shr 16))
		outpt[j+3] = Cast(UByte, (inpt[i] Shr 24))
		i += 1
		j += 4
	Wend
End Sub

Function MD5Checksum.Final() As String
	'Sichere Anzahl der Bits
	Dim As UByte bits(8)
	UIntegerToUByte(@bits(0), @m_nCount(0), 8)
	
	'Auffllen bis 56 mod 64
	Dim As UInteger nIndex = Cast(UInteger, (m_nCount(0) Shr 3) And &H3f)
	Dim As UInteger nPadLen = IIf((nIndex < 56), (56 - nIndex), (120 - nIndex))
	Update(@PADDING(0), nPadLen)
	
	'Fge die Lnge hinzu (vor dem Auffllen)
	Update(@bits(0), 8)
	
	'Sichere final state in 'lpszMD5'
	Dim As UByte lpszMD5(16)
	UIntegerToUByte(@lpszMD5(0), @m_lMD5(0), 16)
	
	'Konvertiere die hexadezimale Checksum in einen String
	Dim As String strMD5
	For i As Integer = 0 To 15
		Dim As String Strn
		If lpszMD5(i) = 0 Then
			Strn = "00"
		ElseIf lpszMD5(i) <= 15 Then
			Strn = "0" + Str(Hex(lpszMD5(i)))
		Else
			Strn = Str(Hex(lpszMD5(i)))
		EndIf
		
		strMD5 += Strn
	Next
	
	Return strMD5
End Function

Sub MD5Checksum.Update(inpt As UByte Ptr, nInputLen As UInteger)
	'Anzahl der Bytes mod 64 berechnen
	Dim As UInteger nIndex = Cast(UInteger, ((m_nCount(0) Shr 3) And &H3f))
	
	'Anzahl der Bits aktualisieren
	m_nCount(0) += (nInputLen Shl 3)
	If (m_nCount(0) < (nInputLen Shl 3)) Then
		m_nCount(1) += 1
	EndIf
	m_nCount(1) += (nInputLen Shr 29)
	
	'Transformiere so oft wie mglich
	Dim As UInteger i = 0
	Dim As UInteger nPartLen = 64 - nIndex
	If (nInputLen >= nPartLen) Then
		memcpy(@m_lpszBuffer(nIndex), inpt, nPartLen)
		
		Transform(@m_lpszBuffer(0))
		
		i = nPartLen
		While i + 63 < nInputLen
			Transform(@inpt[i])
			i += 64
		Wend
		
		nIndex = 0
	Else
		i = 0
	EndIf
	
	'brig gebliebenen Input in Buffer
	memcpy(@m_lpszBuffer(nIndex), @inpt[i], nInputLen - i)
End Sub

Function createHash(text As String) As String
	Dim As UInteger nLength = Len(text)
	If nLength = 0 Then
		Return "Kein Text enthalten"
	EndIf
	
	Dim As UByte buffer(16384)
	For i As Integer = 1 To nLength
		buffer(i - 1) = Asc(Mid(text, i ,1))
	Next
	
	Dim As MD5Checksum MD5
	MD5.Update(@buffer(0), nLength)
	
	Return MD5.Final()
End Function

Function createFileHash(file As String) As String
	Dim As UInteger nLength = Len(file)
	If nLength = 0 Then
		Return "Keine Datei angegeben"
	EndIf
	
	Dim As Integer FFF = FreeFile
	If Open(file For Binary Access Read As #FFF) <> 0 Then
		Return "Datei konnte nicht gefunden/geffnet werden"
	EndIf
	
	Dim As UInteger fileLength = Lof(FFF)
	If fileLength = 0 Then
		Close #FFF
		Return "Leere Datei"
	EndIf
	
	Dim As UByte buffer(16384)
	Dim As UInteger toBuffer
	Dim As MD5Checksum MD5
	Do Until fileLength = 0
		If fileLength >= 16384 Then
			fileLength -= 16384
			toBuffer = 16384
		Else
			toBuffer = fileLength
			fileLength = 0
		EndIf
		Get #FFF, , buffer(0), toBuffer
		MD5.Update(@buffer(0), toBuffer)
	Loop
	Close #FFF
	
	Return MD5.Final()
End Function
