REM
REM    * * * * * * * * * * * * * * * * * * * * * * * * * *
REM    *  Mótsognir - The mighty gopher server           *
REM    *  Copyright (C) Mateusz Viste 2008, 2009, 2010   *
REM    * * * * * * * * * * * * * * * * * * * * * * * * * *
REM
REM  Written in FreeBASIC v0.20.0 by Mateusz Viste <mateusz@viste-family.net>
REM
REM   ----------------------------------------------------------------------
REM    This program is free software: you can redistribute it and/or modify
REM    it under the terms of the GNU General Public License as published by
REM    the Free Software Foundation, either version 3 of the License, or
REM    (at your option) any later version.
REM
REM    This program is distributed in the hope that it will be useful,
REM    but WITHOUT ANY WARRANTY; without even the implied warranty of
REM    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
REM    GNU General Public License for more details.
REM
REM    You should have received a copy of the GNU General Public License
REM    along with this program.  If not, see <http://www.gnu.org/licenses/>.
REM   ----------------------------------------------------------------------
REM

' Constants:
CONST pVer AS STRING = "0.99"
CONST pDate AS STRING = "2008 - 2010"
CONST homepage AS STRING = "gopher://gopher.viste-family.net/1/projects/motsognir/"
CONST CRLF AS STRING = CHR(13) + CHR(10)

' Shared variables:
REDIM SHARED AS STRING DescriptionTable(0 TO 16)
DIM SHARED AS UBYTE VerboseMode
DIM SHARED AS STRING Token, Value, LocalFile, SrvSideParams, LogFile, GopherHostname, LineBuff, GopherSelector, GopherPort, AuthUser
DIM SHARED EnvVariables(1 TO 30) AS STRING
DIM SHARED StartTime AS DOUBLE
DIM SHARED ShortMonths(1 TO 12) AS STRING*3 => {"Jan", "Feb", "Mar", "Apr",_
                                                "May", "Jun", "Jul", "Aug",_
                                                "Sep", "Oct", "Nov", "Dec"}
#IFDEF __FB_LINUX__
  CONST ConfigFile = "/etc/motsognir.cfg"
  CONST DirSlash = "/"
  CONST CgiExtension = ".cgi"
#ENDIF
#IFDEF __FB_WIN32__
  DIM SHARED ConfigFile AS STRING
  ConfigFile = EXEPATH + "\motsognir.cfg"
  CONST DirSlash = "\"
  CONST CgiExtension = ".exe"
  RANDOMIZE TIMER
  DIM SHARED AS INTEGER RandomPID
  RandomPID = INT(RND*99999)
  FUNCTION GetPID() AS INTEGER
    RETURN RandomPID
  END FUNCTION
#ENDIF

TYPE GopherLink
  Server AS STRING
  Selector AS STRING
  Type AS STRING
  Port AS STRING
  Description AS STRING
END TYPE

#INCLUDE ONCE "vbcompat.bi"           ' Required for use of FORMAT() and FileDateTime() functions
#INCLUDE ONCE "crt.bi"                ' Needed by GetSrvTime
#IFDEF __FB_LINUX__
  #INCLUDE ONCE "crt/linux/unistd.bi" ' Required for GetPID()
#ENDIF
#INCLUDE ONCE "sortstr.bi"            ' Sorting lib
#INCLUDE ONCE "setenv.bi"             ' SUB SetEnv(EnvString AS STRING)
#INCLUDE ONCE "nowgmt.bi"             ' SUB NowGMT()
#INCLUDE ONCE "logline.bi"            ' SUB LogLine(LogText AS STRING, LogLevel AS UBYTE)
#INCLUDE ONCE "connclose.bi"          ' SUB ConnClose()
#INCLUDE ONCE "execcgi.bi"            ' SUB ExecCgi(CgiProgram AS STRING, HeadQuery AS BYTE = 0)
#INCLUDE ONCE "isdirectory.bi"        ' FUNCTION IsDirectory(ElementToCheck AS STRING) AS BYTE
#INCLUDE ONCE "fexist.bi"             ' FUNCTION fexist(filename AS STRING) AS BYTE
#INCLUDE ONCE "about.bi"              ' SUB About()
#INCLUDE ONCE "removedoublechar.bi"   ' FUNCTION RemoveDoubleChar(StringToCheck AS STRING, Char AS STRING) AS STRING
#INCLUDE ONCE "checktrimbom.bi"       ' FUNCTION CheckTrimBOM(WorkString AS STRING) AS STRING
#INCLUDE ONCE "lineinput.bi"          ' FUNCTION LineInput(SocketToListenTo AS INTEGER = 0) AS STRING
#INCLUDE ONCE "checkforevasion.bi"    ' FUNCTION CheckForEvasion(JailPath AS STRING, EvadingFile AS STRING) AS BYTE
#INCLUDE ONCE "readcfg.bi"            ' FUNCTION ReadCFG(CFGfile AS STRING, CFGField AS STRING) AS STRING
#INCLUDE ONCE "wordwrap.bi"           ' FUNCTION WordWrap(TextToWrap AS STRING, WrapValue AS INTEGER) AS STRING
#INCLUDE ONCE "detectgophertype.bi"   ' FUNCTION DetectGopherType(FilenameString AS STRING) AS STRING
#INCLUDE ONCE "MD5Checksum.bas"       ' MD5 functions: createHash() & createFileHash()
#INCLUDE ONCE "checkforauth.bi"       ' FUNCTION CheckForAuth(PathToCheckFor AS STRING) AS BYTE
#INCLUDE ONCE "getfiledescription.bi" ' FUNCTION GetFileDescription(FileToCheck AS STRING, DescrPath AS STRING) AS STRING
#INCLUDE ONCE "gophersecuritycheck.bi"' FUNCTION GopherSecurityCheck(GophRequest AS STRING) AS STRING
#INCLUDE ONCE "readgopherlink.bi"     ' FUNCTION ReadGopherLink(CFGfile AS STRING) AS GopherLink
#INCLUDE ONCE "percencoding.bi"       ' FUNCTION TranslatePercentEnc(RawString AS STRING, RevEnc AS BYTE = 0) AS STRING
#INCLUDE ONCE "strreplace.bi"         ' FUNCTION StrReplace(haystack AS STRING, needle1 AS STRING, needle2 AS STRING) AS STRING

REM Local variables:
DIM AS STRING FileName, EntryDescription, GopherRoot, GopherType, DirectoryToList, SecurityCheck, TempString, MapSelector, MapDescription, MapPort, MapServer, MapType, AuthToken
DIM AS STRING*1 ByteBuff
DIM AS STRING*1024 KByteBuff
DIM AS UINTEGER FileAttrib
DIM AS INTEGER DirIndex, x, y, GopherCgiSupport
DIM AS LONGINT FileSizePosition
DIM AS GopherLink TempLink
DIM DirList(1 TO 20000) AS STRING
DIM TempDouble AS DOUBLE

StartTime = TIMER

VerboseMode = VAL(ReadCFG(ConfigFile, "Verbose"))
IF VerboseMode < 0 OR VerboseMode > 3 THEN
  LogLine("Invalid verbose level found in the configuration file (" & VerboseMode & "). Fallbacking to default level (1).",1)
  VerboseMode = 1
END IF
LogFile = ReadCFG(ConfigFile, "GopherLogFile")

IF LEN(LogFile) = 0 THEN
  #IFDEF __FB_LINUX__
    LogFile = "/var/log/motsognir.log"
  #ENDIF
  #IFDEF __FB_WIN32__
    LogFile = EXEPATH + "\motsognir.log"
  #ENDIF
END IF

IF LEN(COMMAND(1)) > 0 THEN About()

OPEN CONS FOR INPUT AS #4
IF VerboseMode > 0 THEN
  LogLine("", 1)
  TempDouble = NowGMT()
  TempString = ""
  IF LEN(ENVIRON("REMOTE_ADDR")) > 0 THEN TempString = "REMOTE_ADDR=" + ENVIRON("REMOTE_ADDR")
  IF LEN(ENVIRON("REMOTE_HOST")) > 0 THEN TempString = "REMOTE_HOST=" + ENVIRON("REMOTE_HOST") + " " + TempString
  IF LEN(TempString) > 0 THEN TempString = " / " + TRIM(TempString)
  LogLine("---[ " & FORMAT(DAY(TempDouble), "0#") & " " & ShortMonths(MONTH(TempDouble)) & " " & YEAR(TempDouble) & ", " & FORMAT(HOUR(TempDouble), "0#") & ":" & FORMAT(MINUTE(TempDouble), "0#") & ":" & FORMAT(SECOND(TempDouble), "0#") & " (GMT)" & TempString & " ]---", 1)
END IF

GopherRoot = ReadCFG(ConfigFile, "GopherRoot")
GopherPort = ReadCFG(ConfigFile, "GopherPort")
GopherHostname = ReadCFG(ConfigFile, "GopherHostname")
GopherCgiSupport = VALINT(ReadCFG(ConfigFile, "GopherCgiSupport"))

#IFDEF __FB_LINUX__
  IF TRIM(GopherRoot) = "" THEN GopherRoot = "/var/gopher/"
#ENDIF
#IFDEF __FB_WIN32__
  IF TRIM(GopherRoot) = "" THEN GopherRoot = EXEPATH + "\gopher\"
#ENDIF
IF VAL(GopherPort) <= 0 THEN GopherPort = "70"

IF LEFT(GopherRoot, 2) = "./" OR LEFT(GopherRoot, 2) = ".\" THEN GopherRoot = EXEPATH + "/" + MID(GopherRoot, 3)
#IFDEF __FB_WIN32__
  GopherRoot = StrReplace(GopherRoot, "/", "\")
#ENDIF
GopherRoot = RemoveDoubleChar(GopherRoot, DirSlash)
LogLine("Gopher root: " & GopherRoot, 3)

DirectoryToList = LineInput(4)
LogLine("GopherQuery=" + CHR(34) + DirectoryToList + CHR(34), 1)
IF DirectoryToList = "" THEN DirectoryToList = "/" ' Empty request means "gimme the root listing"

IF UCASE(LEFT(DirectoryToList, 5)) = "GET /" AND INSTR(RIGHT(DirectoryToList, 9), " HTTP/") > 0 THEN
  LogLine("HTTP request detected - a HTTP error message is returned.", 1)
  SLEEP 250, 1
  PRINT "HTTP/1.1 400 Bad request" + CRLF;
  PRINT "Content-Type: text/html; charset=UTF-8" + CRLF;
  PRINT "Server: Motsognir/" + pVer + CRLF;
  PRINT "Connection: close" + CRLF;
  PRINT "" + CRLF;
  PRINT "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.01//EN"" ""http://www.w3.org/TR/html4/strict.dtd"">" + CRLF;
  PRINT "<html>" + CRLF;
  PRINT "  <head>" + CRLF;
  PRINT "    <title>400 - Bad request</title>" + CRLF;
  PRINT "    <meta name=""generator"" content=""Motsognir v" + pVer + """>" + CRLF;
  PRINT "  </head>" + CRLF;
  PRINT "  <body>" + CRLF;
  PRINT "    <p style=""font-size: 1.3em; margin: 1em 1em 1em 1em; text-align: left; font-weight: bold;"">400 - BAD REQUEST</p>" + CRLF;
  PRINT "    <p style=""font-size: 1.1em; margin: 1em 1em 1em 1em; text-align: left;"">Your request is not admissible. Sorry. This is a gopher server, which means that you have to use the gopher protocol to access it. Right now, you used the HTTP protocol instead.</p>" + CRLF;
  IF GopherPort = "70" THEN
      PRINT "    <p style=""text-align: center;""><a href=""gopher://" + GopherHostname + "/"" style=""font-size: 1.15em;"">Click here to access this server using the gopher protocol.</a></p>" + CRLF;
    ELSE
      PRINT "    <a href=""gopher://" + GopherHostname + ":" + GopherPort + "/"">Click here to access the server using the gopher protocol.</a>" + CRLF;
  END IF
  PRINT "  </body>" + CRLF;
  PRINT "</html>" + CRLF;
  ConnClose()
END IF

IF INSTR(DirectoryToList, "/") = 0 THEN
  LogLine("Malformed request detected. Connection closed.", 1)
  PRINT "3Malformed request" + CHR(9) + "fakeselector" + CHR(9) + "fakeserver" + CHR(9) + "70" + CRLF + "." + CRLF;
  ConnClose()
END IF

IF INSTR(DirectoryToList, CHR(9)) > 0 THEN ' Retrieve server-side parameters (if any)
  SrvSideParams = MID(DirectoryToList, INSTR(DirectoryToList, CHR(9)) + 1)
  DirectoryToList = MID(DirectoryToList, 1, INSTR(DirectoryToList, CHR(9)) - 1) ' Cut the selector at 1st TAB
  LogLine("Got following server-side parameters: " & SrvSideParams, 3)
END IF

DirectoryToList = TranslatePercentEnc(DirectoryToList)

IF LEFT(DirectoryToList, 1) <> "/" AND LEFT(DirectoryToList, 4) <> "URL:" THEN ' extract the auth token
  x = INSTR(DirectoryToList, "/")
  AuthToken = MID(DirectoryToList, 1, x - 1)
  DirectoryToList = MID(DirectoryToList, x)
  IF AuthToken = "a" THEN ' Need to ask for the password, now.
    LineBuff = SrvSideParams ' get login
    SrvSideParams = ""
    REM Here I should check the login (length, characters inside...)
    PRINT "iYour login has been saved." + CHR(9) + "fakeselector" + CHR(9) + "fakeserver" + CHR(9) + "70" + CRLF;
    #IFDEF __FB_WIN32__
        PRINT "7Enter your password here, now" + CHR(9) + "a" + LineBuff + TranslatePercentEnc(StrReplace(DirectoryToList, "\", "/"), 1) + CHR(9) + GopherHostname + CHR(9) + GopherPort + CRLF;
      #ELSE
        PRINT "7Enter your password here, now" + CHR(9) + "a" + LineBuff + TranslatePercentEnc(DirectoryToList, 1) + CHR(9) + GopherHostname + CHR(9) + GopherPort + CRLF;
    #ENDIF
    PRINT "." + CRLF;
    LogLine("Got login: " + LineBuff + " (waiting for password now)", 2)
    ConnClose()
  END IF
  IF LEFT(AuthToken, 1) = "a" AND LEN(AuthToken) > 1 THEN ' Retrieve supplied password.
    LineBuff = SrvSideParams ' get password
    SrvSideParams = ""
    LogLine("Got password: " + LineBuff, 2)
    REM Here I should check the password (length, characters inside...)
    LineBuff = MID(AuthToken, 2) + ":" + LineBuff ' prepare the token
    AuthToken = createHash(LineBuff) ' Generate the final AuthToken
    LogLine("Generating an auth token [" + LineBuff + "] -> [" + AuthToken + "]", 3)
  END IF
END IF

SecurityCheck = GopherSecurityCheck(DirectoryToList)
IF SecurityCheck <> "" THEN
    LogLine("The gopher security module has detected a suspect condition. The query won't be processed. Reason: " + SecurityCheck, 1)
  ELSE
    LogLine("Security check: OK", 3)
    IF INSTR(DirectoryToList, "?") > 0 THEN ' For "?" URLs, rewrite SrvSideParams
      SrvSideParams = MID(DirectoryToList, INSTR(DirectoryToList, "?") + 1)
      DirectoryToList = MID(DirectoryToList, 1, INSTR(DirectoryToList, "?") - 1)
    END IF
    IF UCASE(LEFT(DirectoryToList, 4)) = "URL:" THEN
        LogLine("The request is asking for a URL redirection", 3)
        LogLine("Returned a html document with redirection to " + CHR(34) + MID(DirectoryToList, 5) + CHR(34), 1)
        PRINT "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 3.2 Final//EN"">" + CRLF;
        PRINT "<html>" + CRLF;
        PRINT "  <head>" + CRLF;
        PRINT "    <title>Non-gopher link detected</title>" + CRLF;
        PRINT "    <meta http-equiv=""refresh"" content=""10;url="+ MID(DirectoryToList, 5) + """>" + CRLF;
        PRINT "    <meta name=""generator"" content=""Motsognir gopher server"">" + CRLF;
        PRINT "  </head>" + CRLF;
        PRINT "  <body style=""margin: 1em 2em 1em 2em; background-color: #D0E0FF; color: #101010;"">" + CRLF;
        PRINT "    <table style=""margin-left: auto; margin-right: auto; width: 70%; border: 1px solid black; padding: 1.5em 1.1em 1.5em 1.1em; background-color: #E0F0FF;"">" + CRLF;
        PRINT "      <tr>" + CRLF;
        PRINT "        <td>" + CRLF;
        PRINT "          <p style=""text-align: center; font-size: 1.3em; margin: 0 0 2em 0;"">A non-gopher link has been detected.</p>" + CRLF;
        PRINT "          <p style=""text-align: justify; margin: 0 0 0 0;"">It appears that you clicked on a non-gopher link, which will make you use another protocol from now on (typically HTTP). Your gopher journey ends here.</p>" + CRLF;
        PRINT "          <p style=""text-align: center; margin: 0.8em 0 0 0;"">Click on the link below to continue (or wait 10 seconds):</p>" + CRLF;
        PRINT "          <p style=""text-align: center; font-size: 1.1em; margin: 0.8em 0 0 0;""><a href=""" + MID(DirectoryToList, 5) + """ style=""color: #0000F0;"">" + MID(DirectoryToList, 5) + "</a></p>" + CRLF;
        PRINT "        </td>" + CRLF;
        PRINT "      </tr>" + CRLF;
        PRINT "    </table>" + CRLF;
        PRINT "  </body>" + CRLF;
        PRINT "</html>" + CRLF;
      ELSE
        DirectoryToList = RemoveDoubleChar("/" + DirectoryToList, "/")
        LocalFile = RemoveDoubleChar(GopherRoot + "/" + DirectoryToList, "/")
        #IFDEF __FB_WIN32__
          LocalFile = StrReplace(LocalFile, "/", "\")
          LocalFile = RemoveDoubleChar(LocalFile, "\")
          DirectoryToList = StrReplace(DirectoryToList, "/", "\")
          DirectoryToList = RemoveDoubleChar(DirectoryToList, "\")
        #ENDIF
        LogLine("Requested resource: " + DirectoryToList, 3)
        LogLine("Local resource: " + LocalFile, 3)
        IF CheckForEvasion(GopherRoot, LocalFile) = 1 THEN
            LogLine("Response=""Evasion attempt. Forbidden!""", 1)
            PRINT "iForbidden!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
          ELSE
          LogLine("Evasion check: ok", 3)
            IF IsDirectory(LocalFile) = 1 THEN
                LogLine("The ressource is a directory", 3)
                IF RIGHT(LocalFile, 1) <> DirSlash THEN LocalFile += DirSlash
                IF RIGHT(DirectoryToList, 1) <> DirSlash THEN DirectoryToList += DirSlash
                IF CheckForAuth(LocalFile, AuthToken, GopherRoot) = 1 THEN
                    LogLine("Response=""Password protected directory. Access denied - asked for login.""", 1)
                    PRINT "iThis ressource is protected by a password."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF;
                    #IFDEF __FB_WIN32__
                        PRINT "7Enter your login here" + CHR(9) + "a" + TranslatePercentEnc(StrReplace(DirectoryToList, "\", "/"), 1) + CHR(9) + GopherHostname + CHR(9) + GopherPort + CRLF;
                      #ELSE
                        PRINT "7Enter your login here" + CHR(9) + "a" + TranslatePercentEnc(DirectoryToList, 1) + CHR(9) + GopherHostname + CHR(9) + GopherPort + CRLF;
                    #ENDIF
                    PRINT "."; CRLF;
                  ELSE
                    IF fexist(LocalFile + "gophermap") <> 0 THEN
                        LogLine("Response=""Return gophermap. (" + LocalFile + "gophermap)""", 1)
                        OPEN LocalFile + "gophermap" FOR INPUT AS #51
                        WHILE NOT EOF(51)
                        LINE INPUT #51, TempString
                          TempString = CheckTrimBOM(TempString)
                          IF TempString = "i" THEN TempString = "i "
                          IF LEN(TempString) > 1 THEN
                            MapType = MID(TempString, 1, 1)
                            TempString = MID(TempString, 2)
                            x = 1 : y = 1
                            MapDescription = "" : MapSelector = "" : MapServer = "" : MapPort = ""
                            DO
                              IF MID(TempString, x, 1) = CHR(9) THEN
                                  y += 1
                                ELSE
                                  SELECT CASE y
                                    CASE 1   ' Description
                                      MapDescription += MID(TempString, x, 1)
                                    CASE 2   ' Selector
                                      MapSelector += MID(TempString, x, 1)
                                    CASE 3   ' Server
                                      MapServer += MID(TempString, x, 1)
                                    CASE 4   ' Port
                                      MapPort += MID(TempString, x, 1)
                                  END SELECT
                              END IF
                              x += 1
                            LOOP UNTIL x > LEN(TempString) OR y > 4
                            IF TRIM(MapServer) = "" THEN MapServer = GopherHostname
                            IF TRIM(MapPort) = "" THEN MapPort = GopherPort
                            IF TRIM(MapType) = "" THEN MapType = "3" ' Error if no type specified
                            IF LEFT(MapSelector, 4) = "URL:" THEN
                                PRINT MapType; MapDescription; CHR(9); MapSelector; CHR(9); MapServer; CHR(9); MapPort; CRLF;
                              ELSE
                                IF LEFT(MapSelector, 1) <> "/" AND UCASE(MapServer) = UCASE(GopherHostname) THEN ' Resolve relative paths on current server
                                  MapSelector = DirectoryToList + MapSelector
                                END IF
                                #IFDEF __FB_WIN32__
                                  MapSelector = StrReplace(MapSelector, "\", "/")
                                #ENDIF
                                IF LEN(AuthToken) > 0 AND UCASE(MapServer) = UCASE(GopherHostname) THEN
                                    PRINT MapType; MapDescription; CHR(9); AuthToken; TranslatePercentEnc(MapSelector, 1); CHR(9); MapServer; CHR(9); MapPort; CRLF;
                                  ELSE
                                    PRINT MapType; MapDescription; CHR(9); TranslatePercentEnc(MapSelector, 1); CHR(9); MapServer; CHR(9); MapPort; CRLF;
                                END IF
                            END IF
                          END IF
                        WEND
                        CLOSE #51
                        PRINT "."; CRLF;
                      ELSE
                        ' LIST FILES & DIRECTORIES
                        LogLine("No gophermap found. Listing directory's content...", 3)
                        EntryDescription = GetFileDescription(".", LocalFile)
                        IF LEN(EntryDescription) > 0 THEN
                          DO
                            TempString = WordWrap(EntryDescription, 70)
                            PRINT "i"; TempString; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF;
                          LOOP UNTIL LEN(EntryDescription) = 0
                          PRINT "i"; CHR(9); "fake"; CHR(9); "NULL"; CHR(9); "0"; CRLF;
                        END IF
                        FileName = DIR(LocalFile + "*", &h37, FileAttrib)
                        DirIndex = 0
                        WHILE FileName <> "" AND DirIndex < 20000
                          IF FileName <> "." AND FileName <> ".." AND LEFT(FileName, 1) <> "." AND Filename <> "descript.ion" THEN
                            DirIndex += 1
                            DirList(DirIndex) = FileName
                            IF FileAttrib AND &h10 THEN DirList(DirIndex) = CHR(9) + DirList(DirIndex)
                          END IF
                          FileName = DIR(FileAttrib)
                        WEND
                        FOR x = 1 TO DirIndex                                    '
                          y = 0                                                  '
                          IF LEFT(DirList(x), 1) = CHR(9) THEN                   '
                            y = 1                                                '
                            DirList(x) = MID(DirList(x), 2)                      '
                          END IF                                                 '
                          TempString = ""                                        '
                          IF RIGHT(DirList(x), 11) = ".gopherlink" THEN          ' Retrieve descriptions
                              TempLink = ReadGopherLink(LocalFile + DirList(x))  ' ...
                              IF TempLink.Description = "" THEN TempLink.Description = TempLink.Server
                              IF TempLink.Description = "" AND UCASE(MID(TempLink.Selector, 1, 4)) = "URL:" THEN TempLink.Description = MID(TempLink.Selector, 5)
                              IF TempLink.Description = "" THEN TempLink.Description = LEFT(DirList(x), LEN(DirList(x)) - 11)
                              TempString = TempLink.Description
                              IF TempLink.Type = "1" THEN y = 1  ' If directory, then set y (checked later for sorting purposes)
                            ELSE
                              TempString = GetFileDescription(DirList(x), LocalFile)
                              IF LEN(TempString) = 0 THEN TempString = DirList(x)
                          END IF
                          DirList(x) = TempString + CHR(9) + DirList(x)
                          IF y = 1 THEN DirList(x) = CHR(9) + DirList(x)
                        NEXT x
                        LogLine("Found " & DirIndex & " items in the directory", 3)
                      REM  ***  Here I am sorting the directory's entries ***
                        IF DirIndex > 1 THEN strQsort(DirList(), DirIndex)  ' (included in sortstr.bi)
                        ' Now, we will display all entries
                        IF LEN(FileName) > 0 THEN PRINT "iWarning: Too much entries, only 20'000 are displayed!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "i"; CHR(9); "fake"; CHR(9); "NULL"; CHR(9); "0"; CRLF;
                        IF DirIndex > 0 THEN
                            FOR x = 1 TO DirIndex
                              IF RIGHT(DirList(x), 11) = ".gopherlink" THEN ' AND MID(DirList(x), 1, 1) <> CHR(9) THEN
                                  IF MID(DirList(x), 1, 1) = CHR(9) THEN DirList(x) = MID(DirList(x), 2)
                                  TempString = MID(DirList(x), 1, INSTR(DirList(x), CHR(9)) - 1)
                                  DirList(x) = MID(DirList(x), INSTR(DirList(x), CHR(9)) + 1)
                                  TempLink = ReadGopherLink(LocalFile + DirList(x))
                                  TempLink.Description = TempString
                                  IF TempLink.Selector = "" AND TempLink.Server = "" THEN TempLink.Selector = DirectoryToList + DirList(x)
                                  IF TempLink.Server = "" THEN TempLink.Server = GopherHostname
                                  IF TempLink.Type = "" THEN TempLink.Type = "1"
                                  IF UCASE(MID(TempLink.Selector, 1, 4)) = "URL:" THEN TempLink.Type = "h"
                                  IF TempLink.Port = "" THEN TempLink.Port = "70"
                                  IF LEFT(TempLink.Selector, 4) = "URL:" THEN
                                      PRINT TempLink.Type; TempLink.Description; CHR(9); TempLink.Selector; CHR(9); TempLink.Server; CHR(9); TempLink.Port; CRLF;
                                    ELSE
                                      PRINT TempLink.Type; TempLink.Description; CHR(9); TranslatePercentEnc(TempLink.Selector, 1); CHR(9); TempLink.Server; CHR(9); TempLink.Port; CRLF;
                                  END IF
                                ELSE
                                  IF MID(DirList(x), 1, 1) = CHR(9) THEN
                                      GopherType = "1"
                                      DirList(x) = MID(DirList(x), 2)
                                    ELSE
                                      GopherType = DetectGopherType(DirList(x))
                                  END IF
                                  EntryDescription = MID(DirList(x), 1, INSTR(DirList(x), CHR(9)) - 1)
                                  DirList(x) = MID(DirList(x), INSTR(DirList(x), CHR(9)) + 1)
                                  #IFDEF __FB_WIN32__
                                      PRINT GopherType; EntryDescription; CHR(9); AuthToken; TranslatePercentEnc(StrReplace(DirectoryToList, "\", "/") + DirList(x), 1); CHR(9); GopherHostname; CHR(9); GopherPort; CRLF;
                                    #ELSE
                                      PRINT GopherType; EntryDescription; CHR(9); AuthToken; TranslatePercentEnc(DirectoryToList + DirList(x), 1); CHR(9); GopherHostname; CHR(9); GopherPort; CRLF;
                                  #ENDIF
                              END IF
                            NEXT x
                            PRINT "."; CRLF;
                            LogLine("Response=""Return directory listing. (" + LocalFile + ")""", 1)
                          ELSE
                            LogLine("Response=""Empty Directory""", 1)
                            PRINT "iThis directory is empty."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
                        END IF
                    END IF
                END IF
              ELSE ' (Else than a directory)
                LogLine("The ressource is not a directory", 3)
                IF CheckForAuth(LocalFile, AuthToken, GopherRoot) = 1 THEN
                    LogLine("Response=""Password protected directory. Access denied.""", 1)
                    PRINT "iThis ressource is protected by a password. You have to authenticate at the directory level first."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
                  ELSE
                    IF fexist(LocalFile) <> 0 AND RIGHT(LocalFile, 13) <> DirSlash + ".motsognir.auth" THEN
                      LogLine("FileExists check: the file exists", 3)
                      IF LCASE(RIGHT(LocalFile, 4)) = ".cgi" AND GopherCgiSupport = 1 THEN
                          GopherSelector = DirectoryToList ' GopherSelector is a shared variable, while DirectoryToList is not
                          #IFDEF __FB_LINUX__
                            ExecCgi(LocalFile)
                          #ENDIF
                        ELSE
                          LogLine("Response=""Return file. (" + LocalFile + ")""", 1)
                          GopherType = DetectGopherType(LocalFile)
                          SELECT CASE GopherType
                            CASE "0", "2", "6"
                              OPEN LocalFile FOR INPUT AS #20
                              WHILE NOT EOF(20)
                                LINE INPUT #20, LineBuff
                                IF LineBuff = "." THEN LineBuff = ". "
                                PRINT LineBuff; CRLF;
                              WEND
                              CLOSE(20)
                              PRINT "."; CRLF;
                            CASE ELSE
                              OPEN LocalFile FOR BINARY AS #20
                              FileSizePosition = 1
                              WHILE LOF(20) - FileSizePosition > 1024        '
                                FileSizePosition += 1024                     ' Caching the file
                                GET #20, FileSizePosition - 1024, KByteBuff  ' into 1K blocks
                                PRINT KByteBuff;                             '
                              WEND
                              FOR FileSizePosition = FileSizePosition TO LOF(20)
                                GET #20, FileSizePosition, ByteBuff
                                PRINT ByteBuff;
                              NEXT FileSizePosition
                              CLOSE(20)
                          END SELECT
                        END IF
                      ELSE
                        LogLine("FileExists check: the file doesn't exists", 3)
                        LogLine("Response=""Ressource doesn't exist!""", 1)
                        PRINT "3The selected ressource doesn't exist!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF;
                        PRINT "iThe selected ressource cannot be located."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
                    END IF
                END IF
            END IF
        END IF
  END IF
END IF

ConnClose()
