FUNCTION GopherSecurityCheck(GophRequest AS STRING) AS STRING
  DIM AS STRING Result = ""
  DIM AS INTEGER x
  IF LEN(GophRequest) > 512 THEN Result = "The gopher request is longer than 512 bytes. The RFC 1436 states that the selector shouldn't be longer than 256 bytes."
  IF Result = "" THEN
    IF INSTR(GophRequest, CHR(0)) > 0 THEN Result = "A null char has been found in the gopher request. There's no reason for such char to be present there."
  END IF
  IF Result = "" THEN
    FOR x = 1 TO 31
      IF INSTR(GophRequest, CHR(x)) > 0 AND x <> 9 THEN Result = "A control char (ASCII 1..31) has been found in the request. There's no reason for such char to be present there."
    NEXT x
  END IF
  IF Result = "" THEN
    IF INSTR(GophRequest, CHR(9) + CHR(9)) > 0 THEN Result = "The client's request contains two TAB characters, one after the other. It shouldn't ever happen."
  END IF
  IF Result = "" THEN
    IF RIGHT(GophRequest, 1) = CHR(9) THEN Result = "The client's request is ended by a TAB character. There's no situation where that should happen."
  END IF
  IF Result = "" THEN
    IF INSTR(GophRequest, "*") > 0 THEN Result = "The client's request contains at least one wildcard character (*). I don't see any purpose to that, other than trying to do some nasty things."
  END IF
  RETURN Result
END FUNCTION
