FUNCTION DetectGopherType(FilenameString AS STRING) AS STRING
  DIM GopherType AS STRING
  IF INSTR(FilenameString, ".") > 0 THEN
    SELECT CASE LCASE(MID(FilenameString, INSTRREV(FilenameString, ".")))
      CASE ".txt"
        GopherType = "0"
      CASE ".gif"
        GopherType = "g"
      CASE ".jpg", ".jpeg", ".png", ".bmp", ".pcx", ".ico", ".tif", ".tiff", ".svg", ".eps"
        GopherType = "I"
      CASE ".mp3", ".mp2", ".wav", ".mid", ".ogg", ".wma", ".flac", ".mpc", ".aiff", ".aac"
        GopherType = "s"
      CASE ".htm", ".html"
        GopherType = "h"
      CASE ".pdf"
        GopherType = "P"
      CASE ELSE
        GopherType = "9"
    END SELECT
  ELSE
    GopherType = "9"
  END IF
  RETURN GopherType
END FUNCTION
