/*
 * This file is part of the Gopherus project.
 * Copyright (C) Mateusz Viste 2013

    .---.           _....._
   /  p  `\     .-""`:     :`"-.
   |__   - |  ,'     .     '    ',
    ._>    \ /:      :     ;      :,
     '-.    '\`.     .     :     '  \
        `.   | .'._.' '._.' '._.'.  |
          `;-\.   :     :     '   '/,__,
          .-'`'._ '     .     : _.'.__.'
         ((((-'/ `";--..:..--;"` \
             .'   /           \   \
       jgs  ((((-'           ((((-'

       The ASCII drawing is Copyright (C) Joan G. Stark
 */

#include <stdio.h>  /* sprintf() */

/* loads the embedded start page into a memory buffer and returns */
int loadembeddedstartpage(char *buffer, char *token, char *pVer, char *pDate) {
  int x = 0, y;
  char linebuff[80];
  const char *wel1 = "i                                           .---.           _....._\n"
                     "i Welcome to Gopherus, a multiplatform,    /  p  `\\     .-\"\"`:     :`\"-.\n"
                     "i console-mode gopher client.              |__   - |  ,'     .     '    ',\n"
                     "i                                           ._>    \\ /:      :     ;      :,\n"
                     "i You'll find below a few gopher links that  '-.    '\\`.     .     :     '  \\\n";
  const char *wel2 = "i might help you start your journey in the      `.   | .'._.' '._.' '._.'.  |\n"
                     "i gopher world, as well as a few documents        `;-\\.   :     :     '   '/,__,\n"
                     "i related to Gopherus.                            .-'`'._ '     .     : _.'.__.'\n"
                     "i If you wish to go to a location you already    ((((-'/ `\";--..:..--;\"` \\\n"
                     "i know, enter its URL into the URL bar above         .'   /       jgs \\   \\\n"
                     "i (press TAB to switch to the URL bar).             ((((-'           ((((-'\n";
  const char *wel3 = "i\n"
                     "1Veronica - A gopher search engine\t/v2\tgopher.floodgap.com\t70\n"
                     "1Super Dimension Fortress (non-profit gopher hosting)\t\tsdf.org\t70\n"
                     "1The Online Book Initiative\t1/The Online Book Initiative\tgopher.std.com\t70\n"
                     "1The Gopherus home gopher hole\t/projects/gopherus\tgopher.viste-family.net\t70\n"
                     "i\n"
                     "iGopherus (offline) documentation:\n"
                     "0The Gopherus manual\t\t#manual\t70\n"
                     "0Read the Gopherus licensing rules (GNU GPL v3)\t\t#license\t70\n";

  const char *lic1 = "\n"
                     " This program is free software: you can redistribute it and/or modify it under\n"
                     " the terms of the GNU General Public License as published by the Free Software\n"
                     " Foundation, either version 3 of the License, or (at your option) any later\n"
                     " version.\n"
                     "\n";
  const char *lic2 = " This program is distributed in the hope that it will be useful, but WITHOUT\n"
                     " ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n"
                     " FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n"
                     "\n"
                     " You should have received a copy of the GNU General Public License along with\n"
                     " this program. If not, see <http://www.gnu.org/licenses/>.";

  const char *man1 = "\n"
                     " Gopherus is a console-mode gopher client. It's entirely keyboard-driven, thus\n"
                     " knowing its key bindings is mandatory for comfortable gopher browsing.\n"
                     "\n"
                     " Key bindings:\n"
                     "   TAB       - Switch to/from URL bar edition\n"
                     "   ESC       - Quit Gopherus (requires a confirmation)\n"
                     "   UP/DOWN   - Scroll the screen's content up/down by one line\n"
                     "   PGUP/PGDW - Scroll the screen's content up/down by one page\n";
  const char *man2 = "   HOME/END  - Go to the begin/end of the document\n"
                     "   BACKSPC   - Go back to the previous location\n"
                     "   F5        - Refresh current location\n"
                     "   F9        - Download location on disk\n"
                     "\n"
                     " Gopherus has been written with care to behave nicely and follow standards.\n"
                     " It conforms closely to following guidelines:\n"
                     "   RFC 1436: The Internet Gopher Protocol\n"
                     "   RFC 4266: The gopher URI Scheme";

  if (token[0] == 'l') { /* license */
      sprintf(linebuff, "\n Gopherus v%s Copyright (C) Mateusz Viste %s\n", pVer, pDate);
      for (y = 0; linebuff[y] != 0; ) buffer[x++] = linebuff[y++];
      for (y = 0; lic1[y] != 0; ) buffer[x++] = lic1[y++];
      for (y = 0; lic2[y] != 0; ) buffer[x++] = lic2[y++];
      return(x);
    } else if (token[0] == 'm') { /* manual */
      sprintf(linebuff, "\n Gopherus v%s Copyright (C) Mateusz Viste %s\n", pVer, pDate);
      for (y = 0; linebuff[y] != 0; ) buffer[x++] = linebuff[y++];
      for (y = 0; man1[y] != 0; ) buffer[x++] = man1[y++];
      for (y = 0; man2[y] != 0; ) buffer[x++] = man2[y++];
      return(x);
    } else { /* welcome screen */
      sprintf(linebuff, "i\ni          ***  Gopherus v%s Copyright (C) Mateusz Viste %s  ***\n", pVer, pDate);
      for (y = 0; linebuff[y] != 0; ) buffer[x++] = linebuff[y++];
      for (y = 0; wel1[y] != 0; ) buffer[x++] = wel1[y++];
      for (y = 0; wel2[y] != 0; ) buffer[x++] = wel2[y++];
      for (y = 0; wel3[y] != 0; ) buffer[x++] = wel3[y++];
      return(x);
  }
}
