/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include "wresrtns.h"
#include "read.h"
#include "reserr.h"

int WResReadExtraWResID( WResID * name, WResFileID handle )
/*********************************************************/
/* reads the extra bytes into the end of the structure */
/* assumes that the fixed portion has just been read in and is in name and */
/* that name is big enough to hold the extra bytes */
{
    int         numread;
    uint_16     extrabytes;

    if (name->IsName) {
        extrabytes = name->ID.Name.NumChars - 1;
        if (extrabytes > 0) {
            numread = (* WRESREAD) ( handle, &(name->ID.Name.Name[1]),
                        extrabytes );
            if( numread == -1 ) {
                WRES_ERROR( WRS_READ_FAILED );
                return( TRUE );
            } else if( numread != extrabytes ) {
                WRES_ERROR( WRS_READ_INCOMPLETE );
                return( TRUE );
            }
        }
    }
    return( FALSE );
}
