#ifndef NUMERICLIST_HXX
#define NUMERICLIST_HXX

class NUMERICLIST {
private:
  PNUMERICFLD table;      // the table of attribute/numeric data
  INT4        Count;      // count of items in table
  INT         Attribute;  // which USE attribute this table maps
  INT4        Pointer;    // current position
  INT4        MaxEntries; // current maximum size of table - see Resize()
  INT4        StartIndex;
  INT4        EndIndex;
  INT         Relation;   // what relation generated StartIndex, EndIndex
  STRING      FileName;   // the file which attributes/numeric data are in
  INT         Ncoords;    // Number of values in an entry
public:
  NUMERICLIST();
  NUMERICLIST(INT n);
  void   SetRelation(INT Relation);
  INT    GetRelation();
  DOUBLE GetNumericValue(INT i);
  INT    GetAttribute();             // return the USE attribute for this table
  void   SetAttribute(INT x);        // set the USE attribute
  INT4   GetCount();                 // get number of items in table
//  INT4 Find(DOUBLE Key, INT Relation); // sets startIndex and endIndex
  void   Expand();                   // make room for more entries
  void   Cleanup();                  // collapse size to total entries
  void   Sort();                     // sort numeric field items
  INT4   DiskFind(STRING Fn, DOUBLE Key, INT4 Relation);
  INT4   GetGlobalStart(INT4 i);
  void   Dump(INT4 start, INT4 end); // dump numeric field data
  void   Resize( INT4 Entries);      // resize table to Entries size
  void   SetFileName(STRING s);      // set file name to load from
  void   SetFileName(PCHR s);        // set file name to load from
  void   TempLoad();                 // test routine
//  void LoadTable();                // load data from set file name
  void   LoadTable(INT4 Start, INT4 End);
  void   WriteTable();
  void   ResetHitPosition();
  INT4   GetNextHitPosition();
  void   SetCoords(INT n);
  INT    GetCoords();
  ~NUMERICLIST();
};

typedef NUMERICLIST* PNUMERICLIST;
#endif

