

#ifndef MERGEUNIT_HXX
#define MERGEUNIT_HXX

#include "defs.hxx"
#include "idbobj.hxx"

#define LIM 10000

class MERGEUNIT{
	
 public:
  MERGEUNIT();
  GDT_BOOLEAN Smallest(PSTRING small);
  GDT_BOOLEAN Initialize(STRING& FileName,const PIDBOBJ DbParent,
			 FILEMAP *map, INT IDValue); // true = success
  GDT_BOOLEAN Empty();				     // true = no more entries
  GPTYPE GetGp(); // returns the GP
  void GetSistring (PSTRING a);
  GDT_BOOLEAN Flush(FILE *fout);
  GDT_BOOLEAN Load();		// get more items
  void Write(FILE *fout);
  GDT_BOOLEAN CacheLoad();	// Load Cache From Disk
  void SetLoadLimit(INT lim);
  
  ~MERGEUNIT();
  
private:
  GDT_BOOLEAN CacheEmpty();
  GDT_BOOLEAN GetIndirectBuffer(const GPTYPE Gp, PSTRING Buffer); 
  PIDBOBJ Parent;
  FILE *fp;			// file of GP's to read from
  STRING sistring;
  GPTYPE Gp;
  FILEMAP *Map;
  INT CachePosition;
  INT LoadLim,ID,CacheWritten,FlushWritten,CacheFlush;
  INT ItemsToMerge,TotalLoaded;
  
  GPTYPE *list;
  INT *Start;
  
  STRING *sistrings;
 // STRING *names;
  CHR *Tag;
};



typedef MERGEUNIT *PMERGEUNIT;
#endif
