#ifndef INTERVALLIST_HXX
#define INTERVALLIST_HXX

class INTERVALLIST : public NUMERICLIST {
private:

  PINTERVALFLD table;      // the table of attribute/numeric data
  INT4         Count;      // count of items in table
  INT          Attribute;  // which USE attribute this table maps
  INT4         Pointer;    // current position
  INT4         MaxEntries; // current maximum size of table - see Resize()
  INT4         StartIndex;
  INT4         EndIndex;
  INT          Relation;   // what relation generated StartIndex, EndIndex
  STRING       FileName;   // the file which attributes/numeric data are in
  INT          Ncoords;    // Number of values in an entry

public:
  INTERVALLIST();
  INTERVALLIST(INT n);
/*
  void   SetRelation(INT Relation);
  INT    GetRelation();
  INT    GetAttribute();             // return the USE attribute for this table
  void   SetAttribute(INT x);        // set the USE attribute
//  INT4 Find(DOUBLE Key, INT Relation); // sets startIndex and endIndex
  void   TempLoad();                 // test routine
  void   ResetHitPosition();
  INT4   GetNextHitPosition();
*/
  void   SortByStart();              // sort numeric field items
  void   SortByEnd();                // sort numeric field items
  void   LoadTable(INT4 Start, INT4 End);
  void   LoadTable(INT4 Start, INT4 End, INT Offset);
  void   WriteTable();
  void   WriteTable(INT Offset);
  INT4   GetGlobalStart(INT4 i);
  DOUBLE GetStartValue(INT i);
  DOUBLE GetEndValue(INT i);
  void   SetCoords(INT n);
  INT    GetCoords();
  void   SetFileName(STRING s);      // set file name to load from
  void   SetFileName(PCHR s);        // set file name to load from
  INT4   GetCount();                 // get number of items in table
  void   Expand();                   // make room for more entries
  void   Cleanup();                  // collapse size to total entries
  void   Resize( INT4 Entries);      // resize table to Entries size
  INT4   DiskFind(STRING Fn, DOUBLE Key, INT4 Relation, 
		  GDT_BOOLEAN ByStart);
  INT4   DiskDateFind(STRING Fn, DOUBLE Key, INT4 Relation, 
		      GDT_BOOLEAN ByStart);
  void   Dump(INT4 start, INT4 end); // dump numeric field data
  ~INTERVALLIST();
};

typedef INTERVALLIST* PINTERVALLIST;
#endif

