/* $Id: index.cxx,v 1.22 1997/04/04 09:07:03 cnidr Exp $ */
/************************************************************************
Copyright Notice

Copyright (c) MCNC, Clearinghouse for Networked Information Discovery
and Retrieval, 1994.

Permission to use, copy, modify, distribute, and sell this software and
its documentation, in whole or in part, for any purpose is hereby
granted without fee, provided that

1. The above copyright notice and this permission notice appear in all
copies of the software and related documentation. Notices of copyright
and/or attribution which appear at the beginning of any file included in
this distribution must remain intact.

2. Users of this software agree to make their best efforts (a) to return
to MCNC any improvements or extensions that they make, so that these may
be included in future releases; and (b) to inform MCNC/CNIDR of
noteworthy uses of this software.

3. The names of MCNC and Clearinghouse for Networked Information
Discovery and Retrieval may not be used in any advertising or publicity
relating to the software without the specific, prior written permission
of MCNC/CNIDR.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT SHALL MCNC/CNIDR BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
************************************************************************/

/*@@@
File:		index.cxx
Version:	1.01
$Revision: 1.22 $
Description:	Class INDEX
Author:		Nassib Nassar, nrn@cnidr.org
@@@*/

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>

#include "defs.hxx"
#include "string.hxx"
#include "vlist.hxx"
#include "strlist.hxx"
#include "common.hxx"
#include "sw.hxx"
#include "soundex.hxx"
#include "nfield.hxx"
#include "nlist.hxx"
#include "intfield.hxx"
#include "intlist.hxx"
#include "attr.hxx"
#include "attrlist.hxx"
#include "dfd.hxx"
#include "dfdt.hxx"
#include "fc.hxx"
#include "fct.hxx"
#include "df.hxx"
#include "dft.hxx"
#include "record.hxx"
#include "mdtrec.hxx"
#include "mdt.hxx"
#include "result.hxx"
#include "idbobj.hxx"
#include "iresult.hxx"
#include "opobj.hxx"
#include "operand.hxx"
#include "rset.hxx"
#include "irset.hxx"
#include "opstack.hxx"
#include "squery.hxx"
#include "dtreg.hxx"
#include "rcache.hxx"
#include "index.hxx"
#include "fprec.hxx"
#include "fpt.hxx"
#include "registry.hxx"
#include "idb.hxx"
#include "mergeunit.hxx"
#include "filemap.hxx"
#ifdef DICTIONARY
#include "dictionary.hxx"
#endif

//const INT StopWordSize = 400;
const INT StopWordSize = (sizeof(stoplist)/sizeof(stoplist[0]));
#define CACHELIMIT 50000	// 50,000 entries, at 8 bytes each

static PCHR MemoryData;
static INT MemoryDataLength;

void BufferClean(PCHR Buffer)
{
  INT z;
  for (z = 0; z<StringCompLength; z++) {
    if (!isalnum(Buffer[z]))
      Buffer[z] = ' ';
  }
}

INDEX::INDEX(const PIDBOBJ DbParent, const STRING& NewFileName) 
{
  STRING CheckName;
  CHR Tmp[256];
  Parent = DbParent;
  IndexFileName = NewFileName;
  Parent->ComposeDbFn(&CheckName, ".num");
  //  SetCache=new RCACHE(Parent);
  // see if .num file exists...  
  FILE *fa=Parent->ffopen(CheckName,"r");
  if(fa){
    fgets(Tmp,256,fa);
    IndexNum=atoi(Tmp);
    fclose(fa);
  }else
    IndexNum=0;
#ifdef DICTIONARY
  Dict = new DICTIONARY(DbParent);
#endif
}

void INDEX::SetDocTypePtr(const PDOCTYPE NewDocTypePtr) {
  DocTypePtr = NewDocTypePtr;
}

PDOCTYPE INDEX::GetDocTypePtr() {
  return DocTypePtr;
}

int MemIndexCompare(const void* x, const void* y) {
  return strncmp(MemoryData + (*((PGPTYPE)x)),
		     MemoryData + (*((PGPTYPE)y)), StringCompLength);
}
/*
int MemIndexCompare(const void* x, const void* y) {
  INT result;
  INT MaxCompare;
  INT t = MemoryDataLength - ((*((PGPTYPE)y)));
  MaxCompare = MemoryDataLength - ((*((PGPTYPE)x)));
  if (t < MaxCompare) {
    MaxCompare = t;
  }
  if (StringCompLength < MaxCompare) {
    MaxCompare = StringCompLength;
  }
//  result = strncasecmp(MemoryData + (*((PGPTYPE)x)),
  result = strncmp(MemoryData + (*((PGPTYPE)x)),
		       MemoryData + (*((PGPTYPE)y)), MaxCompare);
  return result;
}
*/

#ifdef DICTIONARY
void INDEX::CreateDictionary(void) {
  Dict->CreateNew();
}

void INDEX::CreateCentroid(void) {
  FILE *out;
  STRING CentroidName;
  Parent->ComposeDbFn(&CentroidName, DbExtCentroid);
  out = Parent->ffopen(CentroidName, "w");
  if (!out) {
    cout << "Can't open " << CentroidName << ':';
    cout << strerror(errno) << endl;
  }
  if (Dict->GetSearchable())
    Dict->Print(out);
  else {
    cout << "You must generate a dictionary with the -dict option,";
    cout << "before you can create a centroid." << endl;
  }
}
#endif

void INDEX::SortNumericFieldData()
{
  INT total;
  INT x;
  DFD DfdRecord;
  STRING FieldName,FieldType,Fn;
  INT4 Count;

  total = Parent->DfdtGetTotalEntries();

  for (x=1; x<=total; x++) {
    Parent->DfdtGetEntry(x,&DfdRecord);
    DfdRecord.GetFieldType(&FieldType);
    if (FieldType.CaseEquals("TEXT")) {
      continue;
    } else if ((FieldType.CaseEquals("NUM")) 
	       || (FieldType.CaseEquals("DATE"))) {
      NUMERICLIST NumList;
      DfdRecord.GetFieldName(&FieldName);
      Parent->DfdtGetFileName(FieldName,&Fn);
      NumList.SetFileName(Fn);
      NumList.LoadTable(0,-1);
      Count = NumList.GetCount();
      if (Count > 1) {
	NumList.Sort();
	NumList.WriteTable();
      }
      // Debugging
/*
      if (Count > 0) {
	cout << "\nDumping " << FieldName << endl;
	cout << "Debug output:" << endl;
	NUMERICLIST NL;
	NL.SetFileName(Fn);
	NL.LoadTable(0,-1);
	NL.Dump(0,Count);
      } else
	cout << "Empty field " << FieldName << endl;
*/

    } else if (FieldType.CaseEquals("DATE-RANGE")) {
      INTERVALLIST IntList;
      DfdRecord.GetFieldName(&FieldName);
      Parent->DfdtGetFileName(FieldName,&Fn);
      IntList.SetFileName(Fn);
      IntList.LoadTable(0,-1);
      Count = IntList.GetCount();
      if (Count > 1) {
	PCHR Fname;
	Fname = Fn.NewCString();
	unlink(Fname);
	delete Fname;

	IntList.SortByStart();
//	IntList.Dump(0,Count);
	IntList.WriteTable(0);
	cout << endl;
	IntList.SortByEnd();
//	IntList.Dump(0,Count);
	IntList.WriteTable(Count);
      }
/*
      if (Count > 0) {
	cout << "\nDumping " << FieldName << endl;
	cout << "Debug output:" << endl;
	INTERVALLIST NL;
	NL.SetFileName(Fn);
	NL.LoadTable(0,-1,0);
	cout << Count << " records sorted by start:\n" << endl;
	NL.Dump(0,Count);

	NL.LoadTable(0,-1,Count);
	cout << Count << " records sorted by end:\n" << endl;
	NL.Dump(0,Count);

      } else
	cout << "Empty field " << FieldName << endl;
*/
    } else {
      continue;
    }
  }
  return;
}

FILE *flist[40];
STRING Names[40];
INT fcount=0;

void INDEX::WriteFieldData(const RECORD& Record, const GPTYPE GpOffset) 
{
  DFT dft;
  Record.GetDft(&dft);
  INT total = dft.GetTotalEntries();
  SIZE_T ytotal;
  INT x, y;
  DF df;
  FCT fct;
  FC fc;
  PFILE fp;
  STRING FieldName, FileName;
  STRING FieldType;
  GPTYPE gp;
  PCHR Buffer;
  INT4 fLen;
  INT4 Val;
  GDT_BOOLEAN doClose;
  DOUBLE fVal;
  DOUBLE fStartVal, fEndVal;
 
  STRING tmp;
  CHR MyFile[256],tt[256],*p;
  INT FileVal,k,j;

  PDOCTYPE DocTypePtr;
  STRING DocType;
  Record.GetDocumentType(&DocType);
  DocTypePtr = GetDocTypePtr();
 
  for (x=1; x<=total; x++) {
    dft.GetEntry(x, &df);
    df.GetFieldName(&FieldName);
   
    Parent->FieldTypes.GetValue(FieldName, &FieldType);
    Parent->DfdtGetFileName(FieldName, &FileName);
    
    // do a simple test cache here...
    
    doClose=GDT_FALSE;
    fp=(FILE*)NULL;
    /*
    for(j=0; j<fcount; j++){
  
      if(FileName.Equals(Names[j])){
	fp=flist[j]; 
	//cout <<"file "<<FileName<<" hit in cache"<<endl;
	break;
      }
    }
    */

    if(fp==NULL){
      
      fp = Parent->ffopen(FileName, "ab");
      if (!fp) {
	perror(FileName);    
	exit(1);
      }
      /*
      if(fcount<39){
	//cout << "Add " << FileName << endl;
	Names[fcount]=FileName;
	flist[fcount++]=fp;
      }else
	doClose=GDT_TRUE;
	*/
    }
    
    df.GetFct(&fct);
    ytotal = fct.GetTotalEntries();
    for (y=1; y<=ytotal; y++) {
      fct.GetEntry(y, &fc);
      
      if (FieldType.CaseEquals("text")) {
	gp = fc.GetFieldStart() + GpOffset;
	//	fwrite(&gp, 1, sizeof(GPTYPE), fp);
	
	Parent->GpFwrite(&gp, 1, sizeof(GPTYPE), fp);
	gp = fc.GetFieldEnd() + GpOffset;
	
	//	fwrite(&gp, 1, sizeof(GPTYPE), fp);
	Parent->GpFwrite(&gp, 1, sizeof(GPTYPE), fp);
	
#ifdef DEBUG
	cout << "FieldName=" << FieldName << endl;
	cout << "FieldType=" << FieldType;
	cout << ", gp(start)=" << gp;
	cout << ", gp(end)=" << gp << endl;
#endif
	
	
      } else if (FieldType.CaseEquals("num")) {
	
	gp = fc.GetFieldStart() + GpOffset;
	fwrite((char*)&gp, 1, sizeof(GPTYPE), fp); // explicit cast
	
	fLen = fc.GetFieldEnd() - fc.GetFieldStart() + 1;
	Buffer = new CHR [fLen+1];
	GetIndirectBuffer(gp,Buffer,0,fLen);
	//	Buffer[fLen] = '\0';
	fVal = DocTypePtr->ParseNumeric(Buffer);
	
	fwrite((char*)&fVal, 1, sizeof(DOUBLE), fp); // explicit cast
	
#ifdef DEBUG
	cout << "FieldName=" << FieldName << endl;
	cout << "FieldType=" << FieldType;
	cout << ", gp=" << gp;
	cout << ", Val=" << fVal<< endl;
#endif
	
	delete Buffer;
	
      } else if (FieldType.CaseEquals("date")) {
	
	fLen = fc.GetFieldEnd() - fc.GetFieldStart() + 1;
	gp = fc.GetFieldStart() + GpOffset;
	Buffer = new CHR [fLen+1];
	GetIndirectBuffer(gp,Buffer,0,fLen);
	//	Buffer[fLen] = '\0';
	
	fVal = DocTypePtr->ParseDateSingle(Buffer);
	if (fVal > 0.0) {
	  fwrite((char*)&gp, 1, sizeof(GPTYPE), fp); // explicit cast
	  
	  fwrite((char*)&fVal, 1, sizeof(DOUBLE), fp); // explicit cast
	  
#ifdef DEBUG
	  cout << "FieldName=" << FieldName << endl;
	  cout << "FieldType=" << FieldType;
	  cout << ", gp=" << gp;
	  cout << ", Val=" << fVal<< endl;
#endif
	  
	}
	delete Buffer;
	
      } else if (FieldType.CaseEquals("date-range")) {
	
	gp = fc.GetFieldStart() + GpOffset;
	fLen = fc.GetFieldEnd() - fc.GetFieldStart() + 1;
	
	Buffer = new CHR [fLen+1];
	GetIndirectBuffer(gp,Buffer,0,fLen);
	//	Buffer[fLen] = '\0';
	
	DocTypePtr->ParseDateRange(Buffer,&fStartVal,&fEndVal);
	fwrite((char*)&gp, 1, sizeof(GPTYPE), fp); // explicit cast
	fwrite((char*)&fStartVal, 1, sizeof(DOUBLE), fp); // explicit cast
	fwrite((char*)&fEndVal, 1, sizeof(DOUBLE), fp); // explicit cast
	
#ifdef DEBUG
	cout << "FieldName=" << FieldName << endl;
	cout << "FieldType=" << FieldType << endl;
	cout << "gp=" << gp;
	cout << ", [" << fStartVal;
	cout << ", " << fEndVal << "]" << endl;
#endif
	
	delete Buffer;
	
      } else {
	gp = fc.GetFieldStart() + GpOffset;
	//	fwrite(&gp, 1, sizeof(GPTYPE), fp);
	Parent->GpFwrite(&gp, 1, sizeof(GPTYPE), fp);
	gp = fc.GetFieldEnd() + GpOffset;
	//	fwrite(&gp, 1, sizeof(GPTYPE), fp);
	Parent->GpFwrite(&gp, 1, sizeof(GPTYPE), fp);
#ifdef DEBUG
	cout << "FieldName=" << FieldName << endl;
	cout << "No FieldType";
	cout << ", gp(start)=" << gp;
	cout << ", gp(end)=" << gp << endl;
#endif
      }
    } 
    
    //    if(doClose)
      Parent->ffclose(fp);
    
  }

  
}

void INDEX::SetMergeStatus(GDT_BOOLEAN a)
{
  MergeStatus=a;
}


void INDEX::AddRecordList(PFILE RecordListFp) 
{
  UINT4 DataMemorySize = (UINT4)(Parent->GetIndexingMemory() );

  // JMF Test

  //DataMemorySize=5000;
  
  //  UINT4 IndexMemorySize = (UINT4)((DataMemorySize / 3) * sizeof(GPTYPE));
  //  PGPTYPE MemoryIndex = new GPTYPE[(IndexMemorySize / sizeof(GPTYPE)) + 1];


  UINT4 IndexMemorySize = (UINT4)(DataMemorySize / 3); // jw patch
  PGPTYPE MemoryIndex = new GPTYPE[IndexMemorySize+1]; // jw patch
  
  MemoryData = new CHR[DataMemorySize];
  INT FirstRecord = 1;
  INT CurrentRecord;
  INT MemoryIndexLength;
  PFILE DataFp = 0;
  RECORD record;
  STRING s, DataFileName, OldDataFileName;
  MDTREC mdtrec;
  UINT4 DataFileSize;
  INT GpListSize;
  INT Error;
  GPTYPE TrueGlobalStart = 0;
  GPTYPE TrueGlobalEnd = 0;
  GPTYPE OldGlobalStart=0;
  MDTREC lastmdtrec;
  INT j;
  PCHR p;
  CHR TempBuffer[80];
  STRING RecordFlag;
  STRING Doctype;
  GDT_BOOLEAN Break;
  INT rcount=0,didmod=0;

  Break = GDT_FALSE;
  do {
    CurrentRecord = FirstRecord;
    Error = 0;
    MemoryDataLength = 0;
    MemoryIndexLength = 0;
    MemoryData[0] = (CHR)NULL;
    OldGlobalStart = Parent->GetMainMdt()->GetNextGlobal();

    do {
      didmod=1;
      if (!Break) {
	RecordFlag.FGet(RecordListFp, 3);
      }
      if ( (RecordFlag == "#") || (Break) ) {
	
	if (!Break) {
	  record.Read(RecordListFp);
	}
	Break = GDT_FALSE;
	record.GetFullFileName(&DataFileName);
	if (!DataFileName.Equals(OldDataFileName)) {
	  if (DataFp) {
	    fclose(DataFp);
	  }
	  DataFp = fopen(DataFileName, "rb");
	}
	if (!DataFp) {
	  // ER
	  cout << "   Skipping file ";
	  DataFileName.Print();
	  cout << " ... (Error opening file)" << endl;
	  CurrentRecord++;
	} else {
	  if (record.GetRecordEnd() == 0) {
	    //	    fseek(DataFp, 0L, 2);
	    fseek(DataFp, 0L, SEEK_END);
	    DataFileSize = ftell(DataFp);
	  } else {
	    DataFileSize = record.GetRecordEnd() -
	      record.GetRecordStart() + 1;
	  }
	  
	  if (!DataFileName.Equals(OldDataFileName)) {
	    // We're in a new document file, so update global pointers

	    /*
	      if (MemoryDataLength) {	// <<<-------------
	      MemoryDataLength++;	// <<<-------------
	      }
	      */
	    Parent->IndexingStatus(IndexingStatusParsingDocument,
				   &DataFileName, 0);
	    TrueGlobalStart = Parent->GetMainMdt()->GetNextGlobal();
	    //	    fseek(DataFp, 0, 2);
	    fseek(DataFp, 0L, SEEK_END);
	    TrueGlobalEnd = TrueGlobalStart + ftell(DataFp) - 1;
	    
	  }
	  
	  if ( DataFileSize >= DataMemorySize ) {
	    cout << "One of the document records you are indexing ";
	    cout << "is too large for the amount" << endl;
	    cout << "of memory allocated by Iindex.  Use the `-m' ";
	    cout << "option to set a value" << endl;
	    cout << "greater than the largest document record you ";
	    cout << "are indexing.  For example," << endl;
	    cout << "use `-m 2' if the largest document is 1.5 MB." << endl;
	    exit(1);
	  }
	  
	  if ( (DataFileSize + MemoryDataLength) >= DataMemorySize ) {
	    Break = GDT_TRUE;
	    break;
	  }
	  //	  fseek(DataFp, record.GetRecordStart(), 0); // core dump
	  fseek(DataFp, (long)record.GetRecordStart(), SEEK_SET); // core dump

#ifdef DEBUG
	  cout << "Reading " << DataFileSize << " bytes into MemoryData array";
	  cout << " (length=" << strlen(MemoryData);
	  cout << "), at offset " << MemoryDataLength << endl;
#endif

	  fread(MemoryData + MemoryDataLength, 1, DataFileSize,
		DataFp);
	  
	  for (p = MemoryData + MemoryDataLength;
	       p < (MemoryData + MemoryDataLength + DataFileSize); p++) {
	    *p = tolower(*p);
	    if (!isalnum(*p)) {
	      *p = ' ';
	    }
	  }
	  *p = '\0';			// Add a NULL to terminate the record
	  record.GetDocumentType(&Doctype);
	  GpListSize = BuildGpList(Doctype, 
				   MemoryDataLength,
				   MemoryData,
				   MemoryDataLength + DataFileSize,
				   MemoryIndex + MemoryIndexLength,
				   IndexMemorySize - MemoryIndexLength);
	  if (GpListSize == -1) {
	    // ??
	    Break = GDT_TRUE;
	    break;
	  }

	  record.GetDocumentType(&s);
	  mdtrec.SetDocumentType(s);
	  record.GetPathName(&s);
	  mdtrec.SetPathName(s);
	  record.GetFileName(&s);
	  mdtrec.SetFileName(s);
	  mdtrec.SetLocalRecordStart(record.GetRecordStart());
	  if ( (record.GetRecordStart() == 0) &&
	      (record.GetRecordEnd() == 0) ) {
	    mdtrec.SetLocalRecordEnd(DataFileSize - 1);
	  } else {
	    mdtrec.SetLocalRecordEnd(record.GetRecordEnd());
	  }
	  
	  mdtrec.SetGlobalFileStart(TrueGlobalStart);
	  mdtrec.SetGlobalFileEnd(TrueGlobalEnd);
	  
	  record.GetKey(&s);
	  // Something that needs to be added somewhere:
	  // If record already contains a user-defined key,
	  // we need to make sure that it is unique!
	  if (s == "") {
	    sprintf(TempBuffer, "%d", 
		    mdtrec.GetGlobalFileStart() 
		    + mdtrec.GetLocalRecordStart());
	    s = TempBuffer;
	    Parent->GetMainMdt()->GetUniqueKey(&s);
	  }
	  mdtrec.SetKey(s);
	  
	  MemoryDataLength += DataFileSize;
	  //	  MemoryDataLength += DataFileSize+1;
	  
	  MemoryIndexLength += GpListSize;
#ifdef DEBUG
	  STRING XXX;
	  mdtrec.GetKey(&XXX);
	  cout << "MDTrec key=" << XXX;
	  cout << endl;
	  cout << "MDTrec LocalRecordStart=" << mdtrec.GetLocalRecordStart();
	  cout << endl;
	  cout << "MDTrec LocalRecordEnd=" << mdtrec.GetLocalRecordEnd() ;
	  cout << endl;
	  cout << "MDTrec GlobalFileStart=" << mdtrec.GetGlobalFileStart();
	  cout << endl;
	  cout << "MDTrec GlobalFileEnd=" << mdtrec.GetGlobalFileEnd() ;
	  cout << endl;
#endif				/* DEBUG */
	  Parent->GetMainMdt()->AddEntry(mdtrec);
	  OldDataFileName = DataFileName;
	  CurrentRecord++;
	  
#ifdef VERBOSE
	  cout << "   ...Parsing fields" << endl;
#endif
	  
	  Parent->ParseFields(&record);
	  
#ifdef VERBOSE
	  cout << "   ...Writing field data" << endl;
#endif
	  
	  WriteFieldData(record, mdtrec.GetGlobalFileStart() +
			 mdtrec.GetLocalRecordStart());
	}
	if (Break) {
	  break;
	}
      }
    } while (RecordFlag == "#");
    if (Error == 0) {
      Parent->IndexingStatus(IndexingStatusIndexing, 0,
			     MemoryIndexLength);
      qsort(MemoryIndex, MemoryIndexLength, sizeof(GPTYPE),
	    MemIndexCompare);
    //  Parent->IndexingStatus(IndexingStatusMerging, 0, 0);
      FlushIndexFiles(MemoryData, MemoryDataLength, MemoryIndex,
		 MemoryIndexLength, OldGlobalStart);

    }
    FirstRecord = CurrentRecord;
  } while (RecordFlag == "#");
  fclose(DataFp);
  
  //  DumpIndex(0);
  
  delete [] MemoryData;
  delete [] MemoryIndex;
  
  // Now that we're done with the main index we need to sort the numeric
  // field tables.
  SortNumericFieldData();

  // now, do our *experimental* merge

  {
    FILE *fy;
    STRING CheckName;
    Parent->ComposeDbFn(&CheckName, ".num");
  
    fy=Parent->ffopen(CheckName,"w");
    fprintf(fy,"%d\n",IndexNum);
    Parent->ffclose(fy);

    CHR *oldpath,*newpath;
    struct stat info;
    if (IndexNum == 1) {
      // Rename the index file if there was only one chunk
      Parent->ComposeDbFn(&CheckName, ".inx");
      newpath = CheckName.NewCString();
      CheckName.Cat(".1");
      oldpath = CheckName.NewCString();
      rename(oldpath,newpath);
      delete oldpath;
      delete newpath;
    } else if (IndexNum > 1) {
      // And if we're appending, we may need to rename *.inx to *.inx.1
      Parent->ComposeDbFn(&CheckName, ".inx");
      oldpath = CheckName.NewCString();
      if (stat(oldpath, &info) ==0) {
	CheckName.Cat(".1");
	newpath = CheckName.NewCString();
	rename(oldpath,newpath);
	delete newpath;
      }
      delete oldpath;
    }

  }
  if(MergeStatus==GDT_TRUE)
    MergeIndexFiles(Parent->GetIndexingMemory());
  
}

#define MAXINDEXNUM 20

void INDEX::MergeIndexFiles(INT MemMB)
{

  STRING TmpIndexFileName;
  CHR Tmp[256];
  INT i,j,k,CurrSmallest;
  STRING Current;
  GDT_BOOLEAN val;
  FILEMAP map(Parent);

  STRING CheckName;
  Parent->ComposeDbFn(&CheckName, ".num");
  FILE *fa=Parent->ffopen(CheckName,"r");
  fgets(Tmp,256,fa);
  IndexNum=atoi(Tmp);

  //  MERGEUNIT A[IndexNum];
  //  MERGEUNIT A[MAXINDEXNUM];
  MERGEUNIT *A;
  A = new MERGEUNIT[sizeof(MERGEUNIT)*IndexNum];

  Parent->ffclose(fa); 
#ifdef VERBOSE
  cout <<IndexNum<<" Sub-Indexes to Merge"<<endl;
#endif
//  Parent->IndexingStatus(IndexingStatusMerging, 0, 0);
  FILE *fj=fopen(IndexFileName,"w");
  
  INT MCount;
  
  MemMB/=IndexNum;
  MemMB/=(sizeof(GPTYPE)+sizeof(INT)+StringCompLength+sizeof(CHR)); //size of a sistring record
#ifdef VERBOSE
  cout << MemMB<<" Optimizer Entries"<<endl;
#endif
  
  for(i=1; i<=IndexNum; i++){
    sprintf(Tmp,".%d",i);
    TmpIndexFileName=IndexFileName;
    TmpIndexFileName.Cat(Tmp);
    A[i-1].SetLoadLimit(MemMB);
    A[i-1].Initialize(TmpIndexFileName,Parent,&map,i-1);
//    A[i-1].Initialize(TmpIndexFileName,Parent,&map);
  }
  
  INT ActiveCount=0,ActiveItem;

  for(;;){
    ActiveCount=0;
    for(j=0; j<IndexNum; j++){	// count active items
      if(A[j].Empty()==GDT_FALSE){
	++ActiveCount;
	ActiveItem=j;
      }
    }
    if(ActiveCount==1){	// if only 1 is left, we are done.  Flush it.
      A[ActiveItem].Flush(fj);
      break;			// go do cleanup and close files
    }
    
    // find first active item of remaining several
    for(k=0; k<IndexNum; k++)
      if(A[k].Empty()==GDT_FALSE)
	break;
    // k is number of first active item
    A[k].GetSistring(&Current);
    CurrSmallest=k;
    for(++k;k<IndexNum; k++){	// loop through other active items
      if(A[k].Empty()==GDT_FALSE){
	val=A[k].Smallest(&Current); // if true, current was smaller
	if(val==GDT_FALSE)
	  CurrSmallest=k;
      }
      
    }
    // at this point, CurrSmallest is the one to write and reload
    
    A[CurrSmallest].Write(fj);
    
  }				// loop
  // clean up old files
  for(i=1; i<=IndexNum; i++){
    sprintf(Tmp,".%d",i);
    TmpIndexFileName=IndexFileName;
    TmpIndexFileName.Cat(Tmp);
    CHR *p=TmpIndexFileName.NewCString();
#ifdef VERBOSE
    cout << "Deleting " << p<<endl;
#endif
    unlink(p);
    delete p;
  }
  fclose(fj);
  
  StrUnlink(CheckName);
  delete [] A;
}				// end function


void INDEX::FlushIndexFiles(PCHR MemoryData, INT MemoryDataLength,
			    PGPTYPE NewMemoryIndex, INT MemoryIndexLength,
			    GPTYPE GlobalStart) 
{
  // Open index file
  // in this new implementation, we will never do an in-line merge
  
  STRING TmpIndexFileName=IndexFileName;
  CHR Tmp[256];
  IndexNum++;
  sprintf(Tmp,".%d",IndexNum);
  TmpIndexFileName.Cat(Tmp); // get the section file name
  
  //  PFILE fp = Parent->ffopen(TmpIndexFileName, "rb");
  PFILE fp;
  
  INT i;
  fp = Parent->ffopen(TmpIndexFileName, "wb");
  if (!fp) {
    perror(TmpIndexFileName);
    exit(1);
  }
  // Dump out index
#ifdef VERBOSE
  cout << "Adding GlobalStart "<<GlobalStart<<endl;
#endif
  for(i=0; i<MemoryIndexLength; i++){
    //  cout << NewMemoryIndex[i]<<" + "<<GlobalStart<<" = ";
    NewMemoryIndex[i]+=GlobalStart;
    //  cout << NewMemoryIndex[i]<<endl;
  }
  Parent->GpFwrite(NewMemoryIndex, 1, MemoryIndexLength*sizeof(GPTYPE), fp);
  Parent->ffclose(fp);
  
}

PFILE INDEX::GetFilePointer(const GPTYPE gp) const {
  INT x = Parent->GetMainMdt()->LookupByGp(gp);
  if (x) {
    STRING FileName;
    PFILE fp;
    MDTREC Mdtrec;
    Parent->GetMainMdt()->GetEntry(x, &Mdtrec);
    Mdtrec.GetFullFileName(&FileName);
    fp = Parent->ffopen(FileName, "rb");
    if (!fp) {
      perror(FileName);
      exit(1);
    }
    //    fseek(fp, gp - Mdtrec.GetGlobalFileStart(), 0);
    fseek(fp, (long)(gp - Mdtrec.GetGlobalFileStart()), SEEK_SET);
    return fp;
  } else {
    return 0;
  }
}

INT INDEX::IsStopWord(PCHR WordStart, INT WordMaximum) const {
  INT x = 0;
  INT WordLength = 0;
  while ( (WordLength < WordMaximum) &&
	 (isalnum(WordStart[WordLength])) ) {
    WordLength++;
  }
  CHR SaveCh = WordStart[WordLength];
  WordStart[WordLength] = '\0';
  INT High = StopWordSize;
  INT Low = 0;
  INT Middle = 0;
  INT Old;
  do {
    Old = Middle;
    Middle = (Low + High) / 2;
    //    x = strcasecmp(WordStart, stoplist[Middle]);
    x = StrCaseCmp(WordStart, stoplist[Middle]);
    if (x == 0) {
      //not good to leave nuls embedded!
      WordStart[WordLength] = SaveCh; 
      return 1;
    }
    if (x < 0) {
      High = Middle;
    }
    if (x > 0) {
      Low = Middle;
    }
  } while (Middle != Old);
  WordStart[WordLength] = SaveCh;
  return 0;
}

GPTYPE INDEX::BuildGpList(
			  //@ManMemo: The associated doctype (for calling ParseWords())
			  const STRING& Doctype,
			  //@ManMemo: Index offset into the text buffer where the document starts.
			  INT StartingPosition,
			  //@ManMemo: Pointer to beginning of big text buffer.
			  PCHR MemoryData,
			  //@ManMemo: Length of big text buffer.
			  INT MemoryDataLength,
			  //@ManMemo Pointer to beginning of remaining GP index list buffer.
			  PGPTYPE MemoryIndex,
			  //@ManMemo: Length of GP index list buffer remaining.
			  INT MemoryIndexLength
			  ) 
{
  return ( Parent->ParseWords(Doctype, MemoryData + StartingPosition,
			      MemoryDataLength - StartingPosition,
			      StartingPosition, MemoryIndex,
			      MemoryIndexLength) );	// Convert parameters to what ParseWords() wants
}

GDT_BOOLEAN INDEX::DiskValidateInField(const GPTYPE HitGp, 
				       FILE *Fp, INT Total)
{
  
  INT Low = 0;
  INT High = Total - 1;
  INT X = High / 2;
  INT OX;
  GPTYPE GpS, GpE;
  do {
    OX = X;
    //    fseek(Fp, X * sizeof(GPTYPE) * 2, 0);
    fseek(Fp, (long)(X * sizeof(GPTYPE) * 2), SEEK_SET);
    Parent->GpFread(&GpS, 1, sizeof(GPTYPE), Fp);
    Parent->GpFread(&GpE, 1, sizeof(GPTYPE), Fp);
    if ( (HitGp >= GpS) && (HitGp <= GpE) ) {
      return GDT_TRUE;
    }
    
    if (HitGp < GpS) {
      High = X;
    } else {
      Low = X + 1;
    }
    
    X = (Low + High) / 2;
    if (X < 0) {
      X = 0;
    } else {
      if (X >= Total) {
	X = Total - 1;
      }
    }
  } while (X != OX);
  
  return GDT_FALSE;
}


// JMF

GDT_BOOLEAN INDEX::ValidateInField(const GPTYPE HitGp, FILE *Fp, 
				   INT Total, INT Disk, 
				   GPTYPE *Cache, INT CacheSize, 
				   INT CacheBase) 
{
  
  // Hit Gp's increase.  So, when are over 5% out of the cache  
  // in the upper direction, load a new cache
  
  INT Low = 0;
  INT High = Total - 1;
  INT X = High / 2;
  INT OX;
  GPTYPE GpS, GpE;
  INT Current=0,Pass=0;
  
  do {
    OX = X;
    
    if(Disk || X>=(CacheBase+CacheSize) || X<CacheBase ){
      
      //      fseek(Fp, X * sizeof(GPTYPE) * 2, 0);
      fseek(Fp, (long)(X * sizeof(GPTYPE) * 2), SEEK_SET);
      Parent->GpFread(&GpS, 1, sizeof(GPTYPE), Fp);
      Parent->GpFread(&GpE, 1, sizeof(GPTYPE), Fp);
      Current=0;
      
    } else {
      INT y=X*2;
      GpS=Cache[y-CacheBase];
      GpE=Cache[y+1-CacheBase];
      Current=1;
    }
    
    if ( (HitGp >= GpS) && (HitGp <= GpE) ) {
      if(Current==0) {
	++OutCache;
	if(Accesses>10) {
#ifdef DEBUG
	  printf("Slide Cache at X = %d\n",X);
#endif
	  CacheBase=X;
	  //	  fseek(Fp, X * sizeof(GPTYPE) * 2, 0);
	  fseek(Fp, (long)(X * sizeof(GPTYPE) * 2), SEEK_SET);
	  Parent->GpFread(Cache,sizeof(GPTYPE)*2,CacheSize,Fp);
	  Accesses=0;
	} else
	  ++Accesses;
      } else
	++InCache;
      return GDT_TRUE;
    }
    
    if (HitGp < GpS) {
      High = X;
      
    } else {
      Low = X + 1;
    }
    
    X = (Low + High) / 2;
    
    if (X < 0) {
      X = 0;
    } else {
      if (X >= Total) {
	X = Total - 1;
      }
    }
  } while (X != OX);
  return GDT_FALSE;
}

PIRSET INDEX::RsetOr(const OPOBJ& Set1, const OPOBJ& Set2) const 
{
  return 0;
}

PIRSET INDEX::Search(const SQUERY& SearchQuery) 
{
  // Flip OPSTACK upside-down to convert so we can
  // pop from it in RPN order.
  OPSTACK Stack;
  SearchQuery.GetOpstack(&Stack);
  Stack.Reverse();
  // Pop OPOBJ's, converting OPERAND's to result sets, and
  // executing OPERATOR's
  OPSTACK TempStack;
  POPOBJ OpPtr;
  PIRSET NewIrset;
  INT Relation,Structure;
  ATTRLIST Attrlist;
  STRING Term, FieldName, S, FieldType, spTerm;
  INT TermWeight;
  POPOBJ Op1, Op2;
  while (Stack >> OpPtr) {
    if (OpPtr->GetOpType() == TypeOperator) {
      TempStack >> Op1;
      TempStack >> Op2;
      if (OpPtr->GetOperatorType() == OperatorOr) {
	Op1->Or(*Op2);
	Stack << Op1;
      }
      if (OpPtr->GetOperatorType() == OperatorAnd) {
	Op1->And(*Op2);
	Stack << Op1;
      }
      if (OpPtr->GetOperatorType() == OperatorAndNot) {
#ifdef MULTI
        // Ugly Hack:
        // If we're using the MULTI version of AndNot, we need to
        // swap the order of the objects, so use the stack for a second
        TempStack << Op1;
        TempStack << Op2;// Op1 = Op2 might work here, too
        TempStack >> Op1;
        TempStack >> Op2;
#endif
	Op1->AndNot(*Op2);
	Stack << Op1;
      }
      // delete Op1;
      delete Op2;
    }
    if (OpPtr->GetOpType() == TypeOperand) {
      if (OpPtr->GetOperandType() == TypeRset) {
	TempStack << OpPtr;
      }
      if (OpPtr->GetOperandType() == TypeTerm) {
	OpPtr->GetTerm(&Term);
	spTerm = Term;
	spTerm.UpperCase();
	OpPtr->GetAttributes(&Attrlist);
	if (Attrlist.AttrGetRightTruncation()) {
	  Term += "*";
	}
	if (Attrlist.AttrGetFieldName(&S)) {
	  FieldName = S;
	} else {
	  FieldName = "";
	}
	if (FieldName.GetLength() > 0) {
	  Parent->FieldTypes.GetValue(FieldName,&FieldType);
	  if(FieldType.GetLength() == 0) {
	    FieldType = "text";
	  }
	}
	
	// process for bounding rectangle
	STRINGINDEX x;
	INT i,tmp;
	CHR TBuf[256];
	DOUBLE N,So,E,W;
	DOUBLE fKey;

	if(FieldType.CaseEquals("gpoly")) {
	  Term.GetCString(TBuf,256);
	  tmp=strlen(TBuf);
	  for(i=0; i<tmp; i++) {
	    if(TBuf[i]==',')
	      TBuf[i]=' ';
	  }
	  sscanf(TBuf,"%lf %lf %lf %lf",&N,&So,&E,&W);
	  NewIrset=BoundingRectangle(N,So,W,E);
	  
	} else if(FieldType.CaseEquals("date")) {
	  if(Attrlist.AttrGetRelation(&Relation)==GDT_FALSE)
	    Relation=3;
	  if(Attrlist.AttrGetStructure(&Structure)==GDT_FALSE)
	    Structure=5;
	  NewIrset=DateSearch(Term,FieldName,Relation,Structure);
	  
        } else if(FieldType.CaseEquals("num")) {
          if(Attrlist.AttrGetRelation(&Relation)==GDT_FALSE)
            Relation=3;
          Term.GetCString(TBuf,256);
          fKey=atof(TBuf);
          NewIrset=NumericSearch(fKey,FieldName,Relation);
          
	} else if(FieldType.CaseEquals("date-range")) {
	  if(Attrlist.AttrGetRelation(&Relation)==GDT_FALSE)
	    Relation=3;
	  if(Attrlist.AttrGetStructure(&Structure)==GDT_FALSE)
	    Structure=5;
	  NewIrset=DateSearch(Term,FieldName,Relation,Structure);
	  
	  //	} else if((x=Term.Search("RECT{"))>0 || FieldName=="BOUNDING"){
	} else if((x=spTerm.Search("RECT{"))>0 || FieldName=="BOUNDING"){
	  if(FieldName!="BOUNDING"){
	    x+=5;
	    Term.EraseBefore(x);
	    x=Term.Search('}');
	    if(x)
	      Term.EraseAfter(x-1);
	  }
	  Term.GetCString(TBuf,256);
	  tmp=strlen(TBuf);
	  for(i=0; i<tmp; i++) {
	    if (TBuf[i]==',')
	      TBuf[i]=' ';
	  }
	  sscanf(TBuf,"%lf %lf %lf %lf",&N,&So,&W,&E);
	  NewIrset=BoundingRectangle(N,So,W,E);
	} else {
	  if(Attrlist.GetValue(Bib1AttributeSet,2,&Relation)==GDT_FALSE)
	    Relation=3;
	  NewIrset = TermSearch(Term, FieldName,Relation);
	}
	
	if (Attrlist.AttrGetTermWeight(&S)) {
	  TermWeight = S.GetInt();
	} else {
	  TermWeight = 1;
	}
	NewIrset->ComputeScores(TermWeight);
	TempStack << NewIrset;
	//delete NewIrset;
      }
    }
  }
  TempStack >> NewIrset;
  //  NewIrset->SortByScore();
  
  return NewIrset;
}

PIRSET INDEX::AndSearch(const SQUERY& SearchQuery) {
  // Convert all operators to AND's
  OPSTACK Stack, TempStack, NewStack;
  POPOBJ OpPtr;
  SQUERY NewQuery;
  PIRSET TmpResult;
  SearchQuery.GetOpstack(&Stack);
  while (Stack >> OpPtr) {
    TempStack << *OpPtr;
    delete OpPtr;
  }
  while (TempStack >> OpPtr) {
    if (OpPtr->GetOpType() == TypeOperator) {
      OpPtr->SetOperatorType(OperatorAnd);
    }
    NewStack << *OpPtr;
    delete OpPtr;
  }
  NewQuery.SetOpstack(NewStack);
  TmpResult = Search(NewQuery);
  return(TmpResult);
}

//private
INT INDEX::GetIndirectBuffer(const GPTYPE Gp, PCHR Buffer, 
				     const INT Offset,
				     const INT BufferLen) {
  MDTREC Mdtrec;
  STRING FileName;
  PFILE Fp;
  INT x;
  Parent->GetMainMdt()->GetMdtRecord(Gp, &Mdtrec);
  if (Offset != 0) {
    GPTYPE FileStart = Mdtrec.GetGlobalFileStart();
    GPTYPE LocalGp = Gp - FileStart;
    LocalGp += Offset;
    GPTYPE LocalStart = Mdtrec.GetLocalRecordStart();
    GPTYPE LocalEnd = Mdtrec.GetLocalRecordEnd();
    if (LocalGp <= LocalStart || LocalGp >= LocalEnd)
      return(0);
  }
  Mdtrec.GetFullFileName(&FileName);
  Fp = Parent->ffopen(FileName, "rb");
  if (!Fp) {
    perror(FileName);
    return(0);
  }
  //  fseek(Fp, Gp - Mdtrec.GetGlobalFileStart() + Offset, 0);
  fseek(Fp, (long)(Gp - Mdtrec.GetGlobalFileStart() + Offset), SEEK_SET);
  x = fread(Buffer, 1, BufferLen, Fp);
  Parent->ffclose(Fp);
  Buffer[x] = '\0';
  return(x);
}

GDT_BOOLEAN INDEX::GetIndirectBuffer(const GPTYPE Gp, PCHR Buffer,
				     const INT Offset) {
  INT x;
  x=GetIndirectBuffer(Gp,Buffer,Offset,StringCompLength);
  if (x>0)
    return GDT_TRUE;
  return GDT_FALSE;
}

GDT_BOOLEAN INDEX::GetIndirectBuffer(const GPTYPE Gp, PCHR Buffer) {
  INT x;
  x=GetIndirectBuffer(Gp,Buffer,0,StringCompLength);
  if (x>0)
    return GDT_TRUE;
  return GDT_FALSE;
  /*
     MDTREC Mdtrec;
     STRING FileName;
     PFILE Fp;
     INT x;
     Parent->GetMainMdt()->GetMdtRecord(Gp, &Mdtrec);
     Mdtrec.GetFullFileName(&FileName);
     Fp = Parent->ffopen(FileName, "rb");
     if (!Fp) {
     perror(FileName);
     return GDT_FALSE;
     }
     fseek(Fp, Gp - Mdtrec.GetGlobalFileStart(), 0);
     x = fread(Buffer, 1, len, Fp);
     Parent->ffclose(Fp);
     Buffer[x] = '\0';
     return GDT_TRUE;
     */  
}

PIRSET INDEX::SoundexSearch(const STRING& QueryTerm, const STRING& FieldName) { 
  // to do this efficiently, we need a soundex index
  // binary search
  PFILE fpi = fopen(IndexFileName, "rb");
  if (!fpi) {
    perror(IndexFileName);
    exit(1);
  }
  GPTYPE gp;
  INT ip, oip, maxip, low, high;
  INT x, z;
  CHR Buffer[StringCompLength+1];
  CHR Term[StringCompLength+1];
  INT done = 0;
  //  fseek(fpi, 0, 2);
  fseek(fpi, 0L, SEEK_END);
  maxip = (ftell(fpi) / sizeof(GPTYPE)) - 1;
  high = maxip;
  ip = high / 2;
  low = 0;
  INT hit;
  z = 0;
  STRING s1, s2, sx1, sx2;
  Term[0] = toupper(QueryTerm.GetChr(1));
  Term[1] = '\0';
  do {
    hit = 0;
    oip = ip;
    //    fseek(fpi, ip * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(ip * sizeof(GPTYPE)), SEEK_SET);
    x = fread((char*)&gp, 1, sizeof(GPTYPE), fpi); // explicit cast
    if (x) {
      GetIndirectBuffer(gp, Buffer, 0);
      
      z = StrNCaseCmp(Term, Buffer, 1);
      /*
	 if (z == 0) {
	 if (isalnum(Buffer[strlen(Term)])) {
	 z = -1;
	 }
	 }
	 */
      
      if (z == 0) {
	done = 1;
	hit = 1;
      }
      if (z < 0) {
	high = ip;
      }
      if (z > 0) {
	low = ip + 1;
      }
      ip = (low + high) / 2;
      if (ip < 0) {
	ip = 0;
      }
      if (ip > maxip) {
	ip = maxip;
      }
    } else {
      ip = 0;
      done = 1;
    }
  } while ( (!done) && (ip != oip) );
  
  // find beginning
  INT first = ip;
  INT match = 1;
  while ( (first > 0) && (match) ) {
    first--;
    //    fseek(fpi, first * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(first * sizeof(GPTYPE)), SEEK_SET);
    x = fread((char*)&gp, 1, sizeof(GPTYPE), fpi); // explicit cast
    if (x) {
      GetIndirectBuffer(gp, Buffer, 0);
      if (toupper(Buffer[0]) != Term[0]) {
	match = 0;
      }
    } else {
      match = 0;
    }
  }
  
  IRESULT iresult;
  PIRSET pirset = new IRSET(Parent);
  INT w, OK;
  
  do {
    x = fread((char*)&gp, 1, sizeof(GPTYPE), fpi); // explicit cast
    if (x) {
      GetIndirectBuffer(gp, Buffer, 0);
      OK = 0;
      if (FieldName.Equals("")) {
	OK = 1;
      } else {
	/*if (ValidateInField(gp, FieldName)) {
	  OK = 1;
	  }*/
	OK=1;
      }
      if (OK) {
	s1 = Buffer;
	s2 = QueryTerm;
	SoundexEncode(s1, &sx1);
	SoundexEncode(s2, &sx2);
	if (sx1.Equals(sx2)) {
	  // match!
	  w = Parent->GetMainMdt()->LookupByGp(gp);
	  iresult.SetMdtIndex(w);
	  iresult.SetHitCount(1);
	  iresult.SetScore(0);
	  pirset->AddEntry(iresult, 1);
	}
      }
    }
  } while (toupper(Buffer[0]) == Term[0]);
  fclose(fpi);
  return pirset;
}

INT INDEX::Match(const CHR *QueryTerm, const INT TermLength, 
		 const GPTYPE gp, const INT4 Offset) {
  CHR Buffer[StringCompLength+1];
  INT z;
  
  if (!GetIndirectBuffer(gp, Buffer, Offset))
    return -1;

  /*  
  for (z = 0; Buffer[z]; z++) {
    if (!isalnum(Buffer[z]))
      Buffer[z] = ' ';
  }
  */

  BufferClean(Buffer);
  
  if ( QueryTerm[TermLength - 1] == '*' ) 
    z = StrNCaseCmp(QueryTerm, Buffer, TermLength - 1);
  else {
    z = StrNCaseCmp(QueryTerm, Buffer, TermLength);
    if ( z == 0 && isalnum(Buffer[TermLength]) )
      z = -1;
  }
  
  return z;
}

// DATE Routines

#define YEAR_LOWER         99.0
#define MONTH_LOWER     99999.0
#define DAY_LOWER     9999999.0

#define YEAR_UPPER      10000.0
#define MONTH_UPPER   1000000.0
#define DAY_UPPER   100000000.0

GDT_BOOLEAN INDEX::IsYearDate(const DOUBLE fVal)
{
  if ((fVal > YEAR_LOWER) && (fVal < YEAR_UPPER))
    return(GDT_TRUE);
  return(GDT_FALSE);
}
GDT_BOOLEAN INDEX::IsMonthDate(const DOUBLE fVal)
{
  if ((fVal > MONTH_LOWER) && (fVal < MONTH_UPPER))
    return(GDT_TRUE);
  return(GDT_FALSE);
}
GDT_BOOLEAN INDEX::IsDayDate(const DOUBLE fVal)
{
  if ((fVal > DAY_LOWER) && (fVal < DAY_UPPER))
    return(GDT_TRUE);
  return(GDT_FALSE);
}
GDT_BOOLEAN INDEX::IsYearDate(const STRING& DateString)
{
  STRINGINDEX Len;
  Len = DateString.GetLength();
  
  if ((Len > 1) && (Len < 5))
    return(GDT_TRUE);
  return(GDT_FALSE);
}
GDT_BOOLEAN INDEX::IsMonthDate(const STRING& DateString)
{
  STRINGINDEX Len;
  Len = DateString.GetLength();
  
  if ((Len > 5) && (Len < 7))
    return(GDT_TRUE);
  return(GDT_FALSE);
}
GDT_BOOLEAN INDEX::IsDayDate(const STRING& DateString)
{
  STRINGINDEX Len;
  Len = DateString.GetLength();
  
  if ((Len > 7) && (Len < 9))
    return(GDT_TRUE);
  return(GDT_FALSE);
}

// Search date fields for matches
// Will accept intervals or single dates, and varying precisions
// YYYY, YYYYMM or YYYYMMDD
PIRSET INDEX::DateSearch(const STRING& QueryTerm, const STRING& FieldName, 
			 INT4 Relation, INT4 Structure) 
{
  DOUBLE fVal;
  PIRSET pirset;
  
  // We have a number of cases to check.  First, we need to see if the
  // QueryTerm is a single date or an interval - we do this by looking at
  // Structure.  
  
  if (Structure == ZStructDateRange) {
    // User has specified a date range
    pirset = DateRangeSearch(QueryTerm, FieldName, Relation);
    
  } else if (Structure == ZStructDate) {
    // User has specified a single date
    pirset = SingleDateSearch(QueryTerm, FieldName, Relation);
    
    //  } else if (Structure == ZStructDateTime) {
    
  } else if (Structure == ZStructYear) {
    // User has specified just a year
    pirset = SingleDateSearch(QueryTerm, FieldName, Relation);
    
  } else {
    pirset = SingleDateSearch(QueryTerm, FieldName, Relation);
  }
  
  return(pirset);
}

// DateRangeSearch searches a field of dates for values within the
// range specified by the user's query term.  QueryTerm has the form
// "YYYYMMDD YYYYMMDD"
PIRSET INDEX::DateRangeSearch(const STRING& QueryTerm, 
			      const STRING& FieldName, INT4 Relation)
{
  PIRSET LowerBound=(PIRSET)NULL;
  PIRSET UpperBound=(PIRSET)NULL;
  
  STRING Start, End;
  STRINGINDEX blank;
  
  INT4 Before=ZRelBefore;
  INT4 After=ZRelAfter;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  Start = QueryTerm;
  blank = Start.Search(" ");
  Start.EraseAfter(blank-1);
  
  End = QueryTerm;
  blank = End.Search(" ");
  End.EraseBefore(blank+1);
  
  // Split up the QueryTerm into starting and ending dates
  
  if (Relation == ZRelDuring) {
    // Search for dates after the Start date
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // The target interval has to overlap the user-specified interval
      // so find all Start dates inside the user's interval and OR that
      // with all End dates inside the user's interval
      
      // The target interval has to overlap the user-specified interval
      
      // Search for ending dates after the user's Start date
      LowerBound = SingleDateSearchDuringAfter(Start,FieldName);
      // Search for starting dates before the user's End date
      UpperBound = SingleDateSearchBeforeDuring(End,FieldName);
      
    } else {
      LowerBound = SingleDateSearchDuringAfter(Start,FieldName);
      // Search for dates before the End date
      UpperBound = SingleDateSearchBeforeDuring(End,FieldName);
    }
    
    // AND the results together
    LowerBound->And(*UpperBound);
    delete UpperBound;
    return(LowerBound);
    
  } else if (Relation == ZRelBefore) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // Find any starting dates before the user's Start date
      UpperBound = SingleDateSearchBefore(Start,FieldName);
    } else {
      UpperBound = SingleDateSearchBefore(Start,FieldName);
    }
    return(UpperBound);
    
  } else if (Relation == ZRelBeforeDuring) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // Find any starting dates before the user's End date
      UpperBound = SingleDateSearchBeforeDuring(End,FieldName);
    } else {
      UpperBound = SingleDateSearchBeforeDuring(End,FieldName);
    }
    return(UpperBound);
    
  } else if (Relation == ZRelAfter) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // Find any ending date after the user's End date
      LowerBound = SingleDateSearchAfter(End,FieldName);
    } else {
      LowerBound = SingleDateSearchAfter(End,FieldName);
    }
    return(LowerBound);
    
  } else if (Relation == ZRelDuringAfter) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // Find any ending date after the user's Start date
      LowerBound = SingleDateSearchDuringAfter(Start,FieldName);
    } else {
      LowerBound = SingleDateSearchDuringAfter(Start,FieldName);
    }
    return(LowerBound);
  } 
  else
    return(LowerBound);
}

// SingleDateSearch searches a field of single dates for values matching
// the date specified by the query term.  Variable precision strings are
// handled - "YYYY", "YYYYMM" or "YYYYMMDD"
PIRSET INDEX::SingleDateSearch(const STRING& QueryTerm, 
			       const STRING& FieldName, INT4 Relation)
{
  PIRSET pirset=(PIRSET)NULL;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  // Translate the relation into a numeric one
  if (Relation == ZRelBefore) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      pirset = SingleDateSearchBefore(QueryTerm,FieldName);
    }	else {
      pirset = SingleDateSearchBefore(QueryTerm,FieldName);
    }
    
  } else if (Relation == ZRelAfter) {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      pirset = SingleDateSearchAfter(QueryTerm,FieldName);
    } else {
      pirset = SingleDateSearchAfter(QueryTerm,FieldName);
    }
    
  } else {
    if (FieldType.CaseEquals("DATE-RANGE")) {
      // For date intervals, we want to hit on any interval which
      // might contain the user-specified date
      pirset = SingleDateSearchInside(QueryTerm,FieldName);
    } else {
      pirset = SingleDateSearchEquals(QueryTerm,FieldName);
    }
    
  }
  
  return(pirset);
}

PIRSET INDEX::SingleDateSearchEquals(const STRING& QueryTerm, 
				     const STRING& FieldName)
{
  DOUBLE fVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  ThisRelation = ZRelEQ;
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  // It's at least a valid format.  Do a search on it.
  if ((FieldType.CaseEquals("DATE-RANGE")) 
      || (FieldType.CaseEquals("INTERVAL"))) {
    
    pirset = NumericSearch(fVal, FieldName, ThisRelation, GDT_TRUE);
  } else {
    pirset = NumericSearch(fVal, FieldName, ThisRelation);
  }
  
  if (IsDayDate(fVal)) {
    // If it was a full YYYYMMDD date (i.e., > YYYYMM), we're done
    return(pirset);
    
  } else if (IsMonthDate(fVal)) {
    // It's a YYYYMM date, so we need to do a range search on
    // YYYYMMDD and combine the result sets
    
    PIRSET YYYYMMDD;
    STRING Start, End;
    INT4 NewRelation = ZRelEncloses;
    
    // Tack a starting date onto the month
    Start = QueryTerm;
    Start.Cat("01");
    
    // Tack an ending date onto the month (31 is good enough)
    End = QueryTerm;
    End.Cat("31");
    
    // Glue them both together to create a range
    Start.Cat(" ");
    Start.Cat(End);
    
    // Do the search for dates within the range
    YYYYMMDD = DateRangeSearch(Start,FieldName,NewRelation);
    
    // Combine it with the previous result, clean up and return
    pirset->Or(*YYYYMMDD);
    delete YYYYMMDD;
    return(pirset);
    
  } else if (IsYearDate(fVal)) {
    // It's a YYYY date, so we need to do a range search on both
    // YYYYMM and YYYYMMDD and combine the result sets
    
    PIRSET YYYYMMDD;
    PIRSET YYYYMM;
    STRING Start, End, Range;
    INT4 NewRelation = ZRelEncloses;
    
    // Do the month search
    // Tack a starting month onto the year
    Start = QueryTerm;
    Start.Cat("01");
    
    // Tack an ending month onto the year
    End = QueryTerm;
    End.Cat("12");
    
    // Glue them both together to create a range
    Range = Start;
    Range.Cat(" ");
    Range.Cat(End);
    
    // Do the search for dates within the range
    YYYYMM = DateRangeSearch(Range,FieldName,NewRelation);
    
    // Combine it with the previous result, clean up and return
    pirset->Or(*YYYYMM);
    delete YYYYMM;
    
    // Do the full date search
    // Tack a starting date onto the month
    Start.Cat("01");
    
    // Tack an ending date onto the month (31 is good enough)
    End.Cat("31");
    
    // Glue them both together to create a range
    Range = Start;
    Range.Cat(" ");
    Range.Cat(End);
    
    // Do the search for dates within the range
    YYYYMMDD = DateRangeSearch(Range,FieldName,NewRelation);
    
    // Combine it with the previous result, clean up and return
    pirset->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    return(pirset);
    
  } else {
    // It must be a 2-digit year
    
  }
  
  return(pirset);
}

// This is for searching interval data to see if the user-specified
// date is inside
PIRSET INDEX::SingleDateSearchInside(const STRING& QueryTerm, 
				     const STRING& FieldName)
{
  DOUBLE fVal,ThisVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  PIRSET UpperBound=(PIRSET)NULL;
  PIRSET LowerBound=(PIRSET)NULL;
  STRING ThisQuery;
  PIRSET YYYYMMDD=(PIRSET)NULL;
  PIRSET YYYYMM=(PIRSET)NULL;
  PIRSET YYYY=(PIRSET)NULL;
  
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  if (IsDayDate(fVal)) {
    // If it was a full YYYYMMDD date (i.e., > YYYYMM), search on
    // YYYYMM and YYYY formats, too
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      pirset = NumericSearch(fVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Next, look for values <= to the ending dates
      ThisRelation = ZRelGE;
      UpperBound = NumericSearch(DAY_UPPER, FieldName, ThisRelation, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      pirset->And(*UpperBound);
      delete UpperBound;
      
      ThisQuery = QueryTerm;
      ThisQuery.EraseAfter(6);
      ThisVal = ThisQuery.GetFloat();
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Next, look for values <= to the ending dates
      ThisRelation = ZRelGE;
      UpperBound = NumericSearch(MONTH_UPPER, FieldName, ThisRelation, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      YYYYMM->And(*UpperBound);
      delete UpperBound;
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYYMM);
      delete YYYYMM;
      
      ThisQuery.EraseAfter(4);
      ThisVal = ThisQuery.GetFloat();
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYY);
      delete YYYY;
      
      // We're done with the search
      return(pirset);
      
    } else {
      // This won't get called (because we're only calling this method for
      // searching intervals), but it's here just for a sanity escape
      return(pirset);
    }
    
  } else if (IsMonthDate(fVal)) {
    // It's a YYYYMM date, so we need to do a range search on
    // YYYYMMDD and combine the result sets
    
    STRING Start, End;
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      pirset = NumericSearch(fVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Next, look for values <= to the ending dates
      ThisRelation = ZRelGE;
      UpperBound = NumericSearch(MONTH_UPPER, FieldName, ThisRelation, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      pirset->And(*UpperBound);
      delete UpperBound;
      
      ThisQuery = QueryTerm;
      ThisQuery.EraseAfter(4);
      ThisVal = ThisQuery.GetFloat();
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYY);
      delete YYYY;
      
      // Tack a starting date onto the month
      Start = QueryTerm;
      Start.Cat("01");
      ThisVal = Start.GetFloat();
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Tack an ending date onto the month (31 is good enough)
      End = QueryTerm;
      End.Cat("31");
      ThisVal = End.GetFloat();
      
      // Next, look for values <= to the ending dates
      ThisRelation = ZRelGE;
      UpperBound = NumericSearch(DAY_UPPER, FieldName, ThisRelation, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      YYYYMMDD->And(*UpperBound);
      delete UpperBound;
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYYMMDD);
      delete YYYYMMDD;
      return(pirset);
      
    } else {
      // This won't get called (because we're only calling this method for
      // searching intervals), but it's here just for a sanity escape
      return(pirset);
    }
    
  } else if (IsYearDate(fVal)) {
    // It's a YYYY date, so we need to do a range search on both
    // YYYYMM and YYYYMMDD and combine the result sets
    
    STRING Start, End;
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      pirset = NumericSearch(fVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Do the month search
      // Tack a starting month onto the year
      Start = QueryTerm;
      Start.Cat("01");
      ThisVal = Start.GetFloat();
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Tack an ending month onto the year
      End = QueryTerm;
      End.Cat("12");
      ThisVal = End.GetFloat();
      
      // Next, trim off lower precision values
      UpperBound = NumericSearch(YEAR_UPPER, FieldName, ZRelGE, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      YYYYMM->And(*UpperBound);
      delete UpperBound;
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYYMM);
      delete YYYYMM;
      
      // Do the full date search
      // Tack a starting date onto the month
      Start.Cat("01");
      ThisVal = Start.GetFloat();
      
      // First, look for values >= to the starting dates
      ThisRelation = ZRelEnclosedWithin;
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      
      // Tack an ending date onto the month (31 is good enough)
      End.Cat("31");
      ThisVal = End.GetFloat();
      
      // Next, trim off lower precision values
      UpperBound = NumericSearch(MONTH_UPPER, FieldName, ZRelGE, GDT_TRUE);
      
      // What we want is inside - that is, we need to AND them
      YYYY->And(*UpperBound);
      delete UpperBound;
      
      // Combine it with the previous result, clean up and return
      pirset->Or(*YYYY);
      delete YYYY;
      
      return(pirset);
      
    } else {
      return(pirset);
    }
    
  } else {
    // It must be a 2-digit year
    return(pirset);
  }
  
  return((PIRSET)NULL);
}

PIRSET INDEX::SingleDateSearchBefore(const STRING& QueryTerm, 
				     const STRING& FieldName)
{
  DOUBLE fVal,ThisVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  PIRSET YYYYMMDD=(PIRSET)NULL;
  PIRSET YYYYMM=(PIRSET)NULL;
  PIRSET YYYY=(PIRSET)NULL;
  PIRSET LowerBound=(PIRSET)NULL;
  STRING ThisDate;
  STRINGINDEX Len;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  ThisRelation = ZRelLT;
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  // It's at least a valid format.  Do a search on it.
  ThisDate = QueryTerm;
  ThisVal = ThisDate.GetFloat();
  
  if (IsDayDate(ThisDate)) {
    // Do the full precision string
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE,GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Now, lop off the day part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    YYYYMMDD->Or(*YYYYMM);
    delete YYYYMM;
    
    // Now, lop off the month part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    YYYYMMDD->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMMDD);
    
  } else if (IsMonthDate(ThisDate)) {
    // It's a YYYYMM date, so we need to do single date search on
    // YYYYMM00 and on the lower bound 1000000 (so we just get YYYYMM dates
    // and not YYYY or YYYYMMDD
    // Then combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    
    // Tack a starting date onto the month
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the precision range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYYMM->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    // Now, lop off the month and day parts of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-4);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    YYYYMM->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMM);
    
  } else if (IsYearDate(ThisDate)) {
    // It's a YYYY date, so we need to do single date searches on both
    // YYYY00 and YYYY0000 and combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    
    // Do the month search
    // Tack a starting month onto the year
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMM);
    delete YYYYMM;
    
    // Do the full date search
    // Tack a starting date onto the month
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    return(YYYY);
    
  } else {
    // It must be a 2-digit year
    return(pirset);
  }
  
  return((PIRSET)NULL);
}

PIRSET INDEX::SingleDateSearchBeforeDuring(const STRING& QueryTerm, 
					   const STRING& FieldName)
{
  DOUBLE fVal,ThisVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  PIRSET YYYYMMDD=(PIRSET)NULL;
  PIRSET YYYYMM=(PIRSET)NULL;
  PIRSET YYYY=(PIRSET)NULL;
  PIRSET LowerBound=(PIRSET)NULL;
  STRING ThisDate;
  STRINGINDEX Len;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  ThisRelation = ZRelLE;
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  // It's at least a valid format.  Do a search on it.
  ThisDate = QueryTerm;
  ThisVal = ThisDate.GetFloat();
  
  if (IsDayDate(ThisDate)) {
    // Do the full precision string
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Now, lop off the day part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    YYYYMMDD->Or(*YYYYMM);
    delete YYYYMM;
    
    // Now, lop off the month part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    YYYYMMDD->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMMDD);
    
  } else if (IsMonthDate(ThisDate)) {
    // It's a YYYYMM date, so we need to do single date search on
    // YYYYMM00 and on the lower bound 1000000 (so we just get YYYYMM dates
    // and not YYYY or YYYYMMDD
    // Then combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    
    // Tack a starting date onto the month
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the precision range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYYMM->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    // Now, lop off the month and day parts of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-4);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    YYYYMM->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMM);
    
  } else if (IsYearDate(ThisDate)) {
    // It's a YYYY date, so we need to do single date searches on both
    // YYYY00 and YYYY0000 and combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_TRUE);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      LowerBound = NumericSearch(YEAR_LOWER,FieldName,ZRelGE);
    }
    
    //    YYYY->And(*LowerBound);
    //    delete LowerBound;
    
    // Do the month search
    // Tack a starting month onto the year
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(MONTH_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMM->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMM);
    delete YYYYMM;
    
    // Do the full date search
    // Tack a starting date onto the month
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_TRUE);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE, GDT_TRUE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      LowerBound = NumericSearch(DAY_LOWER,FieldName,ZRelGE);
    }
    
    YYYYMMDD->And(*LowerBound);
    delete LowerBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    return(YYYY);
    
  } else {
    // It must be a 2-digit year
    return(pirset);
  }
  
  return((PIRSET)NULL);
}

PIRSET INDEX::SingleDateSearchAfter(const STRING& QueryTerm, 
				    const STRING& FieldName)
{
  DOUBLE fVal,ThisVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  PIRSET YYYYMMDD=(PIRSET)NULL;
  PIRSET YYYYMM=(PIRSET)NULL;
  PIRSET YYYY=(PIRSET)NULL;
  PIRSET UpperBound=(PIRSET)NULL;
  STRING ThisDate;
  STRINGINDEX Len;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  ThisRelation = ZRelGT;
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  // It's at least a valid format.  Do a search on it.
  ThisDate = QueryTerm;
  ThisVal = ThisDate.GetFloat();
  
  if (IsDayDate(ThisDate)) {
    // Do the full precision string
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Now, lop off the day part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    YYYYMMDD->Or(*YYYYMM);
    delete YYYYMM;
    
    // Now, lop off the month part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    YYYYMMDD->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMMDD);
    
  } else if (IsMonthDate(ThisDate)) {
    // It's a YYYYMM date, so we need to do single date search on
    // YYYYMM99 and on the upper bound 999999 (so we just get YYYYMM dates
    // and not YYYY or YYYYMMDD
    // Then combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    
    // Tack a starting date onto the month
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the precision range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYYMM->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    // Now, lop off the month and day parts of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-4);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    YYYYMM->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMM);
    
  } else if (IsYearDate(ThisDate)) {
    // It's a YYYY date, so we need to do single date searches on both
    // YYYY99 and YYYY9999 and combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    
    // Do the month search
    // Tack a starting month onto the year
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation);
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMM);
    delete YYYYMM;
    
    // Do the full date search
    // Tack a starting date onto the month
    ThisDate.Cat("99");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    return(YYYY);
    
  } else {
    // It must be a 2-digit year
    return(pirset);
  }
  
}

PIRSET INDEX::SingleDateSearchDuringAfter(const STRING& QueryTerm, 
					  const STRING& FieldName)
{
  DOUBLE fVal,ThisVal;
  INT4 ThisRelation;
  
  PIRSET pirset=(PIRSET)NULL;
  PIRSET YYYYMMDD=(PIRSET)NULL;
  PIRSET YYYYMM=(PIRSET)NULL;
  PIRSET YYYY=(PIRSET)NULL;
  PIRSET UpperBound=(PIRSET)NULL;
  STRING ThisDate;
  STRINGINDEX Len;
  STRING FieldType;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  ThisRelation = ZRelGE;
  fVal = QueryTerm.GetFloat();
  
  // If it's a bogus date format, bail out
  if ((fVal > 100000000.0) || (fVal < 0.0))
    return((PIRSET)NULL);
  
  // It's at least a valid format.  Do a search on it.
  ThisDate = QueryTerm;
  ThisVal = ThisDate.GetFloat();
  
  if (IsDayDate(ThisDate)) {
    // Do the full precision string
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Now, lop off the day part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    YYYYMMDD->Or(*YYYYMM);
    delete YYYYMM;
    
    // Now, lop off the month part of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-2);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    YYYYMMDD->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMMDD);
    
  } else if (IsMonthDate(ThisDate)) {
    // It's a YYYYMM date, so we need to do single date search on
    // YYYYMM99 and on the upper bound 999999 (so we just get YYYYMM dates
    // and not YYYY or YYYYMMDD
    // Then combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    
    // Tack a starting date onto the month
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the precision range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYYMM->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    // Now, lop off the month and day parts of the string and repeat
    Len = ThisDate.GetLength();
    ThisDate.EraseAfter(Len-4);
    ThisVal = ThisDate.GetFloat();
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    YYYYMM->Or(*YYYY);
    delete YYYY;
    
    return(YYYYMM);
    
  } else if (IsYearDate(ThisDate)) {
    // It's a YYYY date, so we need to do single date searches on both
    // YYYY99 and YYYY9999 and combine the result sets
    
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation, GDT_FALSE);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYY = NumericSearch(ThisVal, FieldName, ThisRelation);
      // And trim off the lower precision values
      UpperBound = NumericSearch(YEAR_UPPER,FieldName,ZRelLE);
    }
    
    YYYY->And(*UpperBound);
    delete UpperBound;
    
    // Do the month search
    // Tack a starting month onto the year
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMM = NumericSearch(ThisVal,FieldName,ThisRelation);
      UpperBound = NumericSearch(MONTH_UPPER,FieldName,ZRelLE);
    }
    
    YYYYMM->And(*UpperBound);
    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMM);
    delete YYYYMM;
    
    // Do the full date search
    // Tack a starting date onto the month
    ThisDate.Cat("00");
    ThisVal = ThisDate.GetFloat();
    
    // Do the search for dates within the range
    if ((FieldType.CaseEquals("DATE-RANGE")) 
	|| (FieldType.CaseEquals("INTERVAL"))) {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation, GDT_FALSE);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE, GDT_FALSE);
    } else {
      YYYYMMDD = NumericSearch(ThisVal,FieldName,ThisRelation);
      //      UpperBound = NumericSearch(DAY_UPPER,FieldName,ZRelLE);
    }
    
    //    YYYYMMDD->And(*UpperBound);
    //    delete UpperBound;
    
    // Combine it with the previous result, clean up and return
    YYYY->Or(*YYYYMMDD);
    delete YYYYMMDD;
    
    return(YYYY);
    
  } else {
    // It must be a 2-digit year
    return(pirset);
  }
  
  return((PIRSET)NULL);
}

// this function takes a bounding rectangle and performs
// a repetitive interval search to determine if a target
// box overlaps it

/*
   PIRSET INDEX::BoundingRectangle(DOUBLE NorthBC,
   DOUBLE SouthBC,
   DOUBLE WestBC,
   DOUBLE EastBC)
   {
   
   // rationale:  if any of the 4 intervals constructed from
   // this set of points intersects a target interval in
   // the database, our BoundingRectangle overlaps the
   // target rectangle that contains the interval.
   
   // there are certain special cases we need to worry about.
   // One: a target that overlaps the International Date Line
   // I don't know how to deal with that except in the indexer, so
   // I won't worry with it right now.  It's fixable, though.
   // Two:  a query that overlaps the International Data line.
   // For that case, we break the query into two parts (8 intervals)
   // Search separately, and OR the results
   // We have to adjust the boundaries to make sure the "direction" is
   // correct.
   // don't be confused by terminology - the North *longitudinal* boundary
   // is the East/West longitudinal line defined by the coordinate points
   // that is furthest North.
   
   GDT_BOOLEAN DateLineIntersection=GDT_FALSE;
   
   // remember the terminology note!
   
   PIRSET NorthLongitude, SouthLongitude;
   PIRSET EastLatitude, WestLatitude;
   
   // Northernmost longitudinal boundary:
   
   if (WestBC > EastBC)	// we cross the DateLine
   DateLineIntersection=GDT_TRUE;
   else
   DateLineIntersection=GDT_FALSE;
   
   if (DateLineIntersection == GDT_TRUE) {
   PIRSET WestDateLineNorthLongitude
   =Interval(WestBC, 180.0, NorthBC, NorthBC);
   PIRSET EastDateLineNorthLongitude
   =Interval(-180.0, EastBC, NorthBC, NorthBC);
   WestDateLineNorthLongitude->Or(*EastDateLineNorthLongitude);
   NorthLongitude=WestDateLineNorthLongitude;
   delete WestDateLineNorthLongitude;
   delete EastDateLineNorthLongitude;
   
   } else
   NorthLongitude=Interval(WestBC, EastBC, NorthBC, NorthBC);
   
   // we now have a north longitude result set.  
   // Southernmost longitudinal boundary:
   
   if (WestBC > EastBC)	// we cross the DateLine
   DateLineIntersection=GDT_TRUE;
   else
   DateLineIntersection=GDT_FALSE;
   
   if (DateLineIntersection == GDT_TRUE) {
   PIRSET WestDateLineNorthLongitude
   =Interval(WestBC, 180.0, SouthBC, SouthBC);
   PIRSET EastDateLineNorthLongitude
   =Interval(-180.0, EastBC, SouthBC, SouthBC);
   WestDateLineNorthLongitude->Or(*EastDateLineNorthLongitude);
   SouthLongitude=WestDateLineNorthLongitude;
   delete WestDateLineNorthLongitude;
   delete EastDateLineNorthLongitude;
   
   } else
   SouthLongitude=Interval(WestBC, EastBC, SouthBC, SouthBC);
   
   // our north and south longitudinal boundary intersections
   // have been computed.
   //
   // now compute intersections for eastern and western latitudinal 
   // latitudinal boundaries.  I don't deal with the Poles.  Queries
   // can't overlap the Polar regions.  I can fix that...
   
   EastLatitude=Interval(EastBC, EastBC, SouthBC, NorthBC);
   WestLatitude=Interval(WestBC, WestBC, SouthBC, NorthBC);
   
   // OR these buzzards together for a set of hits...
   
   EastLatitude->Or(*WestLatitude);
   delete WestLatitude;
   EastLatitude->Or(*NorthLongitude);
   delete NorthLongitude;
   EastLatitude->Or(*SouthLongitude);
   delete SouthLongitude;
   #ifdef DEBUG
   cout << EastLatitude->GetTotalEntries() << " Hits from Rect" << endl;
   #endif
   return(EastLatitude);	// our combined set of hits...
   }
   */

PIRSET INDEX::BoundingRectangle(DOUBLE NorthBC,
				DOUBLE SouthBC,
				DOUBLE WestBC,
				DOUBLE EastBC)
{
  
  // rationale:  if any of the 4 intervals constructed from
  // this set of points intersects a target interval in
  // the database, our BoundingRectangle overlaps the
  // target rectangle that contains the interval.
  
  // there are certain special cases we need to worry about.
  // One: a target that overlaps the International Date Line
  // I don't know how to deal with that except in the indexer, so
  // I won't worry with it right now.  It's fixable, though.
  // Two:  a query that overlaps the International Data line.
  // For that case, we break the query into two parts (8 intervals)
  // Search separately, and OR the results
  // We have to adjust the boundaries to make sure the "direction" is
  // correct.
  // don't be confused by terminology - the North *longitudinal* boundary
  // is the East/West longitudinal line defined by the coordinate points
  // that is furthest North.
  
  // we must add code to find all that are entirely enclosed by the query.
  
  
  GDT_BOOLEAN DateLineIntersection=GDT_FALSE;
  
  // remember the terminology note!
  
  PIRSET NorthLongitude;
  PIRSET SouthLongitude;
  PIRSET EastLatitude;
  PIRSET WestLatitude;
  STRING FieldName;
  
  
  // first, build a result set of all the totally enclosed
  // items in the database.
  // all < NorthQuery
  //  AND
  // all> SouthQuery
  //  AND
  // all < EastQuery
  //  AND
  // all > WestQuery
  
  PIRSET LessThanNorth;
  PIRSET MoreThanSouth;
  PIRSET LessThanEast;
  PIRSET MoreThanWest;
  
  FieldName="NORTHBC";
  LessThanNorth=NumericSearch(NorthBC,FieldName,1);
  
  FieldName="EASTBC";
  LessThanEast=NumericSearch(EastBC,FieldName,1);
  
  LessThanNorth->And(*LessThanEast);
  delete LessThanEast;
  
  FieldName="SOUTHBC";
  MoreThanSouth=NumericSearch(SouthBC,FieldName,4);
  
  FieldName="WESTBC";
  MoreThanWest=NumericSearch(WestBC,FieldName,4);
  
  MoreThanSouth->And(*MoreThanWest);
  delete MoreThanWest;
  
  LessThanNorth->And(*MoreThanSouth);
  delete MoreThanSouth;
  
  
  // Northernmost longitudinal boundary:
  
  if (WestBC > EastBC)	// we cross the DateLine
    DateLineIntersection=GDT_TRUE;
  else
    DateLineIntersection=GDT_FALSE;
  
  PIRSET WestDateLineNL;
  PIRSET EastDateLineNL;
  if (DateLineIntersection == GDT_TRUE) {
    WestDateLineNL
      =Interval(WestBC, 180.0, NorthBC, NorthBC);
    EastDateLineNL
      =Interval(-180.0, EastBC, NorthBC, NorthBC);
    WestDateLineNL->Or(*EastDateLineNL);
    NorthLongitude=WestDateLineNL;
    //    delete WestDateLineNL;
    delete EastDateLineNL;
    
  } else
    NorthLongitude=Interval(WestBC, EastBC, NorthBC, NorthBC);
  
  // we now have a north longitude result set.  
  // Southernmost longitudinal boundary:
  
  if (WestBC > EastBC)	// we cross the DateLine
    DateLineIntersection=GDT_TRUE;
  else
    DateLineIntersection=GDT_FALSE;
  
  PIRSET WestDateLineSL;
  PIRSET EastDateLineSL;
  if (DateLineIntersection == GDT_TRUE) {
    WestDateLineSL
      =Interval(WestBC, 180.0, SouthBC, SouthBC);
    EastDateLineSL
      =Interval(-180.0, EastBC, SouthBC, SouthBC);
    WestDateLineSL->Or(*EastDateLineSL);
    SouthLongitude=WestDateLineSL;
    //    delete WestDateLineSL;
    delete EastDateLineSL;
    
  } else
    SouthLongitude=Interval(WestBC, EastBC, SouthBC, SouthBC);
  
  // our north and south longitudinal boundary intersections
  // have been computed.
  //
  // now compute intersections for eastern and western latitudinal 
  // latitudinal boundaries.  I don't deal with the Poles.  Queries
  // can't overlap the Polar regions.  I can fix that...
  
  EastLatitude=Interval(EastBC, EastBC, SouthBC, NorthBC);
  WestLatitude=Interval(WestBC, WestBC, SouthBC, NorthBC);
  
  // OR these buzzards together for a set of hits...
  
  EastLatitude->Or(*WestLatitude);
  delete WestLatitude;
  EastLatitude->Or(*NorthLongitude);
  delete NorthLongitude;
  EastLatitude->Or(*SouthLongitude);
  delete SouthLongitude;
#ifdef DEBUG
  cout << EastLatitude->GetTotalEntries() << " Hits from Rect" << endl;
#endif
  EastLatitude->Or(*LessThanNorth);
  delete LessThanNorth;
  
  return(EastLatitude);	// our combined set of hits...
}


// this functions takes a pair of points forming an interval
// and match them to intervals in the database.
// option - pass the field names with the values.
// We assume that the West Longitude is <= East Longitude
// and South Latitude <=North Latitude

PIRSET INDEX::Interval(DOUBLE WestLongitude, DOUBLE EastLongitude,
		       DOUBLE SouthLatitude, DOUBLE NorthLatitude)
{
  // goal - find intervals in the database that intersect this interval.
  
  
  CHR TempBuffer[256];
  PIRSET ResultA;
  PIRSET ResultB;
  PIRSET ResultC;
  PIRSET ResultD;
  STRING Query,FieldName;
  
  // Put a cacheing structure here to avoid search duplication
  FieldName="WESTBC";
  ResultA=NumericSearch(EastLongitude,FieldName,2); //LTE
  
#ifdef DEBUG
  cout << "Got " << ResultA->GetTotalEntries() << " entries <= "
    << EastLongitude << " in " << FieldName << endl;
#endif
  
  if (ResultA->GetTotalEntries() == 0) {
    // no hits rules out entire search
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultA);
  }  
  
  FieldName="EASTBC";
  ResultB=NumericSearch(WestLongitude,FieldName,4); //GTE
  
#ifdef DEBUG
  cout << "Got " << ResultB->GetTotalEntries() << " entries >= "
    << WestLongitude << " in " << FieldName << endl;
#endif
  
  if (ResultB->GetTotalEntries() == 0) {
    // no hits rules out entire search
    delete ResultA;
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultB);
  }
  
  // two valid result sets.  AND them
  
  ResultA->And(*ResultB);
  delete ResultB;
  if (ResultA->GetTotalEntries() == 0) {
    // no hits rules out entire search
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultA);
  }
#ifdef DEBUG
  cout << "Now have " << ResultA->GetTotalEntries() << " entries in range."
    << endl;
#endif
  
  // ResultA Now contains a valid interval set
  
  FieldName="NORTHBC";
  ResultC=NumericSearch(SouthLatitude,FieldName,4); //GTE
  
#ifdef DEBUG
  cout << "Got " << ResultC->GetTotalEntries() << " entries >= "
    << SouthLatitude << " in " << FieldName << endl;
#endif
  
  if (ResultC->GetTotalEntries() == 0) {
    // no hits rules out entire search
    delete ResultA;
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultC);
  }
  
  FieldName="SOUTHBC";
  
  ResultD=NumericSearch(NorthLatitude,FieldName,2); //LTE
  
#ifdef DEBUG
  cout << "Got " << ResultD->GetTotalEntries() << " entries <= "
    << NorthLatitude << " in " << FieldName << endl;
#endif
  
  if (ResultD->GetTotalEntries() == 0) {
    // no hits rules out entire search
    delete ResultA;
    delete ResultC;
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultD);
  }
  ResultC->And(*ResultD);
#ifdef DEBUG
  cout << "Now have " << ResultC->GetTotalEntries() << " entries in range."
    << endl;
#endif
  delete ResultD;
  
  if (ResultC->GetTotalEntries() == 0) {
    // no hits rules out entire search
#ifdef DEBUG
    cout << "No hits in last search, so bailing out" << endl;
#endif
    return(ResultC);
  }
  
  // ResultA and ResultC contain our Lat/Long intrsections.  AND them
  ResultA->And(*ResultC);
  delete ResultC;
#ifdef DEBUG
  cout << "Now have " << ResultA->GetTotalEntries() << " entries in range"
    << ", heading back" << endl;
#endif
  return(ResultA);		// full 'o hits (maybe)
  
}


// relations: 3 equals, 1 less than, 2 less than/equals, 5 greater than
// 4 greater than or equals,  6 not equals

PIRSET INDEX::TermSearch(DOUBLE QueryTerm, const STRING& FieldName)
{
  return(NumericSearch(QueryTerm,FieldName,3));
}

PIRSET INDEX::TermSearch(DOUBLE QueryTerm, const STRING& FieldName, INT4 Relation)
{
  return(NumericSearch(QueryTerm,FieldName,Relation));
}

PIRSET INDEX::TermSearch(const STRING& QueryTerm, const STRING& FieldName)
{
  return(TermSearch(QueryTerm, FieldName,3)); // default EQUALS
  
  //  return(BoundingRectangle(50.0,-50.0,-80.0,-50.0));
  
}

PIRSET INDEX::NumericSearch(const DOUBLE fKey, const STRING& FieldName, 
			    INT4 Relation) 
{	
  STRING FieldType,T1;
  CHR TempBuffer[256];
  PIRSET pirset;
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  if (FieldType.GetLength() == 0)
    FieldType = "TEXT";
  if(FieldType == "TEXT")
    return((PIRSET)NULL);
  
  INT4 Start=-1,End=-1,Pointer=0,Value,w;
  IRESULT iresult;
  STRING Fn;
  NUMERICLIST List;
  pirset=new IRSET(Parent);  
  
  STRING DBName="";
  //  Parent->GetDBFileStem(DBName);
  
  sprintf(TempBuffer,"%f",fKey);
  T1 = TempBuffer;
  /*  We'll fix the rset cache when we can feed the server name to it
    w = SetCache->Check(T1,Relation,FieldName,DBName);

  if(w > -1) {
    delete pirset;
    return(SetCache->Fetch(w));
  }
  */
  Parent->DfdtGetFileName(FieldName, &Fn);
  switch(Relation) {
  case 3:			// equals
    End=List.DiskFind(Fn,fKey,5);
    Start=List.DiskFind(Fn,fKey,1);
    break;
  case 1:			// less than
  case 2:			// less than or equal to
    Start=-1;
    End=List.DiskFind(Fn,fKey,Relation);
    break;
  case 4:			// greater than or equal to
  case 5:			// greater than
    End=-1;
    Start=List.DiskFind(Fn,fKey,Relation);
    break;
  }
  
  if( (Relation == 3)
     && (( (End-Start) > 1) || (End == -1) || (Start == -1))) {
    List.SetFileName(Fn);
    List.LoadTable(Start+1,End);
    
    for(Pointer=0; Pointer<List.GetCount(); Pointer++){
      
      Value=List.GetGlobalStart(Pointer);
      w = Parent->GetMainMdt()->LookupByGp(Value);
      iresult.SetMdtIndex(w);
      iresult.SetHitCount(1);
      iresult.SetScore(0);
      pirset->FastAddEntry(iresult, 1);
    }
  } else if (Relation != 3) {
    List.SetFileName(Fn);
    if ((End == -1) && (Start == -1)) {
      // Got no matches, return null
      return(pirset);
      
    } else if (End == -1) {
      //start loading at Start, to end of file
      List.LoadTable(Start,-1);
      for(Pointer=0; Pointer<List.GetCount(); Pointer++){
	Value=List.GetGlobalStart(Pointer);
	w = Parent->GetMainMdt()->LookupByGp(Value);
	
	//	printf("Document is: %d (%f)  %d\n",Value,
	//	       List.GetNumericValue(Pointer),w);
	
	iresult.SetMdtIndex(w);
	iresult.SetHitCount(1);
	iresult.SetScore(0);
	pirset->FastAddEntry(iresult, 1);
      }
      
    } else {
      List.LoadTable(0,End+1);
      // start at 0, go to end
      for(Pointer=0; Pointer<=End; Pointer++){
	Value=List.GetGlobalStart(Pointer);
	w = Parent->GetMainMdt()->LookupByGp(Value);
	//	printf("Other doc: %d (%f) %d\n",Value,
	//	       List.GetNumericValue(Pointer),w);
	iresult.SetMdtIndex(w);
	iresult.SetHitCount(1);
	iresult.SetScore(0);
	pirset->FastAddEntry(iresult, 1);
      }
    }
  }
  pirset->SortByIndex();
  pirset->MergeEntries(1);
  //  SetCache->Add(T1,Relation,FieldName,DBName,pirset);
#ifdef DEBUG
  cout << "NumericSearch - " << pirset->GetTotalEntries()
    << " hits in " << FieldName << " for term=" << fKey
      << ", relation=" << Relation << endl;
#endif
  return(pirset);
}

DOUBLE INDEX::DateTrim(DOUBLE ToTrim, const DOUBLE fKey) {
  STRING Adjusted, AdjustTo;
  STRINGINDEX Dot;
  AdjustTo = fKey;
  Adjusted = ToTrim;
  
  // Check the precision of the input date
  if (IsDayDate(fKey)) {
    //  fKey is YYYYMMDD, adjust ToTrim to the same
    if (IsDayDate(ToTrim)) {
      // Precision matches -- just return
      return(ToTrim);
      
    } else if (IsMonthDate(ToTrim)) {
      // Convert YYYYMM to YYYYMM99
      return ((ToTrim*100)+99);
      
    } else if (IsYearDate(ToTrim)) {
      // Convert YYYY to YYYY9999
      return ((ToTrim*10000)+9999);
      
    } else
      return (Adjusted.GetFloat());
    
  } else if (IsMonthDate(fKey)) {
    //  fKey is YYYYMM, adjust ToTrim to the same
    if (IsDayDate(ToTrim)) {
      Adjusted.EraseAfter(6);
      return (Adjusted.GetFloat());
      
    } else if (IsMonthDate(ToTrim)) {
      // Precision matches -- just return
      return(ToTrim);
      
    } else if (IsYearDate(ToTrim)) {
      // Convert YYYY to YYYY99
      return ((ToTrim*100)+99);
      
    } else
      return (Adjusted.GetFloat());
    
  } else if (IsYearDate(fKey)) {
    //  fKey is YYYY, adjust ToTrim to the same
    if (IsDayDate(ToTrim)) {
      Adjusted.EraseAfter(4);
      return (Adjusted.GetFloat());
      
    } else if (IsMonthDate(ToTrim)) {
      Adjusted.EraseAfter(4);
      return (Adjusted.GetFloat());
      
    } else if (IsYearDate(ToTrim)) {
      // Precision matches -- just return
      return(ToTrim);
      
    } else
      return (Adjusted.GetFloat());
  }
  
  // Something's wrong - don't do anything
  return (ToTrim);
}

PIRSET INDEX::NumericSearch(const DOUBLE fKey, const STRING& FieldName, 
			    INT4 Relation, GDT_BOOLEAN SearchByStart) 
{
  STRING FieldType,T1;
  CHR TempBuffer[256];
  PIRSET pirset=new IRSET(Parent);
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  
  INT4 Start=-1,End=-1,Pointer=0,Value,w;
  IRESULT iresult;
  STRING Fn;
  INTERVALLIST List;
  
  STRING DBName="";
  //  Parent->GetDBFileStem(DBName);
  
  sprintf(TempBuffer,"%f",fKey);
  T1 = TempBuffer;
  /*  We'll fix the rset cache when we can feed the server name to it
  w = SetCache->Check(T1,Relation,FieldName,DBName);

  if(w > -1) {
    delete pirset;
    return(SetCache->Fetch(w));
  }
  */

  Parent->DfdtGetFileName(FieldName, &Fn);
  
  if (FieldType.CaseEquals("DATE-RANGE")) {
    switch(Relation) {
    case ZRelEQ:		// equals
      End=List.DiskDateFind(Fn,fKey,5,SearchByStart);
      Start=List.DiskDateFind(Fn,fKey,1,SearchByStart);
      break;
    case ZRelLT:		// less than
    case ZRelLE:		// less than or equal to
      Start=-1;
      End=List.DiskDateFind(Fn,fKey,Relation,SearchByStart);
      break;
    case ZRelEnclosedWithin:
      Start=-1;
      End=List.DiskDateFind(Fn,fKey,ZRelLE,SearchByStart);
      break;
    case ZRelGE:		// greater than or equal to
    case ZRelGT:		// greater than
      End=-1;
      Start=List.DiskDateFind(Fn,fKey,Relation,SearchByStart);
      break;
    }
  } else {
    switch(Relation) {
    case 3:			// equals
      End=List.DiskFind(Fn,fKey,5,SearchByStart);
      Start=List.DiskFind(Fn,fKey,1,SearchByStart);
      break;
    case 1:			// less than
    case 2:			// less than or equal to
      Start=-1;
      End=List.DiskFind(Fn,fKey,Relation,SearchByStart);
      break;
    case 4:			// greater than or equal to
    case 5:			// greater than
      End=-1;
      Start=List.DiskFind(Fn,fKey,Relation,SearchByStart);
      break;
    }
  }
  
  if( (Relation == 3)
     && (( (End-Start) > 1) || (End == -1) || (Start == -1))) {
    List.SetFileName(Fn);
    if (SearchByStart)
      List.LoadTable(Start+1,End,0);
    else
      List.LoadTable(Start+1,End,1);
    
    for(Pointer=0; Pointer<List.GetCount(); Pointer++){
      
      Value=List.GetGlobalStart(Pointer);
      w = Parent->GetMainMdt()->LookupByGp(Value);
      iresult.SetMdtIndex(w);
      iresult.SetHitCount(1);
      iresult.SetScore(0);
      pirset->FastAddEntry(iresult, 1);
    }
  } else if (Relation != 3) {
    List.SetFileName(Fn);
    if ((End == -1) && (Start == -1)) {
      // Got no matches, return null
      return(pirset);
      
    } else if (Relation == ZRelEnclosedWithin) {
      DOUBLE EndTest;
      
      if (SearchByStart) {
	List.LoadTable(0,End,0);
      } else {
	List.LoadTable(0,End,1);
      }
      
      // start at 0, go to end
      for(Pointer=0; Pointer<=End; Pointer++){
	EndTest = List.GetEndValue(Pointer);
	EndTest = DateTrim(EndTest,fKey);
	if (EndTest >= fKey) {
	  
	  // The interval contains the key, so save the result
	  Value=List.GetGlobalStart(Pointer);
	  w = Parent->GetMainMdt()->LookupByGp(Value);
	  
	  cout << "Start=" << Start;
	  cout << ", End=" << End << endl ;
	  cout << "Document is: " << Value;
	  cout << " [ " << List.GetStartValue(Pointer);
	  cout << ", " << List.GetEndValue(Pointer);
	  cout << "], Entry #" << w << endl;
	  
	  iresult.SetMdtIndex(w);
	  iresult.SetHitCount(1);
	  iresult.SetScore(0);
	  pirset->FastAddEntry(iresult, 1);
	}
      }
      
    } else if (End == -1) {
      //start loading at Start, to end of file
      if (SearchByStart)
	List.LoadTable(Start,-1,0);
      else
	List.LoadTable(Start,-1,1);
      
      //      List.Dump(Start,List.GetCount());
      cout << endl;
      for(Pointer=0; Pointer<List.GetCount(); Pointer++){
	Value=List.GetGlobalStart(Pointer);
	w = Parent->GetMainMdt()->LookupByGp(Value);
	
	cout << "End=-1" << endl ;
	cout << "Document is: " << Value;
	cout << " [ " << List.GetStartValue(Pointer);
	cout << ", " << List.GetEndValue(Pointer);
	cout << "], Entry #" << w << endl;
	
	iresult.SetMdtIndex(w);
	iresult.SetHitCount(1);
	iresult.SetScore(0);
	pirset->FastAddEntry(iresult, 1);
      }
      
    } else {
      if (SearchByStart) {
	List.LoadTable(0,End,0);
	//	List.LoadTable(0,End+1,0);
      } else {
	List.LoadTable(0,End,1);
	//	List.LoadTable(0,End+1,1);
      }
      
      //      List.Dump(0,End+1);
      //      List.Dump(0,End);
      cout << endl;
      // start at 0, go to end
      for(Pointer=0; Pointer<=End; Pointer++){
	Value=List.GetGlobalStart(Pointer);
	w = Parent->GetMainMdt()->LookupByGp(Value);
	
	cout << "Start=" << Start;
	cout << ", End=" << End << endl ;
	cout << "Document is: " << Value;
	cout << " [ " << List.GetStartValue(Pointer);
	cout << ", " << List.GetEndValue(Pointer);
	cout << "], Entry #" << w << endl;
	
	iresult.SetMdtIndex(w);
	iresult.SetHitCount(1);
	iresult.SetScore(0);
	pirset->FastAddEntry(iresult, 1);
      }
    }
  }
  pirset->SortByIndex();
  pirset->MergeEntries(1);
  //  SetCache->Add(T1,Relation,FieldName,DBName,pirset);
#ifdef DEBUG
  cout << "NumericSearch - " << pirset->GetTotalEntries()
    << " hits in " << FieldName << " for term=" << fKey
      << ", relation=" << Relation << endl;
#endif
  return(pirset);
}

int gpcomp(const void* x, const void* y) {
  return(*((GPTYPE *)x)-*((GPTYPE *)y));
}


PIRSET INDEX::TermSearch(const STRING& QueryTerm, const STRING& FieldName, 
			 INT4 Relation) 
{				// binary search
  
  STRING FieldType, CheckName;
  INT w;
  FILE *fx;
  
  Parent->ComposeDbFn(&CheckName, ".num");
  
  fx=Parent->ffopen(CheckName,"r");
  if(fx){
    Parent->ffclose(fx);
    return(MultiTermSearch(QueryTerm, FieldName, Relation));
  }
  
  Parent->FieldTypes.GetValue(FieldName,&FieldType);
  if (FieldType.GetLength() == 0)
    FieldType = "TEXT";
  if(FieldType!="TEXT"){
    DOUBLE fKey;
    CHR TmpBuf[256];
    QueryTerm.GetCString(TmpBuf,256);
    fKey=atof(TmpBuf);
    return(NumericSearch(fKey,FieldName,Relation));
    
  }
  
  PFILE fpi = Parent->ffopen(IndexFileName, "rb");
  if (!fpi) {
    perror(IndexFileName);
    exit(1);
  }
  GPTYPE gp;
  INT ip, oip, maxip, low, high;
  INT x, z, TermLength, OrigTermLength;
  CHR OrigTerm[StringCompLength+1], *Term;
  //  INT x, z;
  //  CHR Buffer[StringCompLength+1];
  //  CHR Term[StringCompLength+1];
  INT done = 0;
  //  fseek(fpi, 0, 2);
  fseek(fpi, 0L, SEEK_END);
  maxip = (ftell(fpi) / sizeof(GPTYPE)) - 1;
  high = maxip;
  ip = high / 2;
  low = 0;
  INT hit;
  z = 0;
  
  QueryTerm.GetCString(OrigTerm, sizeof(OrigTerm));
  OrigTermLength = QueryTerm.GetLength();
  
  //because of sorting unpleasantness, 
  //we must convert non alnums in phrases to spaces
  //for phrase searches we need to look past 
  //all stop words, and start with the first
  //indexed word. later we'll check backwords in the data.
  INT PhraseEnd = OrigTermLength;
  INT n, PhraseBeg = 0, FoundBeg=0;
  if (OrigTerm[OrigTermLength - 1] == '*')
    PhraseEnd--;
  for (n=0; n < PhraseEnd; n++) {
    if (!isalnum(OrigTerm[n])) {
      OrigTerm[n] = ' ';
      if (!FoundBeg && IsStopWord(OrigTerm+PhraseBeg, n - PhraseBeg)) 
	PhraseBeg = n + 1;
      else
	FoundBeg = 1;
    }
  }
  
  if (PhraseBeg >= OrigTermLength) {
    //it's all stop words. return an empty IRSET.
    PIRSET pirset = new IRSET(Parent);
    return pirset;
  }
  Term = OrigTerm + PhraseBeg; 
  TermLength = OrigTermLength - PhraseBeg;
  
  do {
    hit = 0;
    oip = ip;
    //    fseek(fpi, ip * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(ip * sizeof(GPTYPE)), SEEK_SET);
    x = Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi);
    if (x) {
      z = Match(Term, TermLength, gp);
      if (z == 0) {
	done = 1;
	hit = 1;
      }
      else if (z < 0) {
	//	high = ip;
	high = ip-1;
      }
      else if (z > 0) {
	low = ip + 1;
      }
      ip = (low + high) / 2;
      if (ip < 0) {
	ip = 0;
      }
      if (ip > maxip) {
	ip = maxip;
      }
    } else {
      ip = 0;
      done = 1;
    }
    //  } while ( (!done) && (ip != oip) );
  } while ( (!done) && (high >= low) );
  
  
  if (!hit) {
    // no hits - return an empty irset
    PIRSET pirset = new IRSET(Parent);
    return pirset;
  }
  
  // bracket hits
  INT first, last;
  INT match, nomatch;
  
  // find first
  low = 0;
  high = ip;
  first = high / 2;
  match = ip;
  nomatch = 0;
  do {
    //    fseek(fpi, first * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(first * sizeof(GPTYPE)), SEEK_SET);
    x = Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi);
    if (x) 
      z = Match(Term, TermLength, gp);
    if (z == 0) {
      match = first;
      high = first;
    } else {
      nomatch = first;
      low = first + 1;
    }
    first = (low + high) / 2;
    if (first < 0) {
      first = 0;
    } else {
      if (first > ip) {
	first = ip;
      }
    }
  } while ( (match - nomatch) > 5 );
  first = match;
  do {
    if (first > 0) {
      first--;
    }
    //    fseek(fpi, first * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(first * sizeof(GPTYPE)), SEEK_SET);
    x = Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi);
    if (x) 
      z = Match(Term, TermLength, gp);
  } while ( (z == 0) && (first > 0) );
  if ( (z != 0) || (first > 0) ) {
    first++;
  }
  
  
  // find last
  low = ip;
  high = maxip;
  last = (high + low) / 2;
  match = ip;
  nomatch = maxip;
  do {
    //    fseek(fpi, last * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(last * sizeof(GPTYPE)), SEEK_SET);
    x = Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi);
    if (x) 
      z = Match(Term, TermLength, gp);
    if (z == 0) {
      match = last;
      low = last + 1;
    } else {
      nomatch = last;
      high = last;
    }
    last = (low + high) / 2;
    if (last < ip) {
      last = ip;
    } else {
      if (last > maxip) {
	last = maxip;
      }
    }
  } while ( (nomatch - match) > 5 );
  last = match;
  do {
    if (last < maxip) {
      last++;
    }
    //    fseek(fpi, last * sizeof(GPTYPE), 0);
    fseek(fpi, (long)(last * sizeof(GPTYPE)), SEEK_SET);
    x = Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi);
    if (x) 
      z = Match(Term, TermLength, gp);
  } while ( (z == 0) && (last < maxip) );
  if ( (z != 0) || (last < maxip) ) {
    last--;
  }
  
  //	first++;
  //	last--;
  
  // Build result set
  IRESULT iresult;
  
  MDTREC mdtrec;
  GPTYPE GlobalRecEnd;
  PIRSET pirset = new IRSET(Parent);
  PGPTYPE gplist = new GPTYPE[last-first+1];
  //  INT w;
  INT OK;
  PFCT Pfct;
  FC Fc;
  //  fseek(fpi, first * sizeof(GPTYPE), 0);
  fseek(fpi, (long)(first * sizeof(GPTYPE)), SEEK_SET);
  x = Parent->GpFread(gplist, 1, 
		      (last-first+1) * sizeof(GPTYPE), fpi) / sizeof(GPTYPE);
  fclose(fpi);
  
  // sort gplist
  qsort(gplist, (last-first)+1,sizeof(GPTYPE),gpcomp);
  pirset->Resize(pirset->GetTotalEntries() + x); // resize to ahead of time
  INT Offset = TermLength - OrigTermLength;
  
  INT TermLenNoStar;
  
  if (QueryTerm.GetChr(OrigTermLength) == '*') {
    TermLenNoStar = OrigTermLength - 1; // ignore "*" at end
  } else {
    TermLenNoStar = OrigTermLength;
  }
  
  Pfct = new FCT();
  INT CheckField=1;
  INT Total=0;
  INT Disk=0;
  INT CacheSize=0;
  GPTYPE *Cache=(GPTYPE*)NULL;
  FILE *fpf;
  
  if (FieldName.Equals("") || FieldName.GetLength()==0) {
    CheckField=0;
    Total=0;
  } else {
    STRING Fn;
    CheckField=1;
    Parent->DfdtGetFileName(FieldName, &Fn);
    fpf = Parent->ffopen(Fn, "rb");
    InCache=OutCache=Accesses=0;
    
    if (fpf) {
      //      fseek(fpf, 0, 2);
      fseek(fpf, 0L, SEEK_END);
      Total = ftell(fpf) / ( sizeof(GPTYPE) * 2 );
      rewind(fpf);
      CacheSize=CACHELIMIT;
      Cache=new GPTYPE[CacheSize*2];
      Parent->GpFread(Cache,sizeof(GPTYPE),CacheSize*2,fpf);
      Disk=0;
    } else {
      // field file not found - return an empty irset
      cerr << "Field " << FieldName << " not present in this index." 
	<< endl;
      return pirset;
    }
  }
  
  for (ip=0; ip<x; ip++) {
    OK = 0;
    
    // Here's Jim's new code with rcache
    for (ip=0; ip<x; ip++) {
      OK = 0;
      if (TermLength != OrigTermLength) {
	if ( (Match(OrigTerm, OrigTermLength, gplist[ip], Offset)) == 0)  
	  gplist[ip] += Offset;
	else
	  continue;
      }
      
      if(CheckField==1) {
	if (Disk==1) {
	  if (DiskValidateInField(gplist[ip], fpf, Total)) {
	    OK=1;
	  }
	} else if (ValidateInField(gplist[ip], fpf, Total, Disk, 
				   Cache, CacheSize,0)) { 
	  OK = 1;
	}
      } else
	OK = 1;
      if (OK) {
	//      w = Parent->GetMainMdt()->LookupByGp(gplist[ip]);
	//make sure that phrases don't go past 
	//the end of the local record.
	w = Parent->GetMainMdt()->GetMdtRecord(gplist[ip], &mdtrec);
	GlobalRecEnd = mdtrec.GetGlobalFileStart() + 
	  mdtrec.GetLocalRecordEnd();
	if  ( !((GlobalRecEnd - gplist[ip]) >= (TermLenNoStar - 1)) )
	  continue;
	iresult.SetMdtIndex(w);
	iresult.SetHitCount(1);
	iresult.SetScore(0);
	Fc.SetFieldStart(gplist[ip]);
	//      Fc.SetFieldEnd(gplist[ip] + QueryLength - 1);
	Fc.SetFieldEnd(gplist[ip] + TermLength - 1);
	Pfct->Clear();
	Pfct->AddEntry(Fc);
	iresult.SetHitTable(*Pfct);
	pirset->FastAddEntry(iresult, 1);
      }
    }
    if(CheckField==1 && fpf!=NULL){
      //  printf("%d Accesses, %d InCache, %d OutCache (%f Efficiency)\n",
      //   Accesses,InCache,OutCache,(InCache/Accesses)*100);
      fclose(fpf);
    }
  }
  delete Pfct;
  if(CacheSize>0)
    delete Cache;
  delete [] gplist;
  pirset->SortByIndex();
  pirset->MergeEntries(1);
  return pirset;
}

void INDEX::DumpIndex(INT DebugSkip) {
  STRING CheckName,TmpIndexFileName;
  FILE *fx;
  INT kk;
  CHR buf[256];
    PFILE fpd;
    GPTYPE gp;
    MDTREC mdtrec;
    INT x, y, j;
    CHR Buffer[StringCompLength+1], Term[StringCompLength+1];
    STRING FileName;

  Parent->ComposeDbFn(&CheckName, ".num");
  
  fx = Parent->ffopen(CheckName,"r");
  if (fx) {
    fgets(buf,256,fx);
    Parent->ffclose(fx);
    IndexNum=atoi(buf);
  } else
    IndexNum=1;

  for(kk=1; kk<=IndexNum; kk++) {

    cout << endl << "Dumping chunk " << kk << endl << endl;

    TmpIndexFileName=IndexFileName;
    if (IndexNum > 1) {
      sprintf(buf,".%d",kk);
      TmpIndexFileName.Cat(buf);
    }
    PFILE fpi = Parent->ffopen(TmpIndexFileName, "rb");
    if (!fpi) {
      perror(TmpIndexFileName);
      exit(1);
    }
    /*
      PFILE fpi = fopen(IndexFileName, "rb");
      if (!fpi) {
      perror(IndexFileName);
      cout << "(no index)" << endl;
      return;
      }

      PFILE fpd;
      GPTYPE gp;
      MDTREC mdtrec;
      INT x, y, j;
      CHR Buffer[StringCompLength+1], Term[StringCompLength+1];
      STRING FileName;
      */
    Term[0] = '\0';
  
    if (DebugSkip > 0) {
      fseek(fpi, (long)(sizeof(GPTYPE)*DebugSkip), SEEK_SET);
      cout << "Skipping " << DebugSkip << "SIStrings." << endl;
    }
  
    y = 0;
    while (Parent->GpFread(&gp, 1, sizeof(GPTYPE), fpi) > 0) {
      Parent->GetMainMdt()->GetMdtRecord(gp, &mdtrec);
      mdtrec.GetFullFileName(&FileName);
      fpd = fopen(FileName, "rb");
      if (!fpd) {
	perror(FileName);
	exit(1);
      }
      cout << "SIString#" << DebugSkip+y << '\t';
      y++;
      //      fseek(fpd, gp - mdtrec.GetGlobalFileStart(), 0);
      fseek(fpd, (long)(gp - mdtrec.GetGlobalFileStart()), SEEK_SET);
      x = fread(Buffer, 1, StringCompLength, fpd);
      fclose(fpd);
    
      // Wipe the rest of the buffer clean
      for (j=x; j<StringCompLength; j++) {
	Buffer[j] = ' ';
      }
    
      // convert all non-alphas to spaces.  If we add phrase
      // searching, this should be eliminated.
      /*
	for (j=0; j<StringCompLength; j++) {
	if (!isalnum(Buffer[j])) {
	Buffer[j] = ' ';
	}
	}
      */
      BufferClean(Buffer);

      //star if the current entry is out of order.
      if( (StrNCaseCmp(Term, Buffer, StringCompLength)) > 0)
	cout << "(*)";
    
      // store current term for comparison next time
      memcpy(Term, Buffer, StringCompLength);
    
      cout << FileName << ":" << gp << ":";
      cout << gp - mdtrec.GetGlobalFileStart() << endl;
      
      Buffer[x] = '\0';
      cout << "-->" << Buffer << "<--" << endl;
      cout << endl;
    }
    fclose(fpi);
  }
}

void INDEX::CollapseIndexFiles(INT MemMB)
{
  
  STRING TmpIndexFileName,OutFile;
  CHR Tmp[256];
  INT i,j,k,CurrSmallest,LocalIndexNum,First,Second;
  STRING Current;
  
  GDT_BOOLEAN val;
  FILEMAP map(Parent);
  
  STRING CheckName;
  Parent->ComposeDbFn(&CheckName, ".num");
  FILE *fa=Parent->ffopen(CheckName,"r");
  fgets(Tmp,256,fa);
  LocalIndexNum=atoi(Tmp);
  First=LocalIndexNum-2;
  Second=LocalIndexNum-1;
  
  
  MERGEUNIT A[2];
  
  Parent->ffclose(fa); 
  cout <<"Collapsing Final Sub-Indexes"<<endl;
  // Parent->IndexingStatus(IndexingStatusMerging, 0, 0);
  OutFile=IndexFileName;
  OutFile.Cat(".tmp");
  FILE *fj=fopen(OutFile,"w");
  
  INT MCount;
  
  MemMB/=2;
  MemMB/=(sizeof(GPTYPE)+sizeof(INT)+StringCompLength+sizeof(CHR)); //size of a sistring record
  cout << MemMB<<" Optimizer Entries"<<endl;
  for(i=First; i<=Second; i++){
    sprintf(Tmp,".%d",i);
    TmpIndexFileName=IndexFileName;
    TmpIndexFileName.Cat(Tmp);
     A[i-First].SetLoadLimit(MemMB);
    A[i-First].Initialize(TmpIndexFileName,Parent,&map,i-First);
  }
  
  for(;;){
    INT ActiveCount=0,ActiveItem;
    for(j=0; j<2; j++){ // count active items
      if(A[j].Empty()==GDT_FALSE){
        ++ActiveCount;
        ActiveItem=j;
      }
    }
    if(ActiveCount==1){         // if only 1 is left, we are done.  Flush it.
      A[ActiveItem].Flush(fj);
      break;                    // go do cleanup and close files
    }
    
    // find first active item of remaining several
    for(k=0; k<2; k++)
      if(A[k].Empty()==GDT_FALSE)
        break;
    // k is number of first active item
    A[k].GetSistring(&Current);
    CurrSmallest=k;
    for(++k;k<IndexNum; k++){   // loop through other active items
      if(A[k].Empty()==GDT_FALSE){
        val=A[k].Smallest(&Current);    // if true, current was smaller
        if(val==GDT_FALSE)
          CurrSmallest=k;
      }
      
    }
    // at this point, CurrSmallest is the one to write and reload
    
    A[CurrSmallest].Write(fj);
    
  }                             // loop
  // clean up old files
  for(i=First; i<=Second; i++){
    sprintf(Tmp,".%d",i);
    TmpIndexFileName=IndexFileName;
    TmpIndexFileName.Cat(Tmp);
    CHR *p=TmpIndexFileName.NewCString();
#ifdef VERBOSE
    cout << "Deleting " << p<<endl;
#endif
    unlink(p);
    delete p;
  }
  fclose(fj);
  TmpIndexFileName=IndexFileName;
  sprintf(Tmp,".%d",First);
  TmpIndexFileName.Cat(Tmp);
  cout <<"Creating "<<TmpIndexFileName<<endl;
  rename(OutFile,TmpIndexFileName);
  fa=Parent->ffopen(CheckName,"w");
  IndexNum--;
  fprintf(fa,"%d\n",IndexNum);
  fclose(fa);

}               

INDEX::~INDEX() {
  //  delete SetCache;
#ifdef DICTIONARY
  delete Dict;
#endif
}

