/*-@@@
File:		fgdc.hxx
Version:	1.00
Description:	class FGDC - FGDC Document Type
Author:		Archie Warnock, warnock@clark.net
		Adapted from HTML Class
Original:	Edward C. Zimmermann, edz@bsn.com
Copyright:	A/WWW Enterprises, MCNC/CNIDR and USGS/FGDC
@@@-*/

#ifndef FGDC_HXX
#define FGDC_HXX

#ifndef BSN_EXTENSIONS
# define BSN_EXTENSIONS	0 /* 0==> CNIDR's Isearch 1==> BSn's */
#endif

#if BSN_EXTENSIONS < 1
# define BRIEF_MAGIC "B" /* This is what CNIDR uses */
#endif

#define FGDC_ACCEPT_EMPTY_TAGS	0	/* 1 ==> Accept Empty tags per Annex C.1.1.1 SGML Handbook */

#define MAXNESTINGLEN 1024
#define SUTRS_OID "1.2.840.10003.5.101"
#define USMARC_OID "1.2.840.10003.5.10"
#define NEW_HTML_OID "1.2.840.10003.5.108"
#define HTML_OID "1.2.840.10003.5.1000.34.1"
#define SGML_OID "1.2.840.10003.5.1000.34.2"
#define FGDC_SGML_EXTENSION "sgml"
#define FGDC_HTML_EXTENSION "html"
#define FGDC_TEXT_EXTENSION "text"

#define SHORT_FGDC_SGML_EXTENSION "sgm"
#define SHORT_FGDC_HTML_EXTENSION "htm"
#define SHORT_FGDC_TEXT_EXTENSION "txt"


class FGDC:public SGMLNORM
{
public:
  FGDC (PIDBOBJ DbParent);
  void LoadFieldTable();
  void ParseRecords (const RECORD & FileRecord);
  void ParseFields (PRECORD NewRecord);
  GDT_BOOLEAN GetCleanedFieldData(const RESULT& ResultRecord, 
				  const STRING& FieldName,
				  const STRING& FieldType,
				  STRING& Buffer);
  void Present (const RESULT & ResultRecord, const STRING & ElementSet,
		const STRING & RecordSuntax, PSTRING StringBuffer);
//  LONG ParseDateSingle(const PCHR Buffer);
  DOUBLE ParseDateSingle(const PCHR Buffer);
  void ParseDateRange(const PCHR Buffer, DOUBLE* fStart, 
		      DOUBLE* fEnd);
//  void ParseGPoly(const PCHR Buffer);
   ~FGDC ();
/* SGML helper functions */
   PCHR *parse_tags (PCHR b, GPTYPE len) const;
  //   const PCHR find_end_tag (const char *const *t, const char *tag) const;
   const PCHR find_end_tag (char **t, const char *tag) const;
   void store_attributes (PDFT pdft, PCHR base_ptr, PCHR tag_ptr) const;
private:
  GDT_BOOLEAN UsefulSearchField(const STRING& Field);


};
typedef FGDC *PFGDC;

class MD_Element 
{
  public:
  void set_tag(const STRING NewTag) { tag = NewTag; }
  STRING& get_tag() { return tag; }
  void set_start(const INT NewStart) { tag_start = NewStart; }
  INT get_start() { return tag_start; }
  void set_end(const INT NewEnd) { tag_end = NewEnd; }
  INT get_end() { return tag_end; }

  private:
  STRING tag;
  INT tag_start, tag_end;
};
typedef MD_Element *PMD_Element;

#endif
