/* $Id: anzlic.cxx,v 1.1 1997/03/17 16:17:09 cnidr Exp $ */
/************************************************************************
Copyright (c) 1994,1995 Basis Systeme netzwerk, Munich
              Brecherspitzstr. 8
              D-81541 Munich, Germany

              ISRCH-LIC-1B EXPORT: Tue Aug 15 14:20:42 MET DST 1995

              Public Software License Agreement:
              ----------------------------------

Basis Systeme netzwerk(*) (herein after referred to as BSn) hereby
provides COMPANY (herein after referred to as "Licensee") with a
non-exclusive, royalty-free, worldwide license to use, reproduce, modify
and redistribute this software and its documentation (hereafter referred
to as "Materials"), in whole or in part, with Licensee's products under
the following conditions:

1. All copyrights and restrictions in the source files of the Software
Materials will be honored.

2. The above copyright notice and this permission notice appear in all
copies of the software and related documentation. Notices of copyright
and/or attribution which appear at the beginning of any file included in
this distribution must remain intact.

3. The origin of these Materials will be explicitly stated in Licensee's
accompanying documentation as developed by Basis Systeme netzwerk (BSn)
and its collaborators.

4. The name of the author(s) or BSn may not be used to endorse or
promote products derived from these Materials without specific prior
written permission.

5. Versions of the Software Materials or documentation that are altered
or changed will be marked as such.

6. Licensee shall make reasonable efforts to provide BSn with all
enhancements and modifications made by Licensee to the Software
Materials, for a period of three years from the date of execution of
this License. BSn shall have the right to use and/or redistribute the
modifications and enhancements without accounting to Licensee.

Enhancements and Modifications shall be defined as follows:
    i) Changes to the source code, support files or documentation.
   ii) Documentation directly related to Licensee's distribution of the 
       software.
  iii) Licensee software modules that actively solicit services from
       the software and accompanying user documentation.

7. Users of this software agree to make their best efforts to inform BSn
of noteworthy uses of this software.

8. You agree that neither you, nor your customers, intend to, or will,
export these Materials to any country which such export or transmission
is restricted by applicable law without prior written consent of the
appropriate government agency with jurisdiction over such export or
transmission.

8. BSn makes no representation on the suitability of the Software
Materials for any purpose.  The SOFTWARE IS PROVIDED "AS IS" AND WITHOUT
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.

9. Licensee agrees to indemnify, defend and hold harmless BSn from any
loss, claim, damage or liability of any kind, including attorney's fees
and court costs, arising out of or in connection with any use of the
Materials under this License.

10. In no event shall BSn be liable to Licensee or third parties
licensed by licensee for any indirect, special, incidental, or
consequential damages (including lost profits).

11. BSn has no knowledge of any conditions that would impair its right
to license the Materials.  Notwithstanding the foregoing, BSn does not
make any warranties or representations that the Materials are free of
claims by third parties of patent, copyright infringement or the like,
nor does BSn assume any liability in respect of any such infringement of
rights of third parties due to Licensee operation under this license.

12. IN NO EVENT SHALL BSN OR THE AUTHORS BE LIABLE FOR ANY SPECIAL,
INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
OF THIS SOFTWARE.

13. The place of execution of this agreement is Munich and the
applicable laws are those of the Federal Republic of Germany. The
agreement also remains in force even in states/jurisdictions that
exclude one or more clauses. For these cases the applicable clauses are
to be replaced by other agreements that come as close as possible to the
original intent.

"Diese Vereinbarung unterliegt dem Recht der Bundesrepublik Deutschland.
Sie enthaelt saemtliche Vereinbarungen, welche die Parteien hinsichtlich
des Vereinbarungsgegenstandes getroffen haben, und ersetzt alle
vorhergehenden muendlichen oder schriftlichen Abreden. Diese
Vereinbarung bleibt in Zweifel auch bei rechtlicher Unwirksamkeit
enzelner Bestimmungen in seinen uebrigen Teilen verbindlich. Unwirksame
Bestimmungen sind durch Regulungen zu ersetzen, die dem angestrebten
Erfolg moeglichst nahe kommen."

______________________________________________________________________________
(*)Basis Systeme netzwerk, Brecherspitzstr. 8, 81541 Muenchen, Germany 

************************************************************************/
/*-@@@
File:		anzlic.cxx
Version:	$Revision: 1.1 $
Description:	Class ANZLIC - derived from FGDC Document Type
Author:		Archie Warnock, warnock@clark.net
		Adapted from HTML Class
Original:	Edward C. Zimmermann, edz@bsn.com
Copyright:	A/WWW Enterprises, MCNC/CNIDR and USGS/FGDC
@@@-*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>

#include "isearch.hxx"
#include "sgmlnorm.hxx"
#include "fgdc.hxx"
#include "anzlic.hxx"

/* ------- FGDC Support --------------------------------------------- */
ANZLIC::ANZLIC (PIDBOBJ DbParent) : FGDC (DbParent)
{
}

GDT_BOOLEAN ANZLIC::UsefulSearchField(const STRING& Field)
{
  STRING FieldName;
  FieldName=Field;
  FieldName.UpperCase();

  if (FieldName.Search("TITLE"))
    return GDT_TRUE;
  else if (FieldName.Search("PUBDATE"))
    return GDT_TRUE;
  else if (FieldName.Search("DESCRIPT"))
    return GDT_TRUE;
  else if (FieldName.Search("ABSTRACT"))
    return GDT_TRUE;
  else if (FieldName.Search("EDITION"))
    return GDT_TRUE;
  else if (FieldName.Search("PLACEKEY"))
    return GDT_TRUE;
  else if (FieldName.Search("PURPOSE"))
    return GDT_TRUE;
  else if (FieldName.Search("SRCSCALE"))
    return GDT_TRUE;
  else if (FieldName.Search("LINEAGE"))
    return GDT_TRUE;
  else if (FieldName.Search("THEMEKEY"))
    return GDT_TRUE;
  else if (FieldName.Search("THEMEKT"))
    return GDT_TRUE;
  else if (FieldName.Search("BOUNDING"))
    return GDT_TRUE;
  else if (FieldName.Search("WESTBC"))
    return GDT_TRUE;
  else if (FieldName.Search("EASTBC"))
    return GDT_TRUE;
  else if (FieldName.Search("NORTHBC"))
    return GDT_TRUE;
  else if (FieldName.Search("SOUTHBC"))
    return GDT_TRUE;
  else if (FieldName.Search("ORIGIN"))
    return GDT_TRUE;
  else if ((FieldName.Search("BEGDATE")) && !(FieldName.Search("BEGDATEA")))
    return GDT_TRUE;
  else if ((FieldName.Search("ENDDATE")) && !(FieldName.Search("ENDDATEA")))
    return GDT_TRUE;
  else if (FieldName.Search("CALDATE"))
    return GDT_TRUE;
  else if (FieldName.Search("GEOFORM"))
    return GDT_TRUE;
  else if (FieldName.Search("BROWSED"))
    return GDT_TRUE;
  else if (FieldName.Search("BROWSEN"))
    return GDT_TRUE;
  else if (FieldName.Search("DIRECT"))
    return GDT_TRUE;
  else if (FieldName.Search("INDSPREF"))
    return GDT_TRUE;
  else if (FieldName.Search("DSGPOLY"))
    return GDT_TRUE;
  else if (FieldName.Search("DSGPOLYX"))
    return GDT_TRUE;
  else if (FieldName.Search("CNTORGP"))
    return GDT_TRUE;
  else if (FieldName.Search("TIMEINFO"))
    return GDT_TRUE;
  else if (FieldName.Search("TIMEPERD"))
    return GDT_TRUE;
  else if (FieldName.Search("RNGDATES"))
    return GDT_TRUE;
  else if (FieldName.Search("PROGRESS"))
    return GDT_TRUE;
  else if (FieldName.Search("UPDATE"))
    return GDT_TRUE;
  else
    return GDT_FALSE;
}

void ANZLIC:: Present (const RESULT& ResultRecord, const STRING& ElementSet,
		     const STRING& RecordSyntax, PSTRING StringBuffer)
{
  STRING FieldName;
  
  if (ElementSet.Equals(BRIEF_MAGIC)) {
//    FieldName = "title";	// Brief headline is "title"
    STRLIST Strlist;
    STRING Title;
    GDT_BOOLEAN Status;
    FieldName = "CITATION-INFORMATION_TITLE";
    Status = Db->GetFieldData(ResultRecord, FieldName, &Strlist);
    if (Status) {
      Strlist.Join("\n",&Title);
      Title.Replace("\n"," ");
      Title.Replace("\r"," ");
    } else
      Title = "(title not found)";
    *StringBuffer = Title;
  } else if (ElementSet.CaseEquals("S")) {
/*  These fields define the S element set
         Title
         Edition
         Geospatial_Data_Presentation_Form
         Indirect_Spatial_Reference
         West_Bounding_Coordinate
         East_Bounding_Coordinate
         North_Bounding_Coordinate
         South_Bounding_Coordinate
         Beginning_Date
         Ending_Date
         Calendar_Date (need field name...)
         Maintenance_and_Update_Frequency
         Browse_Graphic_File_Name
*/
    STRLIST Strlist;
    STRING Hold, FieldType;
    STRING Title,Edition,GeoForm,Spatial,West,East,North,South;
    STRING BegDate,EndDate,CalDate,Update,BrowseGraphic;
    GDT_BOOLEAN Status;

    FieldName = "METADATA_IDINFO_CITATION_CITEINFO_TITLE";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, Title);
    if (Status) {
      Hold = Title;
      Hold.Cat("\n");
    } else
      Hold = "\n";

    FieldName = "METADATA_IDINFO_CITATION_CITEINFO_EDITION";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, Edition);
    if (Status)
      Hold.Cat(Edition);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_CITATION_CITEINFO_GEOFORM";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, GeoForm);
    if (Status)
      Hold.Cat(GeoForm);
    Hold.Cat("\n");

    FieldName = "METADATA_SPDOINFO_INDSPREF";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, Spatial);
    if (Status)
      Hold.Cat(Spatial);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_SPDOM_BOUNDING_WESTBC";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, West);
    if (Status)
      Hold.Cat(West);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_SPDOM_BOUNDING_EASTBC";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, East);
    if (Status)
      Hold.Cat(East);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_SPDOM_BOUNDING_NORTHBC";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, North);
    if (Status)
      Hold.Cat(North);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_SPDOM_BOUNDING_SOUTHBC";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, South);
    if (Status)
      Hold.Cat(South);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_TIMEPERD_TIMEINFO_RNGDATES_BEGDATE";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, BegDate);
    if (Status)
      Hold.Cat(BegDate);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_TIMEPERD_TIMEINFO_RNGDATES_ENDDATE";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, EndDate);
    if (Status)
      Hold.Cat(EndDate);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_STATUS_UPDATE";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, Update);
    if (Status)
      Hold.Cat(Update);
    Hold.Cat("\n");

    FieldName = "METADATA_IDINFO_BROWSE_BROWSEN";
    Db->FieldTypes.GetValue(FieldName,&FieldType);
    Status = GetCleanedFieldData(ResultRecord, FieldName, FieldType, BrowseGraphic);
    if (Status)
      Hold.Cat(BrowseGraphic);
    Hold.Cat("\n");

    *StringBuffer = Hold;

  } else {
    PCHR b;
    PFILE fp;
    STRING FullFilename;
    INT n, filelen;
    LONG lRecStart, lRecEnd, ActualLength;

    ResultRecord.GetFullFileName(&FullFilename);
    n = FullFilename.SearchReverse('.');
    FullFilename.EraseAfter(n);

    if (RecordSyntax == HTML_OID)
      FullFilename.Cat(FGDC_HTML_EXTENSION);
    else if (RecordSyntax == SUTRS_OID)
      FullFilename.Cat(FGDC_TEXT_EXTENSION);
    else
      FullFilename.Cat(FGDC_SGML_EXTENSION);

    lRecStart=0L;

    fp = fopen(FullFilename, "r");
    if (!fp) {
      // Hmmm...  We didn't find the requested file
      // Let's try sticking on the short extensions instead
      n = FullFilename.SearchReverse('.');
      FullFilename.EraseAfter(n);

      if (RecordSyntax == HTML_OID)
	FullFilename.Cat(SHORT_FGDC_HTML_EXTENSION);
      else if (RecordSyntax == SUTRS_OID)
	FullFilename.Cat(SHORT_FGDC_TEXT_EXTENSION);
      else
	FullFilename.Cat(SHORT_FGDC_SGML_EXTENSION);
      
      fp = fopen(FullFilename, "r");
      if (!fp) {
	// OK - neither version is here, so bail out
	*StringBuffer = "Requested file not found";
	return;
      }
    }

    if ((n=fseek(fp, 0L, SEEK_END)) != 0) {
      return;
    }

    lRecEnd = ftell(fp);

    if ((n=fseek(fp, lRecStart, SEEK_SET)) != 0) {
      return;
    }

    filelen = lRecEnd - lRecStart;
    b = new CHR[filelen + 1];
    ActualLength = fread(b, 1, filelen, fp);
    fclose(fp);
    b[ActualLength] = '\0';
  
    if (ActualLength != 0) {
      *StringBuffer = b;
    }
    delete [] b;
  }
  return;
  
}

ANZLIC::~ANZLIC ()
{
}

