#                              -*- Mode: Perl -*- 
case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting ir/mkinc (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >mkinc <<!GROK!THIS!
#!/bin/sh                      -- # -*- perl -*- 
eval 'exec $perl  -S \$0 "\$@"' 
 if 0;
!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>mkinc <<'!NO!SUBS!'
#!/usr/bin/perl
#                              -*- Mode: Perl -*- 
# $Basename: mkinc.SH $
# $Revision: 1.5 $
# Author          : Ulrich Pfeifer
# Created On      : Wed Jun 12 12:15:39 1996
# Last Modified By: Ulrich Pfeifer
# Last Modified On: Tue May  6 13:35:19 1997
# Language        : CPerl
# Update Count    : 34
# Status          : Unknown, Use with caution!
# 
# (C) Copyright 1997, Ulrich Pfeifer, all rights reserved.
# 
# 

use FileHandle;
use File::Basename;
use Cwd;

while ($ARGV[0] =~ /^-/) {
  if ($ARGV[0] =~ s/^-I//) {
    push @opt_I, $ARGV[0];
    shift;
  } else {
    warn "$0: Unknown option $ARGV[0]\n";
    shift;
  }
}

print <<"EOH"
/*                               -*- Mode: C -*- 
 * wais.h -- generated by $0
 * Author          : Ulrich Pfeifer
 * 
 * (C) Copyright 1996, Universitt Dortmund, all rights reserved.
 * 
 */
#ifndef WAIS_H
#define WAIS_H
EOH
  ;

my $cwd = getcwd;
for (@ARGV) {
  my($name, $path) = fileparse($_);
  chdir($path) or "could not chdir to $path: $!\n";
  #print STDERR "do file ($name, $path)\n";
  do_file($name);
  chdir($cwd);
}

print <<"EOT"
#endif /* WAIS_H */
EOT
  ;

exit(0);

sub search {
  my $file = shift;
  my $std  = shift;
  my @inc  = $std ? @opt_I : ('.', @opt_I);
  for (@inc) {
    my($tmpfile, $tmppath) = fileparse($_ . '/' . $file);
    $tmppath =~ s:/$::g;
    next unless -d $tmppath;
    #print STDERR "PATH: $tmppath\n";
    my $path = Cwd::abs_path($tmppath) . '/' . $tmpfile;
    return $path if -f $path;
  }
}

sub do_file {
  my $file = shift;
  my $std  = shift;
  my $path = search($file, $std);

  return unless $path;
  $path =~ s:/./:/:g;
  return if $SEEN{$path}++;
  print STDERR "Processing $path ...\n";
  #print "/* --- $path --- */\n";
  my $fh   = new FileHandle "< $path";

  if (defined $fh) {
    while (<$fh>) {
      if (s/^\#\s*include "(.*?)"//) {
        print;
        do_file($1);
      } elsif (s/^\#\s*include <(.*?)>//) {
        print;
        do_file($1,1);
      } else {
        print;
      }
    }
    $fh->close;
  }
  1;
}
!NO!SUBS!
chmod 755 mkinc
$eunicefix mkinc
