#include "cdialect.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include "futil.h"
#include "gopher.h"


	/* 
		At brown .cap files are know as property files and are kept
		in the property directory.
	*/

#ifdef BROWN_U
#define PROPERTY_DIR "property"
#else
#define PROPERTY_DIR ".cap"
#endif


boolean gopher_separator_function( char *line )
{
	return false;

} /* gopher_separator_function */


void gopher_header_function( char *line )
{
	/* nop */

} /* gopher_header_function */



long gopher_date_function( char *line )
{
	return 0;
	
} /* gopher_date_function */



static void trim_trailing_space( char* line )
{
	long index = strlen( line ) - 1;
	
	while ( index > 0 && isspace( line[ index ] ) )
		index--;

	line[ index + 1 ] = '\0';

} /* trim_trailing_space */



#define str_is_empty( _string ) ( (_string)[0] == '\0' )


void gopher_finish_header_function( char *header )
{
	extern char* current_filename;
	char current_path[ MAX_FILENAME_LEN + 1 ];
	char* current_name;
	char property_name[ MAX_FILENAME_LEN + 1 ];
	FILE* property_file;
	char line[256];	
	
		/*
			The file's header line should be either the filename
			or the name in the property file.
		*/
		
	header[0] = '\0'; /* empty the header */

		/* Does the property file exist? */
		
	current_name = pathname_name( current_filename );
	pathname_directory( current_filename, current_path ); /* includes trailing / */
	
	
	sprintf( property_name, "%s%s/%s"
		, current_path, PROPERTY_DIR, current_name );
	
	property_file = fopen( property_name, "r" );
	if ( property_file != NULL )
	{
			/* Scan the property file for name and type properties */
			
		line[0] = '\0';
		
		while ( fgets( line, sizeof( line ), property_file ) != NULL )
		{
			if ( strncmp( line, "Name=", 5 ) == 0 )
			{
					/* Copy the name property */
				
				trim_trailing_space( line );
				strcpy( header, line + 5 );

				break; /* Only one name in property file */
			}
		}
		
		fclose( property_file );
	}

		/* If didn't find name property then use filename */
		
	if ( str_is_empty( header ) )
		strcpy( header, current_name );

		/* Done */
		
} /* gopher_finish_header_function */

