.TH SWAIS 1 "1992-01-06" "UWO"
.SH NAME
swais, vtswais \- a simple WAIS query front-end
.SH SYNOPSIS
.B swais

.B vtswais
.SH DESCRIPTION

.B swais
is a curses-based, simple screen user interface for making WAIS queries.
This Simple WAIS interface is an basic access tool designed for those
focused on data retrieval and not computer operation. It provides most of the
functionality of the more complicated interfaces but features a simple and
potentially more natural interface for non-bitmapped screens.  The
functionality supported includes 
source selection, keyword entry, and automatic document retrieval.

There is currently no provision for relevance feedback based questions
nor is there a mechanism for storing questions to be asked again.
Remember, this is a simple interface!  

This software is fairly new and
experimental.  You should expect a few bugs.

vtswais is a special version of swais that forces your terminal type
to be a VT100 variant that works around a bug or two in swais.  Use it
on Mips-based machines whenever you are using a VT100
compatible screen.  Use it on all machines when  your terminal type is
set to xterm as it fixes a problem where the last page of a document
is cleared before it can be viewed.  You might want to try 
.B vtwais
if you encounter some other strangeness in the
.B swais
program.

When
.B swais
is first started, the "Source Selection" screen is displayed.  The
database source files displayed here are a combination of those in the system
source area and those that you have copied into your own
$HOME/wais-sources directory.  You must create this directory before
trying to save any database sources.

Select a database source (or source for short) by pressing the up and
down arrow keys to move the reverse-video bar over the source that you
want and then pressing the space-bar.  The selected source is marked
with a star.  You can select one or more sources for a search.

Type a "w" to move the cursor to the keyword list to be used in the
search.  Enter the keywords.  Use control-u to erase them and start
again.

Once you have typed your keyword list, type a <return> to do the
search of your selected sources using the keywords typed.  (Note that
sometimes an extra <return> is required to start the search.)

When your search is complete and there are some matches, a "Search
Results" screen is displayed.  It lists information headlines about
each matched entry.  The score column gives you a 1-1000 rating for
how "good" the match was.

To retrieve an entry, move the bar over it using the cursor keys and
press the space bar.  The document is retrieved and displayed using
your PAGER.  To retrieve and save or otherwise process a document use
the vertical bar "|" command to pipe the document to a program.  For
example the command "cat >/tmp/article" would save the retrieved
document in the file /tmp/article and the command "lpr" would send the
item to your default printer.

When retrieving from a directory of source files (like the
directory-of-servers source) you can use the the "u" command to add it
to your list of personal sources instead of the "<space>" to view it.
Once the source has been added, it will appear in the "Source
Selection" screen.  (The source file will be copied into the
$HOME/wais-sources directory (which must exist!))

To return to select another source or to try different search terms,
use the "s"  (source) or "w" (word) commands. 

To exit from the program, type a "q" at the source selection or
results screen.  

.SH FILES
.ta 2.5i

.br
.Pbr
$(HOME)/wais-sources	location for personal sources.
.br
.Pbr
/usr/ccs/share/lib/wais-sources
.br
	location for system-wide sources.

.SH BUGS

\fBswais\fR on the mips machine has trouble with VT100 terminals: use
vtswais to fix some of these.

While \fBswais\fR works on non-VT100 screens, it isn't very good
looking unless the screen has some sort of high-lighting.  The program
uses highlighting to indicate the current selection and you will
require a fast eye to see which selection or document is the current
one if your screen doesn't implement reverse-video or some other form
of marking.

If you try to save a source without having a $HOME/wais-sources
directory, the program bombs.  Create this directory first.

The Mips version doesn't display the help screens properly.  The
command keys don't show.  They are reproduced here for reference:
.nf
SWAIS                         Source Selection Help

j               Move Down one source
k               Move Up one source
##              Position to source number ##
<space>         Select current source
v               View current source info
<ret>           Perform search
s               Select new sources
w               Select new keywords
X               Remove current source permanently
h               Show this help display
H               Display program history
q               Leave this program

SWAIS                          Search Results Help

j, ^N           Move Down one item
k, ^P           Move Up one item
##              Position to item number ##
<space>         Display current item
<return>                Display current item
|               Pipe current item into a unix command
v               View current item information
s               Specify new sources to search
u               Use it; add it to the list of sources
w               Make another search with new keywords
h               Show this help display
H               Display program history
q               Leave this program

.fi
.SH SEE ALSO
.PP
xwaisq(1), xwais(1), waissearch(1), waisindex(1), waisserver(1)
.SH AUTHOR
Program by John Curran (jcurran@nnsc.nsf.net).

First pass at a manual by Peter Marshall CCS, The University of
Western Ontario: <peter.marshall@uwo.ca>.

