########################## -*- Mode: Perl -*- ##########################
##
## File             : German.pm
##
## Description      : SFgate messages in german
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 11:34:06 1996
##
## $State: Exp $
##
## $Id: German.pm,v 5.1.1.1 1996/12/23 12:51:26 goevert Exp goevert $
##
## $Log: German.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:26  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:38  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/05/31 15:45:15  goevert
## patch14: language handling changed (SFgate-server)
##
## Revision 5.0.1.2  1996/05/15 17:07:54  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:33  goevert
## patch1:
##
########################################################################


package SFgate::Language::German;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|und'; 
$or_regexp        = 'or|oder';
$not_regexp       = 'not|nicht';

$plaintext_regexp = 'text|strikt|genau';
$soundex_regexp   = 'soundex|\344hnlich';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'Keine Beschreibung verf&uuml;gbar.',
             'print_wsrc',         'Datenbankbeschreibung konnte nicht geparsed werden:',
             'init_plain1',        'Sie haben <B>ein</B> Dokument ausgew&auml;hlt:',
             'init_plain2',        'Sie haben <B>',
             'init_plain3',        '</B> Dokumente ausgew&auml;hlt:',
             'init_plain4',        'Es wurden keine Dokumente ausgew&auml;hlt!',
             'init_plain5',        'In den ausgew&auml;hlten Datenbanken wurde <B>ein</B> Dokument gefunden, das zu Ihrer Anfrage pa&szlig;t:',
             'init_plain6',        'In den ausgew&auml;hlten Datenbanken wurden <B>',
             'init_plain7',        '</B> Dokumente gefunden, die zu Ihrer Anfrage passen:',
             'init_plain8',        'In den ausgew&auml;hlten Datenbanken wurde <B>kein</B> Dokument gefunden, das zu Ihrer Anfrage pa&szlig;t.',
             'init_plain9',        'Konvertierung der Dokumente:',
             'init_plain10',       'W&auml;hlen Sie Dokumente aus:',
             'init_plain11',       'Dokumente holen',
             'init_plain12',       'neue Auswahl',
             'init_plain13',       'Vorherige Dokumente...',
             'init_form1',         'In den ausgew&auml;hlten Datenbanken wurde <B>eine</B> Datenbankbeschreibung gefunden, die zu Ihrer Anfrage pa&szlig;t:',
             'init_form2',         'In den ausgew&auml;hlten Datenbanken wurden <B>',
             'init_form3',         '</B> Datenbankbeschreibungen gefunden, die zu Ihrer Anfrage passen:',
             'init_form4',         'W&auml;hlen Sie Datenbanken aus und formulieren Sie Ihre Anfrage:',
             'init_form5',         'Suche starten',
             'init_form6',         'neue Anfrage',
             'print_anchor1',      'Datenbank:',
             'print_anchor2',      'Gr&ouml;&szlig;e:',
             'print_anchor3',      'Typ:',
             'print_anchor4',         'Score:',
             'print_diagnostics1', 'Diagnostik',
             'print_diagnostics2', 'Server <B>',
             'print_diagnostics3', '</B> liefert folgende Diagnostik:',
             # search_index.pl
             'do_request1',        'konnte das Dokument nicht laden',
             'do_request2',        'WAIS-Dokumente',
             'do_request3',        'Versuchen Sie es auf direktem Wege!',
             'do_request4',           'debug',
             'do_request5',        'Sie haben keine Anfrage spezifiziert.',
             'do_request6',        'an',
             'do_request7',        'Sie haben keine Datenbank gew&auml;hlt.',
             'print_queries1',     'Ihre Anfrage lautete:',
             'print_queries2',     'Anfragen an die Datenbanken:',
             'print_forms',        'Verfeinern Sie Ihre Anfrage',
             'dumpenv',            'Ausgabe der Umgebungsvariablen',
             'print_footer1',      'Weitere Dokumente...',
             'print_footer2',      'Diese Seite wurde generiert von',
             'do_sorry1',          'Syntaktischer Fehler in der Anfrage',
             'do_sorry2',          'Eine Bearbeitung der Anfrage ist nicht m&ouml;glich:',
             'main1',              'terminiert',
             'main2',              'terminiert mit Meldung',
             'main3',              'Bitte benachrichtigen Sie den WWW-Administrator.',
             'main4',              'Seltsamer Fehler',
             'main5',              'ist nicht',
             'main6',              'Wie wurde ich dann aufgerufen?',
             # query.pl
             'translate_query',    'Ein Datum Feld konnte nicht geparsed werden:',
             # parse_query.pl
             'parse_query1',       'Ende der Anfrage nach dem Operator',
             'parse_query2',       'unerwartete schlie&szlig;ende Klammer',
             'parse_query3',       'unerwartete schlie&szlig;ende Klammer',
             'parse_query4',       'unerwarteter Operator',
             'parse_query5',       'unerwartetes numerisches Pr&aauml;dikat',
             'parse_query6',       'unerwartetes',
             'parse_query7',       'fehlende Anfrage nach &ouml;ffnender Klammer',
             'parse_query8',       'fehlende schlie&szlig;ende Klammer',
             'parse_query9',       'kein Begrenzer f&uuml;r literale Suche:',
             'parse_query10',      'atleast Operator ohne numerisches Argument',
             'parse_query11',      'atleast Operator ohne Term',
             'parse_query12',      'geschachtelte Indextyplisten nicht m&ouml;glich',
             'parse_query13',      'fehlende &Ouml;ffnende Klammer nach Indextypliste',
             'parse_query14',      'fehlende Anfrage nach Indextypliste',
             'parse_query15',      'fehlende schlie&szlig;ende Klammer nach Indextypliste',
             'parse_query16',      'kein Term zum Indextyp',
             'parse_query17',      'proximity Operator',
             'parse_query18',      'ohne numerisches Argument > 0',
             'parse_query19',      'ohne zweiten Term',
             'parse_query20',      'geschachtelte Fieldexpressions nicht m&ouml;glich',
             'parse_query21',      'nicht numerisches Argument mit numerischem Pr&auml;dikat',
             'parse_query22',      'fehlende Anfrage in Fieldexpression'
             );


1;
