########################## -*- Mode: Perl -*- ##########################
##
## File             : French.pm
##
## Description      : SFgate messages in french
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:52:29 1996
##
## $State: Exp $
##
## $Id: French.pm,v 5.1.1.1 1996/12/23 12:51:24 goevert Exp goevert $
##
## $Log: French.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:24  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:36  goevert
## *** empty log message ***
##
## Revision 5.0.1.4  1996/05/31 15:45:09  goevert
## patch14: language handling changed (SFgate-server)
##
## Revision 5.0.1.3  1996/05/23 17:08:01  goevert
## patch13: added some translations
##
## Revision 5.0.1.2  1996/05/15 17:07:51  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:30  goevert
## patch1:
##
########################################################################

# Thanks to Dominique Pinse <pinse@vnet.ibm.com> and
# Martial Chartoire <chartoir@ipnl.in2p3.fr>
# for providing these translations


package SFgate::Language::French;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|et'; 
$or_regexp        = 'or|ou';
$not_regexp       = 'not|non';

$plaintext_regexp = 'text|plain|strict';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'Pas de fichier de description disponible.',
             'print_wsrc',         'Le fichier source WAIS ne peut pas &ecirc;tre analys&eacute;:',
             'init_plain1',        'Vous avez choisi <B>un</B> document:',
             'init_plain2',        'Vous avez choisi <B>',
             'init_plain3',        '</B> documents:',
             'init_plain4',        'Vous n\'avez pas choisi de documents!',
             'init_plain5',        'Il y a <B>un</B> document r&eacute;pondant &agrave; votre requ&ecirc;te:',
             'init_plain6',        'Il y a <B>',
             'init_plain7',        '</B> documents r&eacute;pondant &agrave; votre requ&ecirc;te:',
             'init_plain8',        'Il n\'y a pas de document r&eacute;pondant &agrave; votre requ&ecirc;te.',
             'init_plain9',        'Conversion des documents:',
             'init_plain10',       'S&eacute;lectionnez les documents:',
             'init_plain11',       'rechercher les documents',
             'init_plain12',       'autre choix',
             'init_plain13',       'Documents pr&eacute;c&eacute;dents...',
             'init_form1',         'Les bases de donn&eacute;es s&eacute;lectionn&eacute;es contiennent <B>une</B> description de database correspondant &agrave; votre requ&ecirc;te:',
             'init_form2',         'Les bases de donn&eacute;es s&eacute;lectionn&eacute;es contiennent <B>',
             'init_form3',         '</B> descriptions de database correspondant &agrave; votre requ&ecirc;te:',
             'init_form4',         'S&eacute;lectionnez les bases de donn&eacute;es et formulez votre requ&ecirc;te:',
             'init_form5',         'lancer la recherche',
             'init_form6',         'nouvelle requ&ecirc;te',
             'print_anchor1',      'Base de donn&eacute;es:',
             'print_anchor2',      'Taille:',
             'print_anchor3',      'Type:',
             'print_anchor4',         'Score:',
             'print_diagnostics1', 'Diagnostique',
             'print_diagnostics2', 'Le serveur <B>',
             'print_diagnostics3', '</B> a renvoy&eacute; le diagnostique suivant:',
             # search_index.pl
             'do_request1',        'impossible de r&eacute;cup&eacute;rer le document:',
             'do_request2',        'Documents WAIS',
             'do_request3',        'Essayez de le prendre directement!',
             'do_request4',        'debogge',
             'do_request5',        'Vous n\'avez pas sp&eacute;cifi&eacute; de requ&ecirc;te.',
             'do_request6',        'dans',
             'do_request7',        'Vous n\'avez pas s&eacute;lectionn&acute; de bases de donn&eacute;es.',
             'print_queries1',     'Votre requ&ecirc;te &eacute;tait:',
             'print_queries2',        'Queries in Databases:',
             'print_forms',           'Refine your query',
             'dumpenv',            'Environnement de dump',
             'print_footer1',      'Documents suivants...',
             'print_footer2',      'Cette page a &eacute;t&eacute; g&eacute;n&eacute;r&eacute;e par',
             'do_sorry1',          'Erreur de syntaxe dans votre requ&ecirc;te',
             'do_sorry2',          'D&eacute;sol&eacute;, votre requ&ecirc;te ne peut pas &ecirc;tre analys&eacute;e:',
             'main1',              'termin&eacute;',
             'main2',              'termin&eacute; avec un message',
             'main3',              'Contactez le webmaster SVP.',
             'main4',              'Erreur &eacute;trange',
             'main5',              'n\'est pas',
             'main6',              'Qui vient de m\'appeler?',
             # query.pl
             'translate_query',    'Analyse grammaticale du champ date impossible',
             # parse_query.pl
             'parse_query1',       'fin de requ&ecirc;te apr&eacute;s l\'op&eacute;rateur',
             'parse_query2',       'parenth&egrave;se fermante inattendue',
             'parse_query3',       'crochet fermant inattendu',
             'parse_query4',       'op&eacute;rateur inattendu',
             'parse_query5',       'attribut num&eacute;rique inattendu',
             'parse_query6',       'inattendu',
             'parse_query7',       'manque de requ&ecirc;te apr&eacutes la parenth&egrave;se ouvrante',
             'parse_query8',       'parenth&egrave;se fermante manquante',
             'parse_query9',       'pas de d&eacute;limiteur de recherche lit&eacute;ral',
             'parse_query10',      'atleast operateur sans argument num&eacute;rique',
             'parse_query11',      'atleast operateur sans terme',
             'parse_query12',      'indextypelists imbriqu&eacute; impossible',
             'parse_query13',      'crochet ouvrant manquant apr&eacute;s indextypelist',
             'parse_query14',      'requ&ecirc;te manquante apr&eacute;s indextypelist',
             'parse_query15',      'crochet fermant manquant apr&eacute;s indextypelist',
             'parse_query16',      'pas de terme avec indextype',
             'parse_query17',      'operateur de proximit&eacute;',
             'parse_query18',      'sans argument num&eacute;rique > 0',
             'parse_query19',      'sans 2eme terme',
             'parse_query20',      'fieldexpressions imbriqu&eacute; non possible',
             'parse_query21',      'argument non num&eacute;rique avec attribut num&eacute;rique',
             'parse_query22',      'requ&ecirc;te manquante dans fieldexpression'
             );


1;
