########################## -*- Mode: Perl -*- ##########################
##
## File             : BibTeX.pm
##
## Description      : converts tagged format (bibdb-html) to BibTeX
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : 
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu May 23 10:09:28 1996
##
## $State: Exp $
##
## $Id: BibTeX.pm,v 5.1 1996/11/05 16:54:50 goevert Exp goevert $
##
## $Log: BibTeX.pm,v $
## Revision 5.1  1996/11/05 16:54:50  goevert
## *** empty log message ***
##
## Revision 5.0.1.2  1996/05/23 17:06:59  goevert
## patch13: removed no strict 'vars';
##
## Revision 5.0.1.1  1996/05/13 11:26:59  goevert
## patch1:
##
########################################################################


package SFgate::Converter::BibTeX;


use strict;


## #####################################################################
## convert
## #####################################################################
## interface for SFgate to convert one document
##
## (string) $text:     document to convert
## (string) $headline: headline of document to convert
##
## By default every document is printed with its corresponding wais
## headline. If you want to derive another headline just change
## the $headline variable according to your needs.
##
## HTML special characters (&, <, >) should be encoded in text not
## being HTML code. To do this you can use the function
## &::encode_entities, e.g. $ntext = &::encode_entities($ntext)
## encodes the special chars in $ntext.
##
## returns:
## - string: the converted document ($ntext)
## - string: headline of converted document ($headline)
##
sub convert
{
    my($text, $headline) = @_;
    ## local variables
    local($_);
    my($headtag, $headpos, $head, $tmpfile);
    ## return value
    my($ntext);
    
    $tmpfile = "/tmp/SFgate.$$";

    open(TMP, "> $tmpfile") || die "Could not open $tmpfile: $!\n";
    print TMP $text;
    close (TMP);
        
    open(CONVERT, "/usr/local/ls6/bin/sun4-sunos/convert $tmpfile |")
        || die "Could not call converter: $!\n";
    while (<CONVERT>) {
        next if /^%/;
        $ntext .= $_;
    }
    close(CONVERT);
    
    unlink($tmpfile);

    $ntext = "<PRE>\n$ntext</PRE>\n";
    
    # find first headline and remove it from text
    if ($text =~ /(<h[0-9]>)/i) {
        $headtag = $1;
        $headpos = index($text, $headtag);
        $head    = substr($text, $headpos + 4, 300);
        $headtag =~ s:<:</:;
        $head    =~ s:$headtag(.|\n)*::i;
    }
    $headline = $head  if $head;
    
    return($ntext, $headline);
}


1;
