/* psrvchat.c */
/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 * Written by swa@isi.edu, 1/25/93, based on code swiped from other Prospero
 * clients.
 */


#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>

#include <ardp.h>
#include <pfs.h>
#include <perrno.h>
#include <pprot.h>

extern int	perrno;
int		pfs_debug = 0;

static char *username();

main(argc,argv)
    int		argc;
    char	*argv[];
{
    RREQ		req;

    char		dirhst[40];
    int		        headerflag = 0; /* use v5 headers (unless 
                                           1 specified) */
    int                 v1flag = 0; /* version 1 of protocol. */
    int                 fflag = 0;  /* be very quiet */
    char		line[MAX_DIR_LINESIZE];
    char		*command = "TERMINATE";
    char		*progname = argv[0];
    char		*cur_arg;
    int		tmp;

    gethostname(dirhst,sizeof dirhst);

    argc--;argv++;

    while (argc > 0 && **argv == '-') {
        cur_arg = argv[0]+1;

        /* If a - by itself, or --, then no more arguments */
        if(!*cur_arg || ((*cur_arg == '-') && (!*(cur_arg+1)))) {
            argc--, argv++;
            goto scandone;
        }

        while (*cur_arg) {
            switch (*cur_arg++) {

            case '1':           /* use version 1 headers. */
                v1flag++;
                break;

            case 'D':  /* debug level */
                pfs_debug = 1; /* Default debug level */
                if(*cur_arg && index("0123456789",*cur_arg)) {
                    sscanf(cur_arg,"%d",&pfs_debug);
                    cur_arg += strspn(cur_arg,"0123456789");
                }
                else if(argc > 2) {
                    tmp = sscanf(argv[1],"%d",&pfs_debug);
                    if (tmp == 1) {argc--;argv++;}
                }
                break;

	    case 'N':  /* Priority (nice) */
		ardp_priority = ARDP_MAX_PRI; /* Use this if no # */
                if(*cur_arg && index("-0123456789",*cur_arg)) {
                    sscanf(cur_arg,"%d",&ardp_priority);
                    cur_arg += strspn(cur_arg,"-0123456789");
                }
                else if(argc > 2) {
                    tmp = sscanf(argv[1],"%d",&ardp_priority);
                    if (tmp == 1) {argc--;argv++;}
                }
		if(ardp_priority > ARDP_MAX_SPRI) 
		    ardp_priority = ARDP_MAX_PRI;
		if(ardp_priority < ARDP_MIN_PRI) 
		    ardp_priority = ARDP_MIN_PRI;
		break;

            case 'f':
                fflag++;
                break;
            case 'h':  /* use headers */
                headerflag++;
                break;

            default:
                fprintf(stderr,"Usage: %s [-f,-1,-h] [host name]\n",
                        progname);
                exit(1);
            }
        }
        argc--, argv++;
    }

scandone:

    if(argc > 1) {
        fprintf(stderr,"Usage: %s [-1, -f,-r] [host name]\n",progname);
        exit(1);
    }

    if(argc > 0)
        qsprintf(dirhst, sizeof dirhst, "%s", argv[0]);


    if (v1flag) {
        req = ardp_rqalloc();
        p__add_req(req, "VERSION 1\nAUTHENTICATOR UNAUTHENTICATED %s\n", 
                  username());
    } else if (headerflag) {
        req = p__start_req(dirhst);
    } else {
        req = ardp_rqalloc();
    }

    if (isatty(0))              /* warn the user. */
        puts("Reading from standard input:");
    
    while(gets(line))
        p__add_req(req, "%s\n", line);

#if 0      /*  I don't think this is needed any more with the debug flag. */
    if(!fflag) printf("Sending message to %s:\n%s\n",dirhst,request->start);
#endif

    if(ardp_send(req,dirhst,0, ARDP_WAIT_TILL_TO) && !fflag) {
        fprintf(stderr,"%s",progname);
        perrmesg(" failed: ", 0, NULL);
        exit(1);
    }

    /* No way to set pwarn. */
    /* if(pwarn && !fflag) pwarnmesg("WARNING: ",0,NULL); */

    /* I think this is a good idea, just for this program. */
    if (!fflag) {
        printf("Response:\n");
	while(req->inpkt) {
	    printf("%s",req->inpkt->text);
	    req->inpkt = req->inpkt->next;
	}
    }
    ardp_rqfree(req);
    exit(0);
}

#include <pwd.h>
#include <pcompat.h>            /* for DISABLE_PFS */

static char *
username()
{
    struct passwd *whoiampw;
    /* find out who we are */
    DISABLE_PFS(whoiampw = getpwuid(getuid()));
    if (whoiampw == 0) return "nobody";
    else return whoiampw->pw_name; /* static data; overwritten on next call to
                                      getpwuid(). */
}
