/* Copyright (c) 1992 by the University of Southern California. */
/* For copying and distribution information, see the file <usc-copyr.h> */
#include <usc-copyr.h>

#include <pfs.h>
#include <pprot.h>

/* Returns PFAILURE or PSUCCESS. */
int
vqfprintf(FILE *outf, char fmt[], va_list ap)
{
    int retval;
    
    char buf[MAX_DIR_LINESIZE];
    if (vqsprintf(buf, sizeof buf, fmt, ap) > sizeof buf) {
        interr_buffer_full();
    } else if (fputs(buf, outf) == EOF) {
        retval = PFAILURE;
    } else {
        retval = PSUCCESS;
    }
    return retval;
}
