/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

#ifndef NULL
#define NULL 0
#endif

char	*strpbrk();

/*
 * strtok - Break a string into tokens
 *
 *	      STRTOK breaks a string into tokens.  On its initial
 *            call, STRTOK returns a pointer to the initial character of
 *            the string.  A null will be written into the first character
 *            found in sep.  Subsequent calls are to be made with a NULL
 *            first argument.  They will retrurn a pointer to subsequent
 *            tokens.  When no tokens remain, NULL is returned.
 *
 *    ARGS:   string - string to be broken into tokens
 *            sep    - string of separating characters
 *
 * RETURNS:   pointer to token
 */
char *
strtok(string,sep)
    char	*string;   
    char	*sep; 
    {
	static	char	*nexttoken;  /* Next token to be returned      */
	char		*thistoken;  /* Token to be returned this time */

	if(string) thistoken = string;
	else thistoken = nexttoken;

	if(thistoken == NULL) return(thistoken);

	/* Strip off leading separators */
	thistoken = thistoken + strspn(thistoken,sep);

	/* If the end of the string, then return NULL */
	if(*thistoken == '\0') return(NULL);

	/* Move pointer to end of this token */
	nexttoken = strpbrk(thistoken,sep);

	/* Separate this token from nexttoken */
	if(nexttoken) *(nexttoken++) = '\0';

	return(thistoken);
    }
