/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993       by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>
#include <strings.h>

#include <ardp.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pparse.h>

extern int	pfs_debug;

/* Obtain object attributes from a remote host.. */
/* Use pget_linkat() to obtain link attributes. */
PATTRIB pget_at(link,atname)
    VLINK	link;
    char	*atname;
{
    RREQ	req;		/* Text of request to dir server             */
    PATTRIB	retval = NULL;	/* Start of list of attributes               */
    INPUT_ST    in_st;
    INPUT       in = &in_st;
    int		tmp;

    int	fwdcnt = MAX_FWD_DEPTH;
    char	fwdhst[MAX_DIR_LINESIZE];
    char	fwdfnm[MAX_DIR_LINESIZE];

    /* It's not an error to ask; However, we already know that there won't be
       any object attributes, so we just report that fact and don't waste the
       time for the request to time out. */
    if (link->target && !strequal(link->target, "OBJECT") 
        && !strequal(link->target, "FILE") 
        && !strequal(link->target, "DIRECTORY")
        && !strequal(link->target, "DIRECTORY+FILE"))
        return NULL; 
startover:

    req = p__start_req(link->host);
    p__add_req(req, "GET-OBJECT-INFO %'s ASCII %'s 0\n",
	      atname, link->hsoname);
    if (link->f_magic_no)
        p__add_req(req, "SELECT OBJECT FIELD ID REMOTE %ld\n", 
               link->f_magic_no);

    tmp = ardp_send(req,link->host,0,ARDP_WAIT_TILL_TO);

    /* If the request fails or if we don't get a response, then return error */
    if(tmp ||  req->rcvd == NULL) return(NULL);

    rreqtoin(req, in);

    while (!in_eof(in)) {
        char		*line;
        char            *next_word;
        int tmp;                /* error return code from functions */

        if (in_line(in, &line, &next_word)) {
            ardp_rqfree(req);
            return(NULL);
        }
        switch (*line) {
        case 'A': /* ATTRIBUTE */
            /* If anything but ATTRIBUTE scan error */
            if(!strnequal(line,"ATTRIBUTE", 9)) 
                goto scanerr;

            if (in_ge1_atrs(in, line, next_word, &retval)) {
                ardp_rqfree(req);
                return NULL; /* perrno will be set. */
            }
            break;
            
        case 'N': /* NONE-FOUND */
            /* NONE-FOUND, we just have no attributes to insert.  No error;
               just don't do anything. */
            if(strncmp(line,"NONE-FOUND",10) == 0) 
                break;
            goto scanerr;

        case 'F':/* FORWARDED, FAILURE */
            if(strncmp(line,"FORWARDED",9) == 0) {
                if(fwdcnt-- <= 0) {
		    ardp_rqfree(req);
                    perrno = PFS_MAX_FWD_DEPTH;
                    return(NULL);
                }
                /* parse and start over */
                tmp = sscanf(line,"FORWARDED %*s %s %*s %s %d %d", 
                             fwdhst,fwdfnm,
                             &(link->version), &(link->f_magic_no));

                link->host = stcopyr(fwdhst,link->host);
                link->hsoname = stcopyr(fwdfnm,link->hsoname);
                
                if(tmp < 2) {
                    perrno = DIRSRV_BAD_FORMAT;
                    break;
                }

		ardp_rqfree(req);
                goto startover;
            }
            /* If FAILURE or anything but FORWARDED, scan error */
            goto scanerr;

        scanerr:
        default:
            if(*line && (tmp = scan_error(line))) {
		ardp_rqfree(req);
                perrno = tmp;
                return(NULL);
            }
            break;
        }                       /* end of moby switch */
    }                           /* while in_nextline(in) */
    ardp_rqfree(req);
    return(retval);
}


