/*
 * Copyright (c) 1991       by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>

#include <ardp.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pparse.h>

extern int	pfs_debug;
extern char	*acltypes[];

/*
 *
 *   Flags:      
 */
modify_acl(dlink,lname,a,flags)
    VLINK	dlink;		/* Directory link                 */
    char	*lname;		/* Link name.  Must be empty for DIRECTORY
                                   option. OBJECT option not implemented, so
                                   don't worry about it. */
    ACL		a;		/* ACL entry to add/delete/modify */
    int		flags;		/* Flags                          */
{
    RREQ	req;		/* Text of request to dir server             */
    char	options[100];   /* List of options                           */
    char	*optptr;        /* Options minus leading + */
    int		tmp;           
    OUTPUT_ST   out_st;
    OUTPUT      out = &out_st;
    INPUT_ST    in_st;
    INPUT       in = &in_st;

    int	fwdcnt = MAX_FWD_DEPTH;
    char	fwdhst[MAX_DIR_LINESIZE];
    char	fwdfnm[MAX_DIR_LINESIZE];

    char    *quote();

    *options = '\0';

    if(flags&EACL_NOSYSTEM) strcat(options,"+NOSYSTEM");
    if(flags&EACL_NOSELF) strcat(options,"+NOSELF");
    if(!((flags&EACL_OP)^EACL_DEFAULT)) strcat(options,"+DEFAULT");
    if(!((flags&EACL_OP)^EACL_SET)) strcat(options,"+SET");
    if(!((flags&EACL_OP)^EACL_INSERT)) strcat(options,"+INSERT");
    if(!((flags&EACL_OP)^EACL_DELETE)) strcat(options,"+DELETE");
    if(!((flags&EACL_OP)^EACL_ADD)) strcat(options,"+ADD");
    if(!((flags&EACL_OP)^EACL_SUBTRACT)) strcat(options,"+SUBTRACT");
    if(!((flags&EACL_OTYPE)^EACL_LINK)) strcat(options,"+LINK");
    if(!((flags&EACL_OTYPE)^EACL_DIRECTORY)) strcat(options,"+DIRECTORY");
    if(!((flags&EACL_OTYPE)^EACL_OBJECT)) strcat(options,"+OBJECT");
    /* not yet implemented on server. */
    if(!((flags&EACL_OTYPE)^EACL_INCLUDE)) strcat(options,"+INCLUDE");

    optptr = options + 1;

    if(lname == NULL) lname = "";

    if(strcmp(dlink->target,"NULL") == 0) return(PFS_EXT_USED_AS_DIR);
    if(strcmp(dlink->target,"EXTERNAL") == 0) return(PFS_EXT_USED_AS_DIR);

startover:

    req = p__start_req(dlink->host);
    /* XXX need to add capability for ID specification.. */
    requesttoout(req,out);
    p__add_req(req,"DIRECTORY ASCII %'s\nEDIT-ACL %s %'s\n",
           dlink->hsoname, optptr, lname);
    out_acl(out, a);

    perrno = 0;

    tmp = ardp_send(req,dlink->host,0,ARDP_WAIT_TILL_TO);

    if(tmp) {
        if (pfs_debug) fprintf(stderr,"ardp_send failed: %d\n",tmp);
	perrno = tmp;
    }

    /* If we don't get a response, then return error */
    if(req->rcvd == NOPKT) {
        ardp_rqfree(req);
        return(perrno);
    }
    /* Here we must parse reponse - While looking at each packet */

    rreqtoin(req, in);
    while(!in_eof(in)) {
        char		*line;
        char            *next_word;

        if (tmp = in_line(in, &line, &next_word)) {
            ardp_rqfree(req);
            return(tmp);
        }
        switch (*line) {

        case 'F': /* FAILURE or FORWARDED */
            /* FORWARDED */
            if(strncmp(line,"FORWARDED",9) == 0) {
                if(fwdcnt-- <= 0) {
                    ardp_rqfree(req);
                    perrno = PFS_MAX_FWD_DEPTH;
                    return(perrno);
                }
                /* parse and start over */
                tmp = sscanf(line,"FORWARDED %*s %s %*s %s %*d %*d", 
                             fwdhst,fwdfnm);
                dlink->host = stcopyr(fwdhst,dlink->host);
                dlink->hsoname = stcopyr(fwdfnm,dlink->hsoname);

                if(tmp < 2) {
                    ardp_rqfree(req);
                    perrno = DIRSRV_BAD_FORMAT;
                    break;
                }
                ardp_rqfree(req);
                goto startover;
            }
            /* If FAILURE or anything else scan error */
            goto scanerr;

        case 'S': /* SUCCESS */
            if(strncmp(line,"SUCCESS",7) == 0) {
                ardp_rqfree(req);
                return(PSUCCESS);
            }
            goto scanerr;

        scanerr:
        default:
            if(*line && (tmp = scan_error(line))) {
                ardp_rqfree(req);
                return(tmp);
            }
            break;
        }
    }
    perrno = DIRSRV_BAD_FORMAT;
    ardp_rqfree(req);
    return(perrno);
}
