/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <errno.h>
#include <strings.h>
#include <sys/stat.h>
#include <pmachine.h>


extern int	errno;

/*
 * mkdirs - Make a directory and all superior directories
 *
 *          MKDIRS takes a pathame for a directory, checks to see
 *          whether it exists, and if not creates it.  Any parent
 *          directories which do not exist will be created as
 *          well.
 *
 *    ARGS: path    - path of the directoriy to be created
 *
 * RETURNS: 0 on success
 *          the contents of errno on error
 */
mkdirs(path)
    char *path;
    {
	char	prefix[MAXPATHLEN];
	char	*suffix;
	struct  stat st;
	int	tmp = 0;
	int	mode;

	mode = 0777;

	if (stat(path,&st) == 0) { /* exists, either dir. or file */
	    if (!S_ISDIR(st.st_mode)) 
		return(EEXIST); /* already exists and is not dir. */
	}
	else tmp = mkdir(path,mode);

	if(!tmp) {
	    chmod(path,mode);
	    return(0);
	}

	if(errno == ENOENT) {
	    strcpy(prefix,path);
	    suffix = rindex(prefix,'/');
	    if(suffix) *suffix = '\0';
	    else *prefix = '\0';
	    if(*prefix == '\0') return(errno);
	    
	    mkdirs(prefix);
	    tmp = mkdir(path,mode);
	    if(tmp) return(errno);
	    chmod(path,mode);
	    return(0);
	}
	return(errno);
    }
