/* pparse.h */
/* Copyright (c) 1992 by the University of Southern California
   For copying information, see the file <usc-copyr.h>
*/
#include <usc-copyr.h>
#include <pfs.h>                /* includes internal error definitions. */
#include <stdio.h>
#include <perrno.h>

/* Data definition.  This may be reset by any client. */
#ifdef __STDC__
int (*internal_error_handler)(char file[], int line, char mesg[]) = 0;
#else
int (*internal_error_handler)() = 0;
#endif

/* A function version of internal_error().  Used by macros. */
int
finternal_error(char file[], int line, char msg[])
{
#if 0
    write(2, "Internal error in file ", 
          sizeof "Internal error in file " -1); 
    write(2, file, strlen(file));
    write(2, ": ", 2); 
    write(2, msg, strlen(msg)); 
    write(2, "\n", 1);        
#endif
    fprintf(stderr, "Internal error at %s:%d: %s\n",
            file, line, msg);
    if (internal_error_handler)   
        (*internal_error_handler)(file, line, msg);   
    else  
        abort();
    return PFAILURE;            /* to shut up GCC; should never return. */
}
