/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>
#include <errno.h>

#include <pfs.h>
#include <psite.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	errno;

/*
 * see pcompat.h for the meanings of the flage
 */
pfs_access(path,npath, npathlen, flags)
    char	*path;
    char	*npath;
    int         npathlen;
    int		flags;
{

    char		cpath[MAXPATHLEN];
    char		*prefix;
    char		*suffix;
    VLINK		vl;
    int		tmp;

    suffix = "";

    check_pfs_default();

    errno = 0;

    /* If disabled, do no mapping */
    if(pfs_enable == PMAP_DISABLE) {
        strcpy(npath,path);
        return(PSUCCESS);
    }

    if(pfs_enable == PMAP_COLON) {
        if(*path == ':') path++;
        else if(index(path,':'));
        else {strcpy(npath,path); return(PSUCCESS);}
    }

    if((pfs_enable == PMAP_ATSIGN_NF) || (pfs_enable == PMAP_ATSIGN)) {
        if(*path == '@') {
            path++;
            strcpy(npath,path); 
            return(PSUCCESS);
        }
    }

    /* I should probably choose better values for errno */
    vl = rd_vlink(path);
    if((perrno || !vl) && ((flags == PFA_CRMAP)||(flags == PFA_CREATE))) {
        strcpy(cpath,path);
        prefix = cpath;
        suffix = rindex(cpath,'/');
        if(suffix) {
            if(suffix == prefix) prefix = "/";
            *(suffix++) = '\0';
            vl = rd_vlink(prefix);
            if(vl) {
                sprintf(cpath,"%s/%s",vl->hsoname,suffix);
                vl->hsoname = stcopyr(cpath,vl->hsoname);
            }
        }
    }


    /* If not found, but PMAP_ATSIGN_NF, then check if a real file */
    if(((perrno == PFS_DIR_NOT_FOUND) || (perrno == RVD_DIR_NOT_THERE) ||
        (!perrno && !vl)) && 
       (pfs_enable == PMAP_ATSIGN_NF) && 
       (*path == '/') && ((strncmp(path,"/tmp",4) == 0) ||
          ((flags != PFA_CRMAP) && (flags != PFA_CREATE)))) {
           strcpy(npath,path); 
           return(PSUCCESS);
    }

    if(perrno) {errno = ENOENT;return(perrno);}
    if(!vl) {errno = ENOENT;return(PFS_FILE_NOT_FOUND);}

    tmp = mapname(vl,npath, npathlen, ((flags & PFA_RO) ? 
                            MAP_READONLY : MAP_READWRITE));
    vllfree(vl);
    if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) errno = ENOENT;
    return(tmp);
}

