/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 *
 * Written  by bcn 1/93     to send a list of packets to a destination
 */

#include <usc-copyr.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <ardp.h>

extern int	       pfs_debug;            /* Debug level                */
extern int	       ardp_port;	     /* Opened UDP port		   */

/*
 * ardp_xmit - transmits packets in req->trns
 *
 *   ardp_xmit takes a pointer to a request structure of type RREQ and a
 *   window size.  It then sends the packet on the request structure
 *   transmit queue to the peer address in the request structure starting after
 *   the indicated peer rcvd_thru value, and up to the number of packets 
 *   specified by the window size.  It returns ARDP_SUCCESS on success and
 *   returns an error code on failure.
 */
ardp_xmit(RREQ	req,            /* Request structure with packets to send   */
	  int	window)         /* Max packets to send at once              */
{
    PTEXT 	 	ptmp;	/* Packet pointer for stepping through trns */
    unsigned short	stmp;	/* Temp short for conversions    */
    int		 	ns;	/* Number of bytes actually sent            */
    static PTEXT ack = NOPKT;	/* Only an ack to be sent                   */

    if(req->prcvd_thru >= req->trns_tot) { 
	/* All our packets got through, send acks only */
	if(ack == NOPKT) {
	    ack = ardp_ptalloc();
	    /* Add header */
	    ack->start -= 9;
	    ack->length += 9;
	    *(ack->start) = (char) 9;
	    /* An unsequenced control packet */
	    bzero(ack->start+3,4);
	}
	/* Received Through */
	stmp = htons(req->rcvd_thru);
	bcopy(&stmp,ack->start+7,2);
	/* Connection ID */
	bcopy(&(req->cid),ack->start+1,2);
	ptmp = ack;
    }
    else ptmp = req->trns;

    /* Note that we don't want to get rid of packts before the */
    /* peer received through since the peer might later tell   */
    /* us it forgot them and ask us to send them again         */
    /* XXX whether this is allowable should be an application  */
    /* specific configration option.                           */
    while(ptmp) {
	if(window && (ptmp->seq > req->prcvd_thru + window)) break;
	if((ptmp->seq == 0) || (ptmp->seq > req->prcvd_thru)) {
	    if (pfs_debug >= 6) {
		if (req->peer.sin_family == AF_INET) 
		    fprintf(stderr,"Sending message (cid=%d) to %s(%d)...",
			    ntohs(req->cid), inet_ntoa(req->peer_addr), 
			    PEER_PORT(req));
		else fprintf(stderr,"Sending message...");
		(void) fflush(stderr);
	    }
	    ns = sendto(ardp_port,(char *)(ptmp->start), ptmp->length, 0, 
			&(req->peer), S_AD_SZ);
	    if(ns != ptmp->length) {
		if (pfs_debug >= 1) {
		    fprintf(stderr,"\nsent only %d/%d: ",ns, ptmp->length);
		    perror("");
		}
		return(ARDP_NOT_SENT);
	    }
	    if (pfs_debug >= 6) fprintf(stderr,"Sent.\n");
	}
	ptmp = ptmp->next;
    }
}


