/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 *
 * Written  by bcn 2/93     to send reply to request
 */

#include <usc-copyr.h>

#include <stdio.h>
#include <ardp.h>

/*
 * ardp_reply - send a reply to a request
 * 
 *   ardp_reply reply takes request to which a reply is to be sent
 *   a flags field, and a message to be sent to the client in response
 *   to the request. ardp_reply then adds the response to the output 
 *   queue for the request.
 *
 *   If space remains in the packet, the response is buffered pending
 *   subsequent replies, unless the ARDP_REPL_COMPLETE has been specified, 
 *   in which case all data is sent.  If the size of the buffered response 
 *   approaches the maximum packet size, the buffered data is sent, and
 *   and a new packet is started to hold any remaining data from the current 
 *   message.
 *
 *   The lower level function (ardp_respond) assigns packet numbers and 
 *   tags outgoing packets if necessary or a multi packet response.
 */
ardp_reply(RREQ req, 	   /* Request to which this is a response */
	   int flags,      /* Whether this is the final message   */
	   char *message)  /* The data to be sent                 */
{
    PTEXT	tpkt;	   /* Temp to hold active packet          */
    int		tmp;

    ardp_add2req(req,flags|ARDP_A2R_NOSPLITBL,message,0);

    if(flags&ARDP_R_COMPLETE) return(ardp_respond(req,ARDP_R_COMPLETE));
    
    /* Check to see if any packets are done */
    if(req->outpkt && (req->outpkt->previous != req->outpkt)) {
	/* Hold out final packet */
	tpkt = req->outpkt->previous;
	EXTRACT_ITEM(tpkt,req->outpkt);
	tmp = ardp_respond(req,ARDP_R_INCOMPLETE);
	APPEND_ITEM(tpkt,req->outpkt);
    }

    return(ARDP_SUCCESS);
}
