/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

/*
 * pmachine.h - Processor/OS specific definitions
 */

/*
 * Machine types - Supported values
 *
 *   VAX, SUN, HP9000_S300, HP9000_S700, IBM_RTPC, ENCORE_NS32K,
 *   ENCORE_S93, ENCORE_S91, APOLLO, IBM_RS6000
 * 
 *   MIPS_BE - MIPS Chip (Big Endian Byte Order)
 *   MIPS_LE - MIPS Chip (Little Endian Byte Order)
 *
 * Add others as needed.  
 *
 * Files that check these defintions:
 *   include/pmachine.h
 */
#define P_MACHINE_TYPE 		"SUN"
#define SUN

/*
 * Operating system - Supported values
 * 
 * ULTRIX, BSD43, SUNOS, SUNOS_V3, HPUX, SYSV, MACH, DOMAINOS, AIX
 *
 * Add others as needed.  
 *
 * Files that check these defintions:
 *   include/pmachine.h, lib/pcompat/opendir.c, lib/pcompat/readdir.c
 */
#define P_OS_TYPE		"SUNOS"
#define SUNOS

/*
 * Miscellaneous definitions
 *
 * Even within a particular hardware and OS type, not all systems
 * are configured identically.  Some systems may need additinal
 * definitions, some of which are included below.   Note that for
 * some system types, these are automatically defined.
 *
 * define NEED_MODE_T if mode_t is not typedefed on your system
 * define DD_SEEKLEN if your system doesn't support dd_bbase and dd_bsize
 * define DIRECT if direct is the name of your dirent structure
 * define USE_SYS_DIR_H if your system doesn't include dirent.h
 * define CLOSEDIR_RET_TYPE_VOID if your closedir returns void
 * Define GETDENTS if your system supports getdents instead of getdirentries
 * Define OPEN_MODE_ARG_IS_INT if your system has the optional third argument
 *   to open() as a mode_t.  You will need to #undef this if you're using the
 *   sysV interface to SunOS.
 * Define SIGCONTEXT_LACKS_SC_PC if your system's sigcontext structure lacks
 *   an sc_pc member.  This appears to be the case on HPUX version 8.07 on the
 *   HP 9000 series 700 workstations.  I don't know if it's the case anywhere
 *   else, and I suspect it's a bug in the release that will be fixed later.
 * Define PROTOTYPE_FOR_OPEN_HAS_EMPTY_ARGLIST if your system prototypes the
 *   open() function with an empty argument list.  This is necessary because
 *   gcc requires the prototype to match the function invocation.
 */

/*****************************************************************/
/* If your machine and OS type are listed above, and if your     */
/* configuration is relatively standard for your machine and     */
/* OS, there should be no need for any changes below this point. */
/*****************************************************************/

/*
 * Machine or OS dependent parameters
 *
 *  The comment at the head of each section names the paramter
 *  and the files that use the definition
 */

/*
 *  BYTE_ORDER: lib/psrv/plog.c, lib/psrv/check_acl.c
 */
#define BIG_ENDIAN		1
#define LITTLE_ENDIAN		2

#if defined(SUN)        || defined(HP9000_S300) || defined(HP9000_S700) || \
    defined(IBM_RTPC) || defined(IBM_RS6000)  || \
    defined(ENCORE_S91) || defined(ENCORE_S93)  || defined(APOLLO)   || \
    defined(MIPS_BE)
#define BYTE_ORDER BIG_ENDIAN
#else
#define BYTE_ORDER LITTLE_ENDIAN
#endif

/*
 * PUTENV: lib/pfs/vfsetenv.c
 *
 * PUTENV must be defined if your C library supports the putenv
 * call instead of setenv (e.g. Ultrix and SunOS).
 */
#if defined(ULTRIX) || defined(SUNOS) || defined(SUNOS_V3) || defined(HPUX)
#define PUTENV
#endif

/*
 * BADSETENV: lib/pfs/penviron.c
 *
 * Older BSD 4.3 systems have a bug in the C library routine setenv.
 * Define BADSETENV if you wish to compile a working version of this
 * this routine.
 * 
 * #define BADSETENV
 */

/*
 * NOREGEX: lib/pfs/wcmatch.c
 *
 * NOREGEX must be defined if your C library does not support the
 * re_comp and re_exec regular expression routines.
 */
#if defined(HPUX)
#define NOREGEX
#endif

/*
 * String and byte manipulating 
 * procedures: lib/pfs/sindex.c, lib/pcompat/pfs_access.c
 */
#if defined(HPUX) || defined(SYSV)
#define index		strchr
#define rindex		strrchr
#define bcopy(a,b,n)	memmove(b,a,n)
#define bzero(a,n)	memset(a,0,n)
#endif

/*
 * getwd: server/pstart.c
 */
#if defined(HPUX) || defined(SYSV)
#define getwd(d)	getcwd(d, MAXPATHLEN)
#endif

/*
 * SETSID:  server/dirsrv.c
 *
 * SETSID is to be defined if the system supports the POSIX
 * setsid routine to create a new session and set the process 
 * group ID.
 */
#if defined(HPUX)
#define SETSID
#endif

/*
 * NFILES: user/vget/pclose.c
 *
 * NFILES is the size of the descriptor table.
 */
#if defined(HPUX)
#define NFILES _NFILE
#else
#define NFILES getdtablesize()
#endif

/*
 * SIGNAL_RET_TYPE: user/vget/ftp.c, user/vget/pclose.c
 *
 * This is the type retruned by the procedure returned by
 * signal.  In some systems it is void, in others int.
 *
 */
#if defined (BSD43) || defined(SUNOS_V3)
#define SIGNAL_RET_TYPE int
#else
#define SIGNAL_RET_TYPE void
#endif

/*
 * CLOSEDIR_RET_TYPE_VOID: lib/pcompat/closedir.c
 *
 * If set, closedir returns void.
 */
#if defined (NOTDEFINED) 
#define CLOSEDIR_RET_TYPE_VOID
#endif

/*
 * DIRECT: lib/pcompat/*dir.c app/ls.c
 *
 *  Use direct as the name of the dirent struct
 */
#if defined (NOTDEFINED) || defined(DIRECT)
#define dirent direct
#endif

/*
 * USE_SYS_DIR_H: lib/pcompat/*dir.c app/ls.c
 *
 *  Include the file <sys/dir.h> instead of <dirent.h>
 */
#if defined (NOTDEFINED)
#define USE_SYS_DIR_H
#endif

/*
 * DIR structure definitions: lib/pcompat/telldir.c,opendir.c
 */
#if defined (SUNOS) || defined(SUNOS_V3)
#define dd_bbase dd_off
#endif

#if defined (DD_SEEKLEN)
#define dd_bbase dd_seek
#define dd_bsize dd_len
#endif
 
/*
 * GETDENTS: lib/pcompar/readdir.c
 *
 * Define GETDENTS if your system supports getdents instead of
 * getdirentries.
 */
#if defined (GETDENTS)
#define getdirentries(F,B,N,P) getdents(F,B,N)
#endif

/*
 * NEED MODE_T typedef: ls.c
 *
 * Define this if mode_t is not defined my your systems include
 * files (sys/types.h or sys/stdtypes.h or sys/stat.h).
 */
#if defined (NEED_MODE_T)
typedef unsigned short mode_t;
#endif

/*
 * OPEN_MODE_ARG_IS_INT: used: lib/pcompat/open.c
 * Define OPEN_MODE_ARG_IS_INT if your system has the optional third argument
 *   to open() as a mode_t.  You will need to #undef this if you're using the
 *   sysV interface to SunOS.
 */
/* Not sure how MACH and DOMAINOS actually need it; this is a guess. */
#if defined(ULTRIX) || defined(BSD43) || defined(SUNOS) || defined(SUNOS_V3) \
	|| defined(MACH) || defined(DOMAINOS)
#define OPEN_MODE_ARG_IS_INT
#endif

/*
 * SIGCONTEXT_LACKS_SC_PC typedef: server/dirsrv.c
 * 
 * Define SIGCONTEXT_LACKS_SC_PC if your system's sigcontext structure lacks
 *   an sc_pc member.  This appears to be the case on HPUX version 8.07 on the
 *   HP 9000 series 700 workstations.  I don't know if it's the case anywhere
 *   else, and I suspect it's a bug in the release that will be fixed later.
 */

#if defined(HPUX) && defined(HP9000_S700)
#define SIGCONTEXT_LACKS_SC_PC
#endif

/*
 * PROTOTYPE_FOR_OPEN_HAS_EMPTY_ARGLIST: lib/pcompat/open.c
 * See the file for how this is used.  In GCC, an old-style function prototype
 * is not compatible with a full ANSI function definition containing a ...
 * (variable argument list).  This definition makes sure that we use the
 * appropriate definition of open() to correspond with the system include
 * files.
 */
#if !defined(HPUX)
#define PROTOTYPE_FOR_OPEN_HAS_EMPTY_ARGLIST
#endif


/*
 * Catch any definitions not in system include files
 *
 *  The comment at the head of each section names the paramter
 *  and the files that use the definition
 */

/*
 * OPEN_MAX: Maximum number of files a process can have open
 */
#ifndef OPEN_MAX
#define OPEN_MAX 64
#endif

/*
 * FD_SET: lib/pfs/dirsend.c, user/vget/ftp.c
 */
#ifndef FD_SET
#define	NFDBITS		32
#define	FD_SETSIZE	32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif
 
/*
 * howmany: app/ls.c
 */
#ifndef	howmany
#define	howmany(x, y)   ((((u_int)(x))+(((u_int)(y))-1))/((u_int)(y)))
#endif

/*
 * MAXHOSTNAMELEN: user/vget/ftp.c
 */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/*
 * O_ACCMODE: lib/pcompat/open.c
 */
#ifndef O_ACCMODE
#define O_ACCMODE         (O_RDONLY|O_WRONLY|O_RDWR)
#endif

/*
 * Definitions from stat.h: app/ls.c lib/pfs/mkdirs.c
 */
#ifndef S_IFMT
#define S_IFMT	 070000
#endif
#ifndef S_IFDIR
#define S_IFDIR	 040000
#endif
#ifndef S_IFCHR
#define S_IFCHR 020000
#endif
#ifndef S_IFBLK
#define S_IFBLK 060000
#endif
#ifndef S_IXUSR
#define S_IXUSR 0100
#endif
#ifndef S_IXGRP
#define S_IXGRP 0010
#endif
#ifndef S_IXOTH
#define S_IXOTH 0001
#endif
#ifndef S_ISDIR
#define	S_ISDIR(mode)  (((mode) & S_IFMT) == S_IFDIR)
#endif
#ifndef S_ISCHR
#define S_ISCHR(m)  ((S_IFLNK & m) == S_IFCHR)
#endif  
#ifndef S_ISBLK
#define S_ISBLK(m)  ((S_IFLNK & m) == S_IFBLK)
#endif

/* The ULTRIX include files don't bother to prototype the non-ansi string
   manipulation functions.
*/
#ifdef ULTRIX
char *index(), *rindex();
#endif

