/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>
#include <perrno.h>
#include <pprot.h>
#include <rdgram.h>

extern int	perrno;
int		pfs_debug = 0;

main(argc,argv)
    int		argc;
    char	*argv[];
    {
        PTEXT		request;
	PTEXT		resp;

	char		dirhst[40];
	char		*command = "STATUS";

	argc--;argv++;

	while (argc > 0 && **argv == '-') {

	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'N':  /* Priority (nice) */
		rdgram_priority = RDGRAM_MAX_PRI; /* Use this if no # */
		sscanf(argv[0],"-N%d",&rdgram_priority);
		if(rdgram_priority > RDGRAM_MAX_SPRI) 
		    rdgram_priority = RDGRAM_MAX_PRI;
		if(rdgram_priority < RDGRAM_MIN_PRI) 
		    rdgram_priority = RDGRAM_MIN_PRI;
		break;

	    case 'v':
		command = "VERSION";
		break;
		
	    default:
		fprintf(stderr,
			"Usage: pstatus [-v] [host name]\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	request = ptalloc();

	gethostname(dirhst,40);

	if(argc > 1) {
	    fprintf(stderr,"Usage: pstatus [host name]\n");
	    exit(1);
	}

	if(argc > 0)
	    strcpy(dirhst,argv[0]);

	sprintf(request->start,"%s\n",command);

	request->length = strlen(request->start);

	printf("Sending message to %s...\n%",dirhst);
	
	resp = dirsend(request,dirhst,0);

	if(resp == NULL) {
	    perrmesg("pstatus failed: ", 0, NULL);
	    exit(1);
	}

	if(pwarn) pwarnmesg("WARNING: ",0,NULL);

	while(resp->next) resp = resp->next;

	printf("Response:\n%s",resp->start);

	if(*(resp->start+strlen(resp->start)-1) != '\n') 
	    printf("\n");

	ptlfree(resp);
	exit(0);

    }

