/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

#include <stdio.h>
#include <netdb.h>
#include <sys/param.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <pwd.h> 
 
#include <psite.h>
#include <pprot.h>
#include <pmachine.h>


#ifdef PSRV_ROOT
static char    root[40]      = PSRV_ROOT;
#else
static	char    root[40]      = "";
#endif

#ifdef AFTPDIRECTORY
static	char	aftpdir[40]   = AFTPDIRECTORY;
#else
static	char	aftpdir[40]   = "";
#endif

#ifdef AFSDIRECTORY
static	char	afsdir[40]    = AFSDIRECTORY;
#else
static	char	afsdir[40]    = "";
#endif

static struct sockaddr_in 	sin = {AF_INET};

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char			pfsdir[MAXPATHLEN];
	char			pfsdat[MAXPATHLEN];
	char			pfshadow[MAXPATHLEN];
	char			dirsrv_b[MAXPATHLEN];

	struct passwd   	*pw;
	int			ruid,euid;

	int			on = 1;
	struct servent 		*sp;
	int			prvport = -1;
	char			prvparg[30];

	if (argc > 2) {
	    fprintf(stderr,"Usage: %s [full-host-name]\n",argv[0]);
	    exit(1);
	}

	ruid = getuid();
	euid = geteuid();

	/* If root try to bind privileged port before changing uid */
	if((ruid == 0) || (euid == 0)) {
	    if ((sp = getservbyname("prospero", "udp")) == 0) 
		sin.sin_port = htons((ushort) PROSPERO_PORT);
	    else sin.sin_port = sp->s_port;

	    if ((prvport = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
		fprintf(stderr, "pstart: Can't open socket\n");

	    setsockopt(prvport, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
	    
	    if (bind(prvport, &sin, S_AD_SZ) < 0) {
		fprintf(stderr, "pstart: Can not bind privileged port\n");
		close(prvport);
		prvport = -1;
	    }
	}

	/* Find the Prospero UID, and setuid if we are root */
	if((pw = getpwnam(P_USER_ID)) == NULL) {
	    fprintf(stderr,"%s: Can't find passwd entry for %s.\n",
		    argv[0],P_USER_ID);
	    exit(1);
	}

  	if((ruid != pw->pw_uid) || (euid != pw->pw_uid)) {
	    if(setgid(pw->pw_gid)) {
  		fprintf(stderr,"%s: Can't set gid.\n",argv[0]);
  		exit(1);
  	    }

	    if(setuid(pw->pw_uid)) {
		fprintf(stderr,"%s: Can't set uid.\n",argv[0]);
		exit(1);
	    }
	}

	if(chdir(pw->pw_dir)) {
	    fprintf(stderr,"%s: Can't change working directory.\n",argv[0]);
	    exit(1);
	}

#ifdef P_UNDER_UDIR
	strcpy(pfsdir,pw->pw_dir);

	sprintf(pfsdat,"%s/%s",pfsdir,P_STORAGE);
	sprintf(pfshadow,"%s/%s",pfsdir,P_SHADOW);
#else
	strcpy(pfsdat,P_FSTORAGE);
	strcpy(pfshadow,P_FSHADOW);
#endif P_UNDER_UDIR

#ifdef AFTPUSER
	/* Find FTP directory - if error, use AFTPDIRECTORY */
	if((pw = getpwnam(AFTPUSER)) != NULL) 
	    strcpy(aftpdir,pw->pw_dir);
#endif AFTPUSER

	sprintf(dirsrv_b,"%s/dirsrv",P_BINARIES);
	if(prvport >= 0) sprintf(prvparg,"-p%d",prvport);

	umask(0);

	if(prvport >= 0)
	    execl(dirsrv_b,"dirsrv",prvparg,root,pfshadow,pfsdat,
		  aftpdir,afsdir,((argc > 1) ? argv[1] : 0), 0);
	else 
	    execl(dirsrv_b,"dirsrv",root,pfshadow,pfsdat,
		  aftpdir,afsdir,((argc > 1) ? argv[1] : 0), 0);
	
	/* Execl failed */
	exit(1);
    }
