/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

#include <netdb.h>

#include <pfs.h>
#include <perrno.h>

VLINK	check_fwd();

extern char		hostname[];

/* retrieve_fp will retrieve a forwarding pointer and will 
 * replace the changed fields of the link it is passed.
 * Retrieve will use pget_at to retriev the forwarding
 * pointer if it is on a remote host.  If the same host,
 * it will retrieve the forwardig pointer directly.
 * Retrieve fp returs PSUCCESS on success and PFAILUE
 * on failure.
 */
retrieve_fp(l)
    VLINK	l;
    {
	struct hostent	*h_ent;
	
	static int	firsttime = 0;
	static char	thishost[100];
	char		lhost[100];

	PATTRIB 	fa;          /* Forward attribute    */
	VLINK		fp;          /* Forwarding Pointer   */
	PFILE_ST	fi_st;       /* Struct for file info */
	PFILE		fi = &fi_st; /* Pointer to fi_st     */

	int		tmp;

	if(firsttime++ == 0) {
	    h_ent = gethostbyname(hostname);
	    strcpy(thishost,h_ent->h_name);
	}

	/* We should check port numbers too */

	/* Find out if link is on this host */
	h_ent = gethostbyname(l->host);
	if(h_ent) strcpy(lhost,h_ent->h_name);
	else return(PFAILURE);
	if(strcmp(lhost,thishost) == 0) { /* Local */
	    tmp = dsrfinfo(l->filename,l->f_magic_no,fi);
	    if((tmp == DSRFINFO_FORWARDED) && 
	       (fp = check_fwd(fi->forward,l->filename,l->f_magic_no))) {
		l->hosttype = stcopyr(fp->hosttype,l->hosttype);
		l->host = stcopyr(fp->host,l->host);
		l->nametype = stcopyr(fp->nametype,l->nametype);
		l->filename = stcopyr(fp->filename,l->filename);
		l->version = fp->version;
		l->f_magic_no = fp->f_magic_no;
		vllfree(fi->forward);
		vllfree(fi->backlinks);
		atlfree(fi->attributes);
		return(PSUCCESS);
	    }
	    else if(tmp <= 0) {
		vllfree(fi->forward);
		vllfree(fi->backlinks);
		atlfree(fi->attributes);
	    }
	    return(PFAILURE);
	}
	else { /* Remote */    
	    fa = pget_at(l,"FORWARDING-POINTER");
	    if(fa && (strcmp(fa->avtype,"LINK") == 0) && fa->value.link) {
		fp = fa->value.link;
		l->hosttype = stcopyr(fp->hosttype,l->hosttype);
		l->host = stcopyr(fp->host,l->host);
		l->nametype = stcopyr(fp->nametype,l->nametype);
		l->filename = stcopyr(fp->filename,l->filename);
		l->version = fp->version;
		l->f_magic_no = fp->f_magic_no;
		atlfree(fa);
		return(PSUCCESS);
	    }
	    else return(PFAILURE);
	}
    }


