/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sgtty.h>
#include <strings.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>

#include <plog.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

extern char	root[];
extern char	shadow[];
extern char	dirshadow[];
extern char	dircont[];
extern char	pfsdat[];

PATTRIB	atalloc();
VLINK check_fwd();

/*
 * dsrfinfo - Read file info from disk
 *
 *   DSFINFO is used by the directory server to read file information from
 *   disk.  It takes the host specific part of the system level name of the 
 *   file about which information is to be read, and a pointer to the file
 *   structure which it fills in.  It returns 0 or -1 on success, 0 if a file
 *   and -1 if a directory.  On error, it returns an error code.
 */
dsrfinfo(nm,magic,fi)
    char	*nm;
    int		magic;
    PFILE	fi;
    {
	FILE 		*pfs_fi = NULL;
	char		name[MAX_DIR_LINESIZE];
	char		shadow_fname[MAX_DIR_LINESIZE];
	char		dirshadow_fname[MAX_DIR_LINESIZE];
	char		line[MAX_DIR_LINESIZE];

	VLINK		cur_fp; /* current forwarding poiner */
	VLINK		lp; /* Temporary link pointer */
	int		tmp;
	char		*ls;  /* Last slash */

	struct passwd   *ownpw;
	struct group    *owngr;
	struct tm	*mt;
	char   		mtime_str[20];
	char   		mode_str[15];

	PATTRIB	at;
	PATTRIB	ap; /* Temp attribute pointer */

	struct stat	file_stat_dat;
	struct stat	*file_stat = &file_stat_dat;

	int		retval = PSUCCESS;

	strcpy(name,nm);

	fi->version = -1;
	fi->f_magic_no = 0;
	fi->exp = 0;
	fi->ttl = 0;
	fi->last_ref = 0;
	fi->forward = NULL;
	fi->backlinks = NULL;
	fi->attributes = NULL;
	fi->previous = NULL;
	fi->next = NULL;

    startover:

	/* Determine name of shadow file */
	strcpy(shadow_fname,shadow);
	strcat(shadow_fname,name);
	sprintf(dirshadow_fname,"%s/%s",shadow_fname,dirshadow);

	/* NOTE: A temporary inefficient shadow file format is*/
	/* in use.  For this reason, the code supporting it   */
	/* is also interim code, and does not do any checking */
	/* to make sure that the file actually follows        */
	/* the format.  Thus, a munged file will result       */
	/* in unpredictable results.			      */

	/* Read the contents of the shadow file */
	/* First find out if it is a directory  */
	if(stat(shadow_fname,file_stat) == 0) {
	    if(file_stat->st_mode & S_IFDIR)
		pfs_fi = fopen(dirshadow_fname,"r");
	    else pfs_fi = fopen(shadow_fname,"r");
	}

	if(pfs_fi != NULL) {
	    fi->version = 0;
	    while(fgets(line,MAX_DIR_LINESIZE,pfs_fi)) {
		switch(*line) {
		case 'V': /* Version Number */
		    tmp = sscanf(line,"VERSION %d",&(fi->version));
		    if(tmp != 1) {
			plog(L_DATA_FRM_ERR,0,0,"Bad file info format %s: %s",
			     shadow_fname,line,0);
		    }
		    break;
		case 'M': /* Magic Number */
		    tmp = sscanf(line,"MAGIC-NUMBER %d",&(fi->f_magic_no));
		    if(tmp != 1) {
			fi->f_magic_no = 0;
			plog(L_DATA_FRM_ERR,0,0,"Bad file info format %s: %s",
			     shadow_fname,line,0);
		    }
		    break;
		case 'E': /* Expiration Date */
		    break;
		case 'T': /* Time to live */
		    break;
		case 'L': /* Time of last reference */
		    break;
		case 'F': /* Forwarding Pointer */ {
		    char 	f_name[MAX_DIR_LINESIZE];
		    char 	f_htype[MAX_DIR_LINESIZE];
		    char 	f_host[MAX_DIR_LINESIZE];
		    char 	f_ntype[MAX_DIR_LINESIZE];
		    char 	f_fname[MAX_DIR_LINESIZE];

		    cur_fp = vlalloc();
		    tmp = sscanf(line,"FORWARD %s %d %s %s %s %s %d %d",
				 f_name, &(cur_fp->link_exp),
				 f_htype,f_host,
				 f_ntype,f_fname,
				 &(cur_fp->version),
				 &(cur_fp->f_magic_no));

		    if(tmp == 8) {
			cur_fp->name = stcopy(unquote(f_name));
			stfree(cur_fp->hosttype); /* Should punt if same */
			cur_fp->hosttype = stcopy(f_htype);
			cur_fp->host = stcopy(f_host);
			stfree(cur_fp->nametype); /* Should punt if same */
			cur_fp->nametype = stcopy(f_ntype);
			cur_fp->filename = stcopy(f_fname);

			if(fi->forward == NULL)
			    fi->forward = cur_fp;
			else {
			    lp = fi->forward;
			    while(lp) {
				if(lp->next == NULL) {
				    cur_fp->previous = lp;
				    lp->next = cur_fp;
				    break;
				}
				lp = lp->next;
			    }
			}
		    }
		    else {
			plog(L_DATA_FRM_ERR,0,0,"Bad file info format %s: %s",
			     shadow_fname,line,0);
			vlfree(cur_fp);
		    }
		}
		    break;
		    
		case 'B': /* Back Link */
		    break;
		case 'A': /* Attribute */ {
		    char 	a_name[MAX_DIR_LINESIZE];
		    char 	a_type[MAX_DIR_LINESIZE];
		    char 	a_value[MAX_DIR_LINESIZE];

		    tmp = sscanf(line,"ATTRIBUTE %s %s %s",
				 a_name,a_type,a_value);

		    if(tmp == 3) {
			at = atalloc();

			at->aname = stcopy(a_name);
			at->avtype = stcopy(a_type);
			at->value.ascii = stcopy(a_value);

			if(fi->attributes == NULL)
			    fi->attributes = at;
			else {
			    ap = fi->attributes;
			    while(ap) {
				if(ap->next == NULL) {
				    at->previous = ap;
				    ap->next = at;
				    break;
				}
				ap = ap->next;
			    }
			}
		    }
		    else {
			plog(L_DATA_FRM_ERR,0,0,"Bad file info format %s: %s",
			     shadow_fname,line,0);
		    }
		}
		    break;
		}
	    }

	    fclose(pfs_fi);

	    /* Determine if the file has been forwarded, and if so return, */
	    /* indicating that fact                                        */
	    if((fi->f_magic_no && magic && (fi->f_magic_no != magic)) ||
	       (fi->f_magic_no < 0) || (retval == DSRFINFO_FORWARDED)) {
		if(check_fwd(fi->forward,nm,magic))
		    return(DSRFINFO_FORWARDED);
		else goto check_above;
	    }
	}

	/* Fill in attributes from the real file */
	
	if((retval == PSUCCESS) && (stat(name,file_stat) == 0)) {
	    char		atval[MAX_DIR_LINESIZE];
	    /*       off_t   st_size;	  /* total size	of file	    */
	    at = atalloc();
	    at->aname = stcopy("SIZE");
	    at->avtype = stcopy("ASCII");
	    sprintf(atval,"%d bytes",file_stat->st_size);
	    at->value.ascii = stcopy(atval);

	    /* Find the end of the attribute list and insert */
	    if(fi->attributes == NULL) 
		fi->attributes = at;
	    else {
		ap = fi->attributes;
		while(ap) {
		    if(ap->next == NULL) {
			at->previous = ap;
			ap->next = at;
			break;
		    }
		    ap = ap->next;
		}
	    }
	    ap = at;
	    
	    /*       short   st_uid;	  /* user-id of	owner       */
	    ownpw = getpwuid(file_stat->st_uid);
	    if(ownpw) {
		at = atalloc();
		at->aname = stcopy("NATIVE-OWNER");
		at->avtype = stcopy("ASCII");
		at->value.ascii = stcopy(ownpw->pw_name);
		at->previous = ap;
		ap->next = at;
		ap = at;
	    }
	    

	    /*       short   st_gid;	  /* group-id of owner      */
	    owngr = getgrgid(file_stat->st_gid);
	    if(owngr) {
		at = atalloc();
		at->aname = stcopy("NATIVE-GROUP");
		at->avtype = stcopy("ASCII");
		at->value.ascii = stcopy(owngr->gr_name);
		at->previous = ap;
		ap->next = at;
		ap = at;
	    }

	    /*       time_t  st_atime;    /* file last access time  */

	    /*       time_t  st_mtime;    /* file last	modify time */
	    if(file_stat->st_mtime) {
		mt = gmtime(&(file_stat->st_mtime));
		sprintf(mtime_str,"%04d%02d%02d%02d%02d%02dZ",
			mt->tm_year+1900,mt->tm_mon+1,mt->tm_mday,mt->tm_hour,
			mt->tm_min,mt->tm_sec);
		at = atalloc();
		at->aname = stcopy("LAST-MODIFIED");
		at->avtype = stcopy("ASCII");
		at->value.ascii = stcopy(mtime_str);
		at->previous = ap;
		ap->next = at;
		ap = at;
	    }

	    /*       u_short st_mode;	  /* protection	            */
	    at = atalloc();
	    at->aname = stcopy("UNIX-MODES");
	    at->avtype = stcopy("ASCII");

	    strcpy(mode_str,"----------");
	    if((file_stat->st_mode & S_IFLNK) == S_IFLNK) mode_str[0] = 'l';
	    if(file_stat->st_mode & S_IREAD) mode_str[1] = 'r';
	    if(file_stat->st_mode & S_IWRITE) mode_str[2] = 'w';
	    if(file_stat->st_mode & S_IEXEC) mode_str[3] = 'x';
	    if(file_stat->st_mode & S_ISUID) mode_str[3] = 's';
	    if(file_stat->st_mode & (S_IREAD>>3)) mode_str[4] = 'r';
	    if(file_stat->st_mode & (S_IWRITE>>3)) mode_str[5] = 'w';
	    if(file_stat->st_mode & (S_IEXEC>>3)) mode_str[6] = 'x';
	    if(file_stat->st_mode & S_ISGID) mode_str[6] = 's';
	    if(file_stat->st_mode & (S_IREAD>>6)) mode_str[7] = 'r';
	    if(file_stat->st_mode & (S_IWRITE>>6)) mode_str[8] = 'w';
	    if(file_stat->st_mode & (S_IEXEC>>6)) mode_str[9] = 'x';
	    if(file_stat->st_mode & S_IFDIR) {
		mode_str[0] = 'd';
		if(retval == PSUCCESS) retval = -1;
	    }

	    at->value.ascii = stcopy(mode_str);
	    at->previous = ap;
	    ap->next = at;
	    ap = at;

        }
	/* If no native file AND no PFS file info, then look for forwarding */
	else if(fi->version < 0) goto check_above;

	return(retval);

	/* Check above looks for forwarding pointers in directories   */
	/* above the named file.  It is only reached when a file has  */
	/* moved, but a forwarding address does not exist in the      */
	/* corresponding file info.                                   */

    check_above:

	retval = DSRFINFO_FORWARDED;

	ls = rindex(name,'/');
	/* If we have used up all components, return failure */
	if((ls == 0) || (ls == name)) return(PFAILURE);

	*ls = '\0';

	goto startover;
    }


    


/* check_fwd takes a list of forwarding pointers, checks to see */
/* if any apply to the object with the specified magic number   */
/* and returns the appropiate link, or none if not forwarded    */
/* If the match is a widarded match, the returned link will be  */
/* modified so that the matched wildcard is replaced by the     */
/* text that matched it                                         */
/*                                                              */
/* BUGS only a trailing * wildcard is allowed                   */
VLINK 
check_fwd(fl,name,magic)
    VLINK	fl;
    char	*name;
    int		magic;
    {
	char	ffname[MAX_DIR_LINESIZE];
	char	*sp; /* Star pointer */

	while(fl) {
	    if(((magic == 0) || (fl->f_magic_no == 0) ||
		(fl->f_magic_no == magic)) && (wcmatch(name,fl->name))) {

		sp = index(fl->filename,'*');
		if(sp) *sp = '\0';

		sp = index(fl->name,'*');
		if(sp) {
		    sp = name + (sp - fl->name);
		    fl->name = stcopyr(name,fl->name);
		    sprintf(ffname,"%s%s",fl->filename,sp);
		    fl->filename = stcopyr(ffname,fl->filename);
		}
		
		return(fl);
	    }
	    fl = fl->next;
	}
	return(NULL);
    }    
    
